/*
 * Decompiled with CFR 0.152.
 */
package Reps;

import Exceptions.RoleException;
import Reps.Element;
import Reps.EntityRep;
import Reps.RelationshipRep;
import java.io.IOException;
import java.io.Writer;

public class Role
extends Element {
    public static final int kNormal = 0;
    public static final int kRecursiveA = 90;
    public static final int kRecursiveB = -90;
    public static final int kMaxCard = Integer.MAX_VALUE;
    private int fMinCard = 1;
    private int fMaxCard = Integer.MAX_VALUE;
    private boolean fRefIntegrity = false;
    private EntityRep fEntity = null;
    private RelationshipRep fRelationship = null;

    public Role(EntityRep entity, RelationshipRep relationship) {
        super("");
        this.fEntity = entity;
        this.fRelationship = relationship;
    }

    public void setMinCard(String minCardStr) throws RoleException {
        int minCard = minCardStr.equals("M") || minCardStr.equals("m") ? Integer.MAX_VALUE : new Integer(minCardStr);
        if (this.fRefIntegrity) {
            throw new RoleException("Turn off referential integrity first...");
        }
        if (minCard > this.fMaxCard) {
            throw new RoleException("Maximum cardinality should be greater or equal to the minimum cardinality...");
        }
        this.fMinCard = minCard;
    }

    public void setMaxCard(String maxCardStr) throws RoleException {
        int maxCard = maxCardStr.equals("N") || maxCardStr.equals("n") ? Integer.MAX_VALUE : new Integer(maxCardStr);
        if (this.fRefIntegrity) {
            throw new RoleException("Turn off referential integrity first...");
        }
        if (this.fMinCard > maxCard) {
            throw new RoleException("Maximum cardinality should be greater or equal to the minimum cardinality...");
        }
        this.fMaxCard = maxCard;
    }

    public void setRefIntegrity(boolean refIntegrity, boolean skipCheck) throws RoleException {
        if (!skipCheck && refIntegrity && (this.fMinCard != 1 || this.fMaxCard != 1)) {
            throw new RoleException("This is not an 1-1 relationship...");
        }
        this.fRefIntegrity = refIntegrity;
    }

    public String getMinCard() {
        if (this.fMinCard == Integer.MAX_VALUE) {
            return "M";
        }
        return new Integer(this.fMinCard).toString();
    }

    public String getMaxCard() {
        if (this.fMaxCard == Integer.MAX_VALUE) {
            return "N";
        }
        return new Integer(this.fMaxCard).toString();
    }

    public String getCardinality() {
        return this.getMinCard() + ".." + this.getMaxCard();
    }

    public boolean getRefIntegrity() {
        return this.fRefIntegrity;
    }

    public boolean isOneOne() {
        return this.fMinCard == 1 && this.fMaxCard == 1;
    }

    @Override
    public boolean isWeak() {
        EntityRep entity = this.fRelationship.getWeakEntity();
        if (entity == null) {
            return false;
        }
        return entity.equals(this.fEntity);
    }

    public EntityRep getEntity() {
        return this.fEntity;
    }

    public RelationshipRep getRelationship() {
        return this.fRelationship;
    }

    public int getRecursiveType() {
        if (!this.fRelationship.isRecursive(this.fEntity)) {
            return 0;
        }
        if (this.fRelationship.getFirstRecursiveRole(this.fEntity).equals(this)) {
            return 90;
        }
        return -90;
    }

    @Override
    public String check() {
        return null;
    }

    @Override
    public void write(Writer out) throws IOException {
        out.write("\t\t\t<role mincard=\"" + this.getMinCard() + "\" maxcard=\"" + this.getMaxCard() + "\" name=\"" + this.getName() + "\" entityid=\"" + this.getEntity().getID() + "\" refintegrity=\"" + this.fRefIntegrity + "\">");
        out.write("</role>\n");
    }

    @Override
    public void writeReference(Writer out) throws IOException {
    }
}

