/*
 * Decompiled with CFR 0.152.
 */
package Shapes;

import Exceptions.LineException;
import Reps.AttributeRep;
import Reps.AttributedElement;
import Reps.Element;
import Reps.Role;
import Shapes.DrawableElement;
import Shapes.Entity;
import Shapes.Handle;
import Shapes.Relationship;
import UI.Constants;
import UI.ERDiagram;
import UI.EREditor;
import UI.Panels.AttributePanel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;

public class Attribute
extends DrawableElement {
    private static AttributePanel fPanel = new AttributePanel();
    private AttributeRep fAttributeRep;
    private Ellipse2D fEllipse;

    public Attribute(ERDiagram diagram, AttributeRep attributeRep, int x, int y) {
        super(diagram, 80, 34);
        this.fAttributeRep = attributeRep;
        this.fEllipse = new Ellipse2D.Double(x - 40, y - 17, 80.0, 34.0);
    }

    @Override
    protected Color getColor() {
        return Constants.kAttributeColor;
    }

    @Override
    protected Shape getShape() {
        return this.fEllipse;
    }

    @Override
    public Element getRep() {
        return this.fAttributeRep;
    }

    @Override
    public void showPanel(ERDiagram diagram) {
        EREditor editor = diagram.getEditor();
        fPanel.update(diagram, this);
        editor.showPanel(fPanel);
    }

    @Override
    public void updateRepPosition() {
        int difX = (int)((this.getWidth() - 80.0) / 2.0);
        this.getRep().setPosition(this.getCenterX() - difX, this.getCenterY());
    }

    @Override
    public Role connect(Role role, DrawableElement drawableElement) throws LineException {
        try {
            if (!(drawableElement instanceof Entity) && !(drawableElement instanceof Relationship)) {
                throw new LineException("These elements cannot be connected...");
            }
            ((AttributedElement)drawableElement.getRep()).addAttribute(this.fAttributeRep);
            return null;
        }
        catch (Exception e) {
            throw new LineException(e.getMessage());
        }
    }

    @Override
    public boolean canBeConnectedTo(DrawableElement drawableElement) {
        if (drawableElement instanceof Entity || drawableElement instanceof Relationship) {
            return ((AttributedElement)drawableElement.getRep()).canAddAttribute(this.fAttributeRep);
        }
        return false;
    }

    @Override
    public void disconnect(Role role, DrawableElement drawableElement) throws LineException {
        try {
            if (!(drawableElement instanceof Entity) && !(drawableElement instanceof Relationship)) {
                throw new LineException("No connection found between these elements...");
            }
            ((AttributedElement)drawableElement.getRep()).removeAttribute(this.fAttributeRep);
        }
        catch (Exception e) {
            throw new LineException(e.getMessage());
        }
    }

    @Override
    protected void updateLocation(int newX, int newY) {
        this.fEllipse.setFrame((double)newX - this.getWidth() / 2.0, newY - 17, this.fEllipse.getWidth(), this.fEllipse.getHeight());
    }

    @Override
    protected ArrayList getHandles() {
        ArrayList<Handle> handles = new ArrayList<Handle>();
        int width = (int)this.getWidth();
        handles.add(new Handle(0, -17));
        handles.add(new Handle(0, 17));
        handles.add(new Handle(-(width / 2), 0));
        handles.add(new Handle(width / 2, 0));
        return handles;
    }

    @Override
    public void adjustWidthToName(ERDiagram diagram) {
        double length = this.getNameStringLength((Graphics2D)diagram.getGraphics());
        if (length > 60.0) {
            this.fEllipse.setFrame(this.fEllipse.getX(), this.fEllipse.getY(), length + 20.0, 34.0);
            this.setWidth((int)length + 20);
        } else {
            this.fEllipse.setFrame(this.fEllipse.getX(), this.fEllipse.getY(), 80.0, 34.0);
            this.setWidth(80);
        }
    }

    @Override
    public void draw(Graphics2D g2, Color color) {
        super.draw(g2, color);
        if (this.fAttributeRep.getType().equals("multivalued")) {
            g2.drawOval(this.getCenterX() - (int)this.getWidth() / 2 + 3, this.getCenterY() - 17 + 3, (int)this.getWidth() - 6, (int)this.getHeight() - 6);
        } else if (this.fAttributeRep.getType().equals("key")) {
            int nameLength = (int)this.getNameStringLength(g2);
            g2.drawLine(this.getCenterX() - nameLength / 2, this.getCenterY() + 3, this.getCenterX() - nameLength / 2 + (int)this.getNameStringLength(g2), this.getCenterY() + 3);
        }
    }
}

