/*
 * Decompiled with CFR 0.152.
 */
package Shapes;

import Exceptions.LineException;
import Reps.Element;
import Reps.Role;
import Shapes.Handle;
import Shapes.Line;
import UI.ERDiagram;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public abstract class DrawableElement {
    private ArrayList fHandles = new ArrayList();
    private int fHeight;
    private int fWidth;
    private ERDiagram fDiagram;

    public DrawableElement(ERDiagram diagram, int width, int height) {
        this.fWidth = width;
        this.fHeight = height;
        this.fHandles = this.getHandles();
        this.fDiagram = diagram;
    }

    public double getWidth() {
        return this.fWidth;
    }

    public double getHeight() {
        return this.fHeight;
    }

    protected void setWidth(int width) {
        this.fWidth = width;
        this.fHandles = this.getHandles();
    }

    public boolean inside(int testX, int testY) {
        return this.getShape().contains(testX, testY);
    }

    public void translate(int x, int y) {
        this.updateLocation(this.getCenterX() + x, this.getCenterY() + y);
    }

    protected double getNameStringLength(Graphics2D g2) {
        String name = this.getRep().getName();
        FontRenderContext frc = g2.getFontRenderContext();
        Rectangle2D bounds = g2.getFont().getStringBounds(name, frc);
        return bounds.getWidth();
    }

    public int getCenterX() {
        return (int)this.getShape().getBounds().getCenterX();
    }

    public int getCenterY() {
        return (int)this.getShape().getBounds().getCenterY();
    }

    public int getLeft() {
        return this.getCenterX() - this.fWidth / 2;
    }

    public int getRight() {
        return this.getCenterX() + this.fWidth / 2;
    }

    public int getTop() {
        return this.getCenterY() - this.fHeight / 2;
    }

    public int getBottom() {
        return this.getCenterY() + this.fHeight / 2;
    }

    public void draw(Graphics2D g2, Color color) {
        if (color != Color.lightGray && this.fDiagram.getEditor().isColoredDrawing()) {
            g2.setColor(this.getColor());
        } else {
            g2.setColor(Color.WHITE);
        }
        g2.fill(this.getShape());
        g2.setColor(color);
        g2.draw(this.getShape());
        this.drawName(g2);
    }

    public void drawHandles(Graphics2D g2) {
        for (Handle handle : this.fHandles) {
            handle.draw(this.getCenterX(), this.getCenterY(), g2);
        }
    }

    public ArrayList getConnectedLinesWith() {
        ArrayList<Line> lines = new ArrayList<Line>();
        for (DrawableElement currentElement : this.fDiagram.getElements()) {
            Line line;
            DrawableElement connectedElement;
            if (!(currentElement instanceof Line) || (connectedElement = (line = (Line)currentElement).isConnectedTo(this)) == null) continue;
            lines.add(line);
        }
        return lines;
    }

    private void drawName(Graphics2D g2) {
        String name = this.getRep().getName();
        FontRenderContext frc = g2.getFontRenderContext();
        Rectangle2D bounds = g2.getFont().getStringBounds(name, frc);
        float width = (float)bounds.getWidth();
        g2.drawString(name, (float)this.getCenterX() - width / 2.0f, (float)(this.getCenterY() + 2));
    }

    public abstract Element getRep();

    protected abstract Shape getShape();

    protected abstract Color getColor();

    public abstract void showPanel(ERDiagram var1);

    public abstract void updateRepPosition();

    public abstract void adjustWidthToName(ERDiagram var1);

    protected abstract ArrayList getHandles();

    public abstract Role connect(Role var1, DrawableElement var2) throws LineException;

    public abstract boolean canBeConnectedTo(DrawableElement var1);

    public abstract void disconnect(Role var1, DrawableElement var2) throws LineException;

    protected abstract void updateLocation(int var1, int var2);
}

