/*
 * Decompiled with CFR 0.152.
 */
package Shapes;

import Exceptions.LineException;
import Reps.AttributeRep;
import Reps.Element;
import Reps.EntityRep;
import Reps.ISARep;
import Reps.RelationshipRep;
import Reps.Role;
import Shapes.Attribute;
import Shapes.DrawableElement;
import Shapes.Handle;
import Shapes.ISA;
import Shapes.Relationship;
import UI.Constants;
import UI.ERDiagram;
import UI.EREditor;
import UI.Panels.EntityPanel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class Entity
extends DrawableElement {
    private static EntityPanel fPanel = new EntityPanel();
    private EntityRep fEntityRep;
    private Rectangle2D fRectangle;

    public Entity(ERDiagram diagram, EntityRep entityRep, int x, int y) {
        super(diagram, 90, 30);
        this.fRectangle = new Rectangle2D.Double(x - 45, y - 15, 90.0, 30.0);
        this.fEntityRep = entityRep;
    }

    @Override
    protected Shape getShape() {
        return this.fRectangle;
    }

    @Override
    public void updateRepPosition() {
        int difX = (int)((this.getWidth() - 90.0) / 2.0);
        this.getRep().setPosition(this.getCenterX() - difX, this.getCenterY());
    }

    @Override
    protected Color getColor() {
        return Constants.kEntityColor;
    }

    @Override
    public Element getRep() {
        return this.fEntityRep;
    }

    @Override
    public void showPanel(ERDiagram diagram) {
        EREditor editor = diagram.getEditor();
        fPanel.update(diagram, this);
        editor.showPanel(fPanel);
    }

    @Override
    public Role connect(Role role, DrawableElement drawableElement) throws LineException {
        try {
            if (drawableElement instanceof Attribute) {
                this.fEntityRep.addAttribute((AttributeRep)drawableElement.getRep());
            } else if (drawableElement instanceof Relationship) {
                if (role == null) {
                    role = new Role(this.fEntityRep, (RelationshipRep)drawableElement.getRep());
                }
                ((RelationshipRep)drawableElement.getRep()).addRole(role);
            } else if (drawableElement instanceof ISA) {
                ((ISARep)drawableElement.getRep()).setSuperEntity(this.fEntityRep);
            } else {
                throw new LineException("These elements cannot be connected...");
            }
            return role;
        }
        catch (Exception e) {
            throw new LineException(e.getMessage());
        }
    }

    @Override
    public boolean canBeConnectedTo(DrawableElement drawableElement) {
        Role role = null;
        if (drawableElement instanceof Attribute) {
            return this.fEntityRep.canAddAttribute((AttributeRep)drawableElement.getRep());
        }
        if (drawableElement instanceof Relationship) {
            role = new Role(this.fEntityRep, (RelationshipRep)drawableElement.getRep());
            return ((RelationshipRep)drawableElement.getRep()).canAddRole(role);
        }
        if (drawableElement instanceof ISA) {
            return ((ISARep)drawableElement.getRep()).canSetSuperEntity(this.fEntityRep);
        }
        return false;
    }

    @Override
    public void disconnect(Role role, DrawableElement drawableElement) throws LineException {
        block5: {
            try {
                if (drawableElement instanceof Attribute) {
                    this.fEntityRep.removeAttribute((AttributeRep)drawableElement.getRep());
                    break block5;
                }
                if (drawableElement instanceof Relationship) {
                    ((RelationshipRep)drawableElement.getRep()).removeRole(role);
                    break block5;
                }
                if (drawableElement instanceof ISA) {
                    ((ISARep)drawableElement.getRep()).removeEntity(this.fEntityRep);
                    break block5;
                }
                throw new LineException("No connection found between these elements...");
            }
            catch (Exception e) {
                throw new LineException(e.getMessage());
            }
        }
    }

    @Override
    protected void updateLocation(int newX, int newY) {
        this.fRectangle.setFrame((double)newX - this.getWidth() / 2.0, newY - 15, this.fRectangle.getWidth(), this.fRectangle.getHeight());
    }

    @Override
    protected ArrayList getHandles() {
        ArrayList<Handle> handles = new ArrayList<Handle>();
        int width = (int)this.getWidth();
        handles.add(new Handle(-(width / 2), -15));
        handles.add(new Handle(width / 2, -15));
        handles.add(new Handle(width / 2, 15));
        handles.add(new Handle(-(width / 2), 15));
        return handles;
    }

    @Override
    public void adjustWidthToName(ERDiagram diagram) {
        double length = this.getNameStringLength((Graphics2D)diagram.getGraphics());
        if (length > 70.0) {
            this.fRectangle.setFrame(this.fRectangle.getX(), this.fRectangle.getY(), length + 20.0, 30.0);
            this.setWidth((int)length + 20);
        } else {
            this.fRectangle.setFrame(this.fRectangle.getX(), this.fRectangle.getY(), 90.0, 30.0);
            this.setWidth(90);
        }
    }

    @Override
    public void draw(Graphics2D g2, Color color) {
        super.draw(g2, color);
        if (this.fEntityRep.isWeak()) {
            g2.draw(new Rectangle2D.Double((double)this.getCenterX() - this.getWidth() / 2.0 + 3.0, (double)this.getCenterY() - this.getHeight() / 2.0 + 3.0, this.getWidth() - 6.0, this.getHeight() - 6.0));
        }
    }
}

