/*
 * Decompiled with CFR 0.152.
 */
package Shapes;

import Exceptions.LineException;
import Reps.Element;
import Reps.EntityRep;
import Reps.ISARep;
import Reps.Role;
import Shapes.DrawableElement;
import Shapes.Entity;
import Shapes.Handle;
import UI.Constants;
import UI.ERDiagram;
import UI.EREditor;
import UI.Panels.ISAPanel;
import java.awt.Color;
import java.awt.Polygon;
import java.awt.Shape;
import java.util.ArrayList;

public class ISA
extends DrawableElement {
    private static ISAPanel fPanel = new ISAPanel();
    private ISARep fIsaRep;
    private Polygon fTriangle = new Polygon();

    public ISA(ERDiagram diagram, ISARep isaRep, int x, int y) {
        super(diagram, 60, 40);
        int[] xPoints = new int[]{x - 30, x, x + 30};
        int[] yPoints = new int[]{y + 20, y - 20, y + 20};
        this.fTriangle.xpoints = xPoints;
        this.fTriangle.ypoints = yPoints;
        this.fTriangle.npoints = 3;
        this.fIsaRep = isaRep;
    }

    @Override
    public void updateRepPosition() {
        int difX = (int)((this.getWidth() - 60.0) / 2.0);
        this.getRep().setPosition(this.getCenterX() - difX, this.getCenterY());
    }

    @Override
    protected Color getColor() {
        return Constants.kISAColor;
    }

    @Override
    protected Shape getShape() {
        return this.fTriangle;
    }

    @Override
    public Element getRep() {
        return this.fIsaRep;
    }

    @Override
    public void showPanel(ERDiagram diagram) {
        EREditor editor = diagram.getEditor();
        fPanel.update(diagram, this);
        editor.showPanel(fPanel);
    }

    @Override
    public void adjustWidthToName(ERDiagram diagram) {
    }

    @Override
    public Role connect(Role role, DrawableElement drawableElement) throws LineException {
        try {
            if (!(drawableElement instanceof Entity)) {
                throw new LineException("These elements cannot be connected...");
            }
            this.fIsaRep.addSubEntity((EntityRep)drawableElement.getRep());
            return null;
        }
        catch (Exception e) {
            throw new LineException(e.getMessage());
        }
    }

    @Override
    public boolean canBeConnectedTo(DrawableElement drawableElement) {
        if (drawableElement instanceof Entity) {
            return this.fIsaRep.canAddSubEntity((EntityRep)drawableElement.getRep());
        }
        return false;
    }

    @Override
    public void disconnect(Role role, DrawableElement drawableElement) throws LineException {
        try {
            if (!(drawableElement instanceof Entity)) {
                throw new LineException("No connection found between these elements...");
            }
            this.fIsaRep.removeEntity((EntityRep)drawableElement.getRep());
        }
        catch (Exception e) {
            throw new LineException(e.getMessage());
        }
    }

    @Override
    protected void updateLocation(int newX, int newY) {
        int[] xPoints = new int[]{newX - 30, newX, newX + 30};
        int[] yPoints = new int[]{newY + 20, newY - 20, newY + 20};
        this.fTriangle.xpoints = xPoints;
        this.fTriangle.ypoints = yPoints;
        this.fTriangle.invalidate();
    }

    @Override
    protected ArrayList getHandles() {
        ArrayList<Handle> handles = new ArrayList<Handle>();
        handles.add(new Handle(-30, 20));
        handles.add(new Handle(0, -20));
        handles.add(new Handle(30, 20));
        return handles;
    }
}

