/*
 * Decompiled with CFR 0.152.
 */
package Shapes;

import Exceptions.LineException;
import Reps.Element;
import Reps.Role;
import Shapes.DrawableElement;
import Shapes.Relationship;
import UI.Constants;
import UI.ERDiagram;
import UI.EREditor;
import UI.Panels.LinePanel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class Line
extends DrawableElement {
    private static LinePanel fPanel = new LinePanel();
    private Role fRole;
    private Line2D fLine = new Line2D.Double();
    private DrawableElement fShape1;
    private DrawableElement fShape2;
    private double fAngle;
    private double fLength;
    private Point2D.Double fArcPoint;

    public Line(ERDiagram diagram, Role role, DrawableElement drawableElement1, DrawableElement drawableElement2) {
        super(diagram, 0, 0);
        if (drawableElement1 instanceof Relationship) {
            this.fShape1 = drawableElement1;
            this.fShape2 = drawableElement2;
        } else {
            this.fShape2 = drawableElement1;
            this.fShape1 = drawableElement2;
        }
        this.fRole = role;
        this.updateLocation(0, 0);
    }

    @Override
    protected Color getColor() {
        return Constants.kLineColor;
    }

    @Override
    public void updateRepPosition() {
    }

    @Override
    public void showPanel(ERDiagram diagram) {
        EREditor editor = diagram.getEditor();
        if (this.fRole != null) {
            fPanel.update(diagram, this);
            editor.showPanel(fPanel);
        }
    }

    @Override
    protected void updateLocation(int newX, int newY) {
        int recursiveLine;
        this.fLine.setLine(this.fShape1.getCenterX(), this.fShape1.getCenterY(), this.fShape2.getCenterX(), this.fShape2.getCenterY());
        this.fLength = this.fLine.getP1().distance(this.fLine.getP2());
        this.fAngle = Math.atan2(this.fLine.getY2() - this.fLine.getY1(), this.fLine.getX2() - this.fLine.getX1());
        this.fAngle = Math.toDegrees(this.fAngle);
        if (this.fAngle < 0.0) {
            this.fAngle += 360.0;
        }
        if (this.fRole != null && (recursiveLine = this.fRole.getRecursiveType()) != 0) {
            double angleValue1 = this.fShape1.getHeight() / 2.0 - 4.0;
            double angleValue2 = this.fShape2.getHeight() / 2.0 - 4.0;
            Point2D.Double p1 = new Point2D.Double(this.fLine.getX1() + angleValue1 * Math.cos(Math.toRadians(this.fAngle + (double)recursiveLine)), this.fLine.getY1() + angleValue1 * Math.sin(Math.toRadians(this.fAngle + (double)recursiveLine)));
            Point2D.Double p2 = new Point2D.Double(this.fLine.getX2() + angleValue2 * Math.cos(Math.toRadians(this.fAngle + (double)recursiveLine)), this.fLine.getY2() + angleValue2 * Math.sin(Math.toRadians(this.fAngle + (double)recursiveLine)));
            this.fLine.setLine(p1, p2);
        }
        double maxLength = this.fAngle > 35.0 && this.fAngle < 47.0 || this.fAngle > 133.0 && this.fAngle < 145.0 || this.fAngle > 215.0 && this.fAngle < 227.0 || this.fAngle > 313.0 && this.fAngle < 325.0 ? 160.0 : (this.fAngle <= 35.0 || this.fAngle >= 325.0 || this.fAngle >= 145.0 && this.fAngle <= 215.0 ? 210.0 : 110.0);
        double t = this.fLength > maxLength ? 0.7 : 0.7 / (1.0 / (this.fLength / maxLength));
        double a = (1.0 - t) * this.fLine.getX1() + t * this.fLine.getX2();
        double b = (1.0 - t) * this.fLine.getY1() + t * this.fLine.getY2();
        this.fArcPoint = new Point2D.Double(a, b);
    }

    @Override
    public Role connect(Role role, DrawableElement drawableElement) throws LineException {
        throw new LineException("These elements cannot be connected...");
    }

    @Override
    public boolean canBeConnectedTo(DrawableElement drawableElement) {
        return false;
    }

    @Override
    public void disconnect(Role role, DrawableElement drawableElement) throws LineException {
    }

    @Override
    public boolean inside(int testX, int testY) {
        return this.fLine.ptSegDist(testX, testY) < 5.0;
    }

    @Override
    public int getCenterX() {
        return (int)Math.abs(this.fLine.getX2() + this.fLine.getX1()) / 2;
    }

    @Override
    public int getCenterY() {
        return (int)Math.abs(this.fLine.getY2() + this.fLine.getY1()) / 2;
    }

    public DrawableElement getShape1() {
        return this.fShape1;
    }

    public DrawableElement getShape2() {
        return this.fShape2;
    }

    @Override
    protected Shape getShape() {
        return this.fLine;
    }

    @Override
    public Element getRep() {
        return this.fRole;
    }

    @Override
    protected ArrayList getHandles() {
        return new ArrayList();
    }

    @Override
    public void adjustWidthToName(ERDiagram diagram) {
    }

    @Override
    public void draw(Graphics2D g2, Color color) {
        this.updateLocation(0, 0);
        g2.setColor(color);
        if (this.fRole == null) {
            g2.draw(this.fLine);
        } else {
            if (this.fRole.isWeak()) {
                this.drawWeakLine(g2);
            } else {
                g2.draw(this.fLine);
                this.drawCardinality(g2);
            }
            if (this.fRole.getRefIntegrity()) {
                this.drawRefIntegrityArrow(g2);
            }
            if (this.fRole.getName() != "") {
                this.drawRoleName(g2);
            }
        }
    }

    public DrawableElement isConnectedTo(DrawableElement drawableElement) {
        if (drawableElement == this.fShape1) {
            return this.fShape2;
        }
        if (drawableElement == this.fShape2) {
            return this.fShape1;
        }
        return null;
    }

    private void drawRefIntegrityArrow(Graphics2D g2) {
        double arcRad = 12.5;
        Arc2D.Double arc = new Arc2D.Double(this.fArcPoint.getX() - arcRad, this.fArcPoint.getY() - arcRad, arcRad * 2.0, arcRad * 2.0, 270.0 - this.fAngle, 180.0, 0);
        g2.draw(arc);
    }

    private void drawCardinality(Graphics2D g2) {
        g2.drawString(this.fRole.getCardinality(), this.getCenterX(), this.getCenterY());
    }

    private void drawRoleName(Graphics2D g2) {
        g2.drawString(this.fRole.getName(), (int)this.fArcPoint.x, (int)this.fArcPoint.y);
    }

    private void drawWeakLine(Graphics2D g2) {
        Point2D.Double p1 = new Point2D.Double(this.fLine.getX1() + 2.0 * Math.cos(Math.toRadians(this.fAngle + 90.0)), this.fLine.getY1() + 2.0 * Math.sin(Math.toRadians(this.fAngle + 90.0)));
        Point2D.Double p2 = new Point2D.Double(this.fLine.getX2() + 2.0 * Math.cos(Math.toRadians(this.fAngle + 90.0)), this.fLine.getY2() + 2.0 * Math.sin(Math.toRadians(this.fAngle + 90.0)));
        g2.draw(new Line2D.Double(p1, p2));
        Point2D.Double p3 = new Point2D.Double(this.fLine.getX1() + 2.0 * Math.cos(Math.toRadians(this.fAngle - 90.0)), this.fLine.getY1() + 2.0 * Math.sin(Math.toRadians(this.fAngle - 90.0)));
        Point2D.Double p4 = new Point2D.Double(this.fLine.getX2() + 2.0 * Math.cos(Math.toRadians(this.fAngle - 90.0)), this.fLine.getY2() + 2.0 * Math.sin(Math.toRadians(this.fAngle - 90.0)));
        g2.draw(new Line2D.Double(p3, p4));
    }
}

