/*
 * Decompiled with CFR 0.152.
 */
package Shapes;

import Exceptions.LineException;
import Reps.AttributeRep;
import Reps.Element;
import Reps.EntityRep;
import Reps.RelationshipRep;
import Reps.Role;
import Shapes.Attribute;
import Shapes.DrawableElement;
import Shapes.Entity;
import Shapes.Handle;
import UI.Constants;
import UI.ERDiagram;
import UI.EREditor;
import UI.Panels.ElementPanel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.util.ArrayList;

public class Relationship
extends DrawableElement {
    private static ElementPanel fPanel = new ElementPanel();
    private RelationshipRep fRelationshipRep;
    private Polygon fDiamond = new Polygon();

    public Relationship(ERDiagram diagram, RelationshipRep relationshipRep, int x, int y) {
        super(diagram, 80, 50);
        int[] xPoints = new int[]{x - 40, x, x + 40, x};
        int[] yPoints = new int[]{y, y - 25, y, y + 25};
        this.fDiamond.xpoints = xPoints;
        this.fDiamond.ypoints = yPoints;
        this.fDiamond.npoints = 4;
        this.fRelationshipRep = relationshipRep;
    }

    @Override
    protected Shape getShape() {
        return this.fDiamond;
    }

    @Override
    public void updateRepPosition() {
        int difX = (int)((this.getWidth() - 80.0) / 2.0);
        this.getRep().setPosition(this.getCenterX() - difX, this.getCenterY());
    }

    @Override
    protected Color getColor() {
        return Constants.kRelationshipColor;
    }

    @Override
    public Element getRep() {
        return this.fRelationshipRep;
    }

    @Override
    public void showPanel(ERDiagram diagram) {
        EREditor editor = diagram.getEditor();
        fPanel.update(diagram, this);
        editor.showPanel(fPanel);
    }

    @Override
    public Role connect(Role role, DrawableElement drawableElement) throws LineException {
        try {
            if (drawableElement instanceof Attribute) {
                this.fRelationshipRep.addAttribute((AttributeRep)drawableElement.getRep());
            } else if (drawableElement instanceof Entity) {
                if (role == null) {
                    role = new Role((EntityRep)drawableElement.getRep(), this.fRelationshipRep);
                }
                this.fRelationshipRep.addRole(role);
            } else {
                throw new LineException("These elements cannot be connected...");
            }
            return role;
        }
        catch (Exception e) {
            throw new LineException(e.getMessage());
        }
    }

    @Override
    public boolean canBeConnectedTo(DrawableElement drawableElement) {
        if (drawableElement instanceof Attribute) {
            return this.fRelationshipRep.canAddAttribute((AttributeRep)drawableElement.getRep());
        }
        if (drawableElement instanceof Entity) {
            Role role = new Role((EntityRep)drawableElement.getRep(), this.fRelationshipRep);
            return this.fRelationshipRep.canAddRole(role);
        }
        return false;
    }

    @Override
    public void disconnect(Role role, DrawableElement drawableElement) throws LineException {
        block4: {
            try {
                if (drawableElement instanceof Attribute) {
                    this.fRelationshipRep.removeAttribute((AttributeRep)drawableElement.getRep());
                    break block4;
                }
                if (drawableElement instanceof Entity) {
                    this.fRelationshipRep.removeRole(role);
                    break block4;
                }
                throw new LineException("No connection found between these elements...");
            }
            catch (Exception e) {
                throw new LineException(e.getMessage());
            }
        }
    }

    @Override
    protected void updateLocation(int newX, int newY) {
        int[] xPoints = new int[]{newX - (int)this.getWidth() / 2, newX, newX + (int)this.getWidth() / 2, newX};
        int[] yPoints = new int[]{newY, newY - 25, newY, newY + 25};
        this.fDiamond.xpoints = xPoints;
        this.fDiamond.ypoints = yPoints;
        this.fDiamond.npoints = 4;
        this.fDiamond.invalidate();
    }

    @Override
    protected ArrayList getHandles() {
        ArrayList<Handle> handles = new ArrayList<Handle>();
        int width = (int)this.getWidth();
        handles.add(new Handle(-(width / 2), 0));
        handles.add(new Handle(0, -25));
        handles.add(new Handle(width / 2, 0));
        handles.add(new Handle(0, 25));
        return handles;
    }

    @Override
    public void adjustWidthToName(ERDiagram diagram) {
        double length = this.getNameStringLength((Graphics2D)diagram.getGraphics());
        if (length > 60.0) {
            int[] xPoints = new int[]{this.fDiamond.xpoints[0], this.fDiamond.xpoints[0] + (int)length / 2 + 20, this.fDiamond.xpoints[0] + (int)length + 40, this.fDiamond.xpoints[0] + (int)length / 2 + 20};
            this.fDiamond.xpoints = xPoints;
            this.fDiamond.invalidate();
            this.setWidth((int)length + 40);
        } else {
            int[] xPoints = new int[]{this.fDiamond.xpoints[0], this.fDiamond.xpoints[0] + 40, this.fDiamond.xpoints[0] + 80, this.fDiamond.xpoints[0] + 40};
            this.fDiamond.xpoints = xPoints;
            this.fDiamond.invalidate();
            this.setWidth(80);
        }
    }

    @Override
    public void draw(Graphics2D g2, Color color) {
        super.draw(g2, color);
        if (this.fRelationshipRep.isWeak()) {
            int[] xPoints = new int[]{this.fDiamond.xpoints[0] + 6, this.fDiamond.xpoints[1], this.fDiamond.xpoints[2] - 6, this.fDiamond.xpoints[3]};
            int[] yPoints = new int[]{this.fDiamond.ypoints[0], this.fDiamond.ypoints[1] + 5, this.fDiamond.ypoints[2], this.fDiamond.ypoints[3] - 5};
            g2.draw(new Polygon(xPoints, yPoints, 4));
        }
    }
}

