/*
 * Decompiled with CFR 0.152.
 */
package UI;

import Reps.Role;
import Shapes.DrawableElement;
import Shapes.Line;
import UI.ERDiagram;
import javax.swing.JOptionPane;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class ActionAdd
extends AbstractUndoableEdit {
    private ERDiagram fDiagram;
    private DrawableElement fElement;
    private boolean fUnedited;

    public ActionAdd(ERDiagram diagram, DrawableElement element) {
        diagram.getEditor().setStatusMessage(" ");
        this.fDiagram = diagram;
        this.fElement = element;
        this.fUnedited = this.fDiagram.isUnedited();
        this.fDiagram.setUnedited(false);
    }

    @Override
    public void undo() throws CannotUndoException {
        this.fDiagram.deselect(this.fElement);
        this.fDiagram.delete(this.fElement);
        this.fDiagram.setUnedited(this.fUnedited);
        this.fDiagram.repaint();
    }

    @Override
    public void redo() throws CannotRedoException {
        try {
            if (this.fElement instanceof Line) {
                Line line = (Line)this.fElement;
                line.getShape2().connect((Role)line.getRep(), line.getShape1());
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Unknown Error. Please report this to gerthelsen@pandora.be", "Redo Error", 0);
        }
        this.fDiagram.add(this.fElement);
        this.fDiagram.setUnedited(false);
        this.fDiagram.repaint();
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public String getPresentationName() {
        return "Add Element";
    }
}

