/*
 * Decompiled with CFR 0.152.
 */
package UI;

import Reps.AttributeRep;
import Reps.Element;
import Reps.EntityRep;
import Reps.RelationshipRep;
import Reps.Role;
import Shapes.DrawableElement;
import UI.ERDiagram;
import javax.swing.JOptionPane;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class ActionChangeProperty
extends AbstractUndoableEdit {
    private ERDiagram fDiagram;
    private DrawableElement fElement;
    private Element fElementRep;
    private String fPropertyName;
    private String fOldValue;
    private String fNewValue;
    private RelationshipRep fRelationship;
    private boolean fUnedited;

    public ActionChangeProperty(ERDiagram diagram, DrawableElement element, String propertyName, String oldValue, String newValue) {
        diagram.getEditor().setStatusMessage(" ");
        this.fDiagram = diagram;
        this.fElement = element;
        this.fElementRep = element.getRep();
        this.fPropertyName = propertyName;
        this.fOldValue = oldValue;
        this.fNewValue = newValue;
        this.fUnedited = this.fDiagram.isUnedited();
        this.fDiagram.setUnedited(false);
    }

    public ActionChangeProperty(ERDiagram diagram, DrawableElement element, String propertyName, String oldValue, String newValue, EntityRep entity, RelationshipRep relationship) {
        diagram.getEditor().setStatusMessage(" ");
        this.fDiagram = diagram;
        this.fElement = element;
        this.fElementRep = entity;
        this.fPropertyName = propertyName;
        this.fOldValue = oldValue;
        this.fNewValue = newValue;
        this.fRelationship = relationship;
        this.fUnedited = this.fDiagram.isUnedited();
        this.fDiagram.setUnedited(false);
    }

    @Override
    public void undo() throws CannotUndoException {
        try {
            if (this.fPropertyName.equals("Name")) {
                this.fElementRep.setName(this.fOldValue);
                this.fElement.adjustWidthToName(this.fDiagram);
            } else if (this.fPropertyName.equals("Weak")) {
                if (Boolean.valueOf(this.fNewValue).booleanValue()) {
                    ((EntityRep)this.fElement.getRep()).removeDependency(this.fRelationship);
                } else {
                    ((EntityRep)this.fElement.getRep()).addDependency(this.fRelationship, false);
                }
            } else if (this.fPropertyName.equals("Type")) {
                ((AttributeRep)this.fElementRep).setType(this.fOldValue);
            } else if (this.fPropertyName.equals("Required")) {
                ((AttributeRep)this.fElementRep).setRequired(Boolean.valueOf(this.fOldValue));
            } else if (this.fPropertyName.equals("Unique")) {
                ((AttributeRep)this.fElementRep).setUnique(Boolean.valueOf(this.fOldValue));
            } else if (this.fPropertyName.equals("DataType")) {
                ((AttributeRep)this.fElementRep).setDataType(this.fOldValue);
            } else if (this.fPropertyName.equals("Length")) {
                ((AttributeRep)this.fElementRep).setLength(Integer.valueOf(this.fOldValue));
            } else if (this.fPropertyName.equals("MinCard")) {
                ((Role)this.fElementRep).setMinCard(this.fOldValue);
            } else if (this.fPropertyName.equals("MaxCard")) {
                ((Role)this.fElementRep).setMaxCard(this.fOldValue);
            } else if (this.fPropertyName.equals("RefIntegrity")) {
                ((Role)this.fElementRep).setRefIntegrity(Boolean.valueOf(this.fOldValue), false);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Unknown Error", "Undo Error", 0);
        }
        this.fDiagram.setUnedited(this.fUnedited);
        this.fDiagram.getEditor().repaint();
    }

    @Override
    public void redo() throws CannotRedoException {
        try {
            if (this.fPropertyName.equals("Name")) {
                this.fElementRep.setName(this.fNewValue);
                this.fElement.adjustWidthToName(this.fDiagram);
            } else if (this.fPropertyName.equals("Type")) {
                ((AttributeRep)this.fElementRep).setType(this.fNewValue);
            } else if (this.fPropertyName.equals("Weak")) {
                if (Boolean.valueOf(this.fNewValue).booleanValue()) {
                    ((EntityRep)this.fElement.getRep()).addDependency(this.fRelationship, false);
                } else {
                    ((EntityRep)this.fElement.getRep()).removeDependency(this.fRelationship);
                }
            } else if (this.fPropertyName.equals("Required")) {
                ((AttributeRep)this.fElementRep).setRequired(Boolean.valueOf(this.fNewValue));
            } else if (this.fPropertyName.equals("Unique")) {
                ((AttributeRep)this.fElementRep).setUnique(Boolean.valueOf(this.fNewValue));
            } else if (this.fPropertyName.equals("DataType")) {
                ((AttributeRep)this.fElementRep).setDataType(this.fNewValue);
            } else if (this.fPropertyName.equals("Length")) {
                ((AttributeRep)this.fElementRep).setLength(Integer.valueOf(this.fNewValue));
            } else if (this.fPropertyName.equals("MinCard")) {
                ((Role)this.fElementRep).setMinCard(this.fNewValue);
            } else if (this.fPropertyName.equals("MaxCard")) {
                ((Role)this.fElementRep).setMaxCard(this.fNewValue);
            } else if (this.fPropertyName.equals("RefIntegrity")) {
                ((Role)this.fElementRep).setRefIntegrity(Boolean.valueOf(this.fNewValue), false);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Unknown Error. Please report this to gerthelsen@pandora.be", "Redo Error", 0);
        }
        this.fDiagram.setUnedited(false);
        this.fDiagram.getEditor().repaint();
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public String getPresentationName() {
        return "Change " + this.fPropertyName;
    }
}

