/*
 * Decompiled with CFR 0.152.
 */
package UI;

import Reps.EntityRep;
import Reps.RelationshipRep;
import Reps.Role;
import Shapes.DrawableElement;
import Shapes.Entity;
import Shapes.Line;
import UI.ERDiagram;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class ActionDelete
extends AbstractUndoableEdit {
    private ERDiagram fDiagram;
    private ArrayList fMainElements = new ArrayList();
    private ArrayList fConnectedLines = new ArrayList();
    private HashMap fDependencies = new HashMap();
    private boolean fUnedited;

    public ActionDelete(ERDiagram diagram, ArrayList selection) {
        diagram.getEditor().setStatusMessage(" ");
        this.fDiagram = diagram;
        this.fUnedited = this.fDiagram.isUnedited();
        this.fDiagram.setUnedited(false);
        for (DrawableElement element : selection) {
            this.fMainElements.add(element);
            for (Line line : element.getConnectedLinesWith()) {
                if (this.fConnectedLines.contains(line) || this.fMainElements.contains(line)) continue;
                this.fConnectedLines.add(line);
            }
        }
        for (DrawableElement element : diagram.getElements()) {
            if (!(element instanceof Entity)) continue;
            EntityRep entity = (EntityRep)element.getRep();
            for (RelationshipRep relationship : entity.getDependentRelationships()) {
                if (this.fDependencies.containsKey(relationship)) continue;
                this.fDependencies.put(relationship, relationship.getWeakEntity());
            }
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        try {
            for (DrawableElement element : this.fMainElements) {
                if (element instanceof Line) {
                    Line line = (Line)element;
                    this.fDiagram.add(line);
                    line.getShape2().connect((Role)line.getRep(), line.getShape1());
                    continue;
                }
                this.fDiagram.add(element);
            }
            for (Line line : this.fConnectedLines) {
                this.fDiagram.add(line);
                line.getShape2().connect((Role)line.getRep(), line.getShape1());
            }
            for (RelationshipRep relationship : this.fDependencies.keySet()) {
                EntityRep weakEntity = (EntityRep)this.fDependencies.get(relationship);
                if (weakEntity.hasDependency(relationship)) continue;
                weakEntity.addDependency(relationship, true);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Unknown Error. Please report this to gerthelsen@pandora.be", "Redo Error", 0);
        }
        this.fDiagram.setUnedited(this.fUnedited);
        this.fDiagram.repaint();
    }

    @Override
    public void redo() throws CannotRedoException {
        for (DrawableElement element : this.fMainElements) {
            this.fDiagram.delete(element);
        }
        this.fDiagram.setUnedited(false);
        this.fDiagram.repaint();
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public String getPresentationName() {
        return "Delete Selection";
    }
}

