/*
 * Decompiled with CFR 0.152.
 */
package UI;

import Shapes.DrawableElement;
import UI.ERDiagram;
import java.util.ArrayList;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class ActionTranslate
extends AbstractUndoableEdit {
    private ERDiagram fDiagram;
    private ArrayList fElements = new ArrayList();
    private int fX;
    private int fY;
    private boolean fUnedited;

    public ActionTranslate(ERDiagram diagram, ArrayList selection, int x, int y) {
        diagram.getEditor().setStatusMessage(" ");
        this.fDiagram = diagram;
        this.fElements.addAll(selection);
        this.fX = x;
        this.fY = y;
        this.fUnedited = this.fDiagram.isUnedited();
        this.fDiagram.setUnedited(false);
    }

    @Override
    public void undo() throws CannotUndoException {
        for (DrawableElement element : this.fElements) {
            element.translate(-this.fX, -this.fY);
        }
        this.fDiagram.setUnedited(this.fUnedited);
        this.fDiagram.repaint();
    }

    @Override
    public void redo() throws CannotRedoException {
        for (DrawableElement element : this.fElements) {
            element.translate(this.fX, this.fY);
        }
        this.fDiagram.setUnedited(false);
        this.fDiagram.repaint();
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public String getPresentationName() {
        return "Translation";
    }
}

