/*
 * Decompiled with CFR 0.152.
 */
package UI;

import Exceptions.LineException;
import Mapping.Relation;
import Reps.AttributeRep;
import Reps.AttributedElement;
import Reps.Element;
import Reps.EntityRep;
import Reps.ISARep;
import Reps.RelationshipRep;
import Reps.Role;
import Shapes.Attribute;
import Shapes.DrawableElement;
import Shapes.Entity;
import Shapes.ISA;
import Shapes.Line;
import Shapes.Relationship;
import UI.ActionAdd;
import UI.ActionAdjustFrameSize;
import UI.ActionDelete;
import UI.ActionTranslate;
import UI.Constants;
import UI.ERDiagramFrame;
import UI.EREditor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.JPanel;

public class ERDiagram
extends JPanel
implements MouseListener,
MouseMotionListener {
    private ArrayList fDrawableElements = new ArrayList();
    private ArrayList fPickedElements = new ArrayList();
    private EREditor fEditor;
    private ERDiagramFrame fDiagramFrame;
    private Dimension fArea;
    private Line2D fLine;
    private int fAction;
    private DrawableElement fLeftElement;
    private DrawableElement fRightElement;
    private DrawableElement fTopElement;
    private DrawableElement fBottomElement;
    private Rectangle2D fSelection;
    private int fDownX;
    private int fDownY;
    private int fStartX;
    private int fStopX;
    private int fStartY;
    private int fStopY;
    private int fPrevDragX;
    private int fPrevDragY;
    private DrawableElement fConnectedElement;
    private ArrayList fRelations = new ArrayList();
    private boolean fIsUnedited;

    public ERDiagram(EREditor editor, ERDiagramFrame frame) {
        this.fEditor = editor;
        this.fDiagramFrame = frame;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.init();
    }

    private void init() {
        this.fDrawableElements.clear();
        this.fPickedElements.clear();
        this.fConnectedElement = null;
        this.fLine = null;
        this.fSelection = new Rectangle2D.Double();
        this.fArea = new Dimension(0, 0);
        this.setUnedited(true);
        this.fAction = 0;
    }

    public boolean isUnedited() {
        return this.fIsUnedited;
    }

    public void setUnedited(boolean unedited) {
        this.fIsUnedited = unedited;
        if (unedited) {
            this.fDiagramFrame.setTitle(this.fDiagramFrame.getName());
        } else {
            this.fDiagramFrame.setTitle(this.fDiagramFrame.getName() + "*");
        }
    }

    public void add(DrawableElement element) {
        if (element instanceof Line) {
            this.fDrawableElements.add(0, element);
        } else {
            this.fDrawableElements.add(element);
        }
        this.adjustPanelToSelection();
    }

    public void addWithUndo(DrawableElement element) {
        ActionAdd edit = new ActionAdd(this, element);
        this.add(element);
        this.fEditor.fUndoSupport.postEdit(edit);
    }

    public void adjustFrameSizeWithUndo() {
        ActionAdjustFrameSize edit = new ActionAdjustFrameSize(this, this.fArea.width, this.fArea.height);
        this.adjustFrameSize();
        this.fEditor.fUndoSupport.postEdit(edit);
    }

    public void deleteWithUndo() {
        ActionDelete edit = new ActionDelete(this, this.fPickedElements);
        this.deleteSelection();
        this.fEditor.fUndoSupport.postEdit(edit);
    }

    private void translateWithUndo(int x, int y) {
        ActionTranslate edit = new ActionTranslate(this, this.fPickedElements, x, y);
        this.fEditor.fUndoSupport.postEdit(edit);
    }

    public String check() {
        String reason = "";
        Iterator itDrawableElements = this.fDrawableElements.iterator();
        while (itDrawableElements.hasNext()) {
            String str;
            Element element = ((DrawableElement)itDrawableElements.next()).getRep();
            if (element == null || (str = element.check()) == null) continue;
            reason = reason + "\n" + str;
        }
        if (reason.length() > 500) {
            reason = "To many errors.";
        }
        return reason;
    }

    public void delete(DrawableElement element) {
        try {
            if (element instanceof Line) {
                Line line = (Line)element;
                Role role = (Role)element.getRep();
                line.getShape1().disconnect(role, line.getShape2());
            } else {
                for (Line line : element.getConnectedLinesWith()) {
                    element.disconnect((Role)line.getRep(), line.isConnectedTo(element));
                    this.fDrawableElements.remove(line);
                }
            }
            this.fDrawableElements.remove(element);
            if (element == this.fConnectedElement) {
                this.fConnectedElement = null;
                this.fAction = 0;
            }
            this.adjustPanelToSelection();
        }
        catch (LineException e) {
            this.fEditor.setStatusMessage(e.getMessage());
        }
    }

    public void deleteSelection() {
        Iterator itPickedElements = this.fPickedElements.iterator();
        while (itPickedElements.hasNext()) {
            DrawableElement element = (DrawableElement)itPickedElements.next();
            itPickedElements.remove();
            this.delete(element);
        }
        this.fAction = 0;
    }

    private void updateSelectionBounds() {
        this.fLeftElement = null;
        this.fTopElement = null;
        this.fRightElement = null;
        this.fBottomElement = null;
        for (DrawableElement element : this.fPickedElements) {
            if (element instanceof Line) continue;
            if (this.fLeftElement == null || element.getLeft() < this.fLeftElement.getLeft()) {
                this.fLeftElement = element;
            }
            if (this.fTopElement == null || element.getTop() < this.fTopElement.getTop()) {
                this.fTopElement = element;
            }
            if (this.fRightElement == null || element.getRight() > this.fRightElement.getRight()) {
                this.fRightElement = element;
            }
            if (this.fBottomElement != null && element.getBottom() <= this.fBottomElement.getBottom()) continue;
            this.fBottomElement = element;
        }
    }

    public final void selectAll() {
        this.fPickedElements.clear();
        this.fPickedElements.addAll(this.fDrawableElements);
        this.adjustPanelToSelection();
        this.fAction = 0;
    }

    public final void deselectAll() {
        this.fPickedElements.clear();
        this.adjustPanelToSelection();
    }

    public Image getImage() {
        Frame f = new Frame();
        f.addNotify();
        Image img = f.createImage(this.getWidth(), this.getHeight());
        Graphics2D g2d = (Graphics2D)img.getGraphics();
        this.revalidate();
        this.paint(g2d);
        return img;
    }

    private DrawableElement findElement(int x, int y) {
        ListIterator itDrawableElements = this.fDrawableElements.listIterator(this.fDrawableElements.size());
        while (itDrawableElements.hasPrevious()) {
            DrawableElement currentElement = (DrawableElement)itDrawableElements.previous();
            if (!currentElement.inside(x, y)) continue;
            return currentElement;
        }
        return null;
    }

    public String getSQL() {
        ArrayList relationsToDo = new ArrayList();
        relationsToDo.addAll(this.getMapping());
        String sql = "";
        while (!relationsToDo.isEmpty()) {
            Iterator itRelations = relationsToDo.iterator();
            while (itRelations.hasNext()) {
                Relation relation = (Relation)itRelations.next();
                boolean ok = true;
                ArrayList references = relation.getReferences();
                for (Relation relationToDo : relationsToDo) {
                    if (!references.contains(relationToDo.getName())) continue;
                    ok = false;
                }
                if (!ok) continue;
                sql = sql + relation.getSQL();
                sql = sql + "\n";
                itRelations.remove();
            }
        }
        return sql;
    }

    public ArrayList getElements() {
        return this.fDrawableElements;
    }

    public ArrayList getMapping() {
        this.fRelations.clear();
        for (DrawableElement drawableElement : this.fDrawableElements) {
            Relation newRelation;
            Element currentElement;
            if (drawableElement.getRep() instanceof AttributedElement) {
                currentElement = (AttributedElement)drawableElement.getRep();
                newRelation = ((AttributedElement)currentElement).getMappedRelation();
                if (newRelation == null) continue;
                Relation oldRelation = this.getRelation(newRelation.getName());
                if (oldRelation != null) {
                    if (newRelation.getNrAttributes() <= oldRelation.getNrAttributes()) continue;
                    this.fRelations.add(newRelation);
                    this.fRelations.remove(oldRelation);
                    continue;
                }
                this.fRelations.add(newRelation);
                continue;
            }
            if (!(drawableElement instanceof Attribute) || (newRelation = ((AttributeRep)(currentElement = (AttributeRep)drawableElement.getRep())).getMappedRelation()) == null) continue;
            this.fRelations.add(newRelation);
        }
        return this.fRelations;
    }

    private Relation getRelation(String name) {
        for (Relation relation : this.fRelations) {
            if (relation.getName() != name) continue;
            return relation;
        }
        return null;
    }

    protected void deselect(DrawableElement element) {
        this.fPickedElements.remove(element);
        this.adjustPanelToSelection();
    }

    private void select(DrawableElement element, boolean deselectAllFirst) {
        if (deselectAllFirst) {
            this.deselectAll();
        }
        this.fPickedElements.add(element);
        this.adjustPanelToSelection();
    }

    public void select(Rectangle2D selection) {
        this.fPickedElements.clear();
        for (DrawableElement currentElement : this.fDrawableElements) {
            if (!selection.contains(currentElement.getCenterX(), currentElement.getCenterY())) continue;
            this.fPickedElements.add(currentElement);
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        super.paint(g);
        if (this.fEditor.isSmoothDrawing()) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.fAction == 1) {
            g2.setColor(Constants.kSelectionColor);
            g2.draw(this.fSelection);
        }
        if (this.fAction == 2) {
            g2.setColor(Color.black);
            g2.draw(this.fLine);
            this.drawPossibleConnections(g2);
        } else {
            for (DrawableElement element : this.fDrawableElements) {
                if (this.fPickedElements.contains(element)) {
                    element.draw(g2, Constants.kSelectionColor);
                    element.drawHandles(g2);
                    continue;
                }
                element.draw(g2, Color.black);
            }
        }
    }

    private void drawPossibleConnections(Graphics2D g2) {
        for (DrawableElement el : this.fDrawableElements) {
            if (this.fConnectedElement.canBeConnectedTo(el) || !this.fEditor.isIntelligentDrawing()) {
                el.draw(g2, Color.black);
                continue;
            }
            el.draw(g2, Color.lightGray);
        }
    }

    public EREditor getEditor() {
        return this.fEditor;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        DrawableElement connectedElement;
        if (e.getButton() != 1) {
            this.fAction = 0;
            this.repaint();
            return;
        }
        int x = e.getX();
        int y = e.getY();
        this.fDownX = x;
        this.fDownY = y;
        this.fStartX = x;
        this.fStartY = y;
        this.fStopX = x;
        this.fStopY = y;
        this.fPrevDragX = x;
        this.fPrevDragY = y;
        int drawObject = this.fEditor.getCurrentDrawObject();
        if (this.fAction != 2) {
            DrawableElement newElement = null;
            switch (drawObject) {
                case 0: {
                    DrawableElement element = this.findElement(x, y);
                    if (element != null) {
                        if (!this.fPickedElements.contains(element)) {
                            this.select(element, true);
                        }
                        this.fAction = 3;
                        this.repaint();
                    } else {
                        this.deselectAll();
                        this.fAction = 1;
                    }
                    this.updateSelectionBounds();
                    return;
                }
                case 1: {
                    newElement = new Entity(this, new EntityRep(), x, y);
                    break;
                }
                case 2: {
                    newElement = new Attribute(this, new AttributeRep(), x, y);
                    if (!this.fEditor.isIntelligentDrawing()) break;
                    this.fConnectedElement = newElement;
                    this.fLine = new Line2D.Double();
                    this.fAction = 2;
                    break;
                }
                case 3: {
                    newElement = new Relationship(this, new RelationshipRep(), x, y);
                    break;
                }
                case 4: {
                    newElement = new ISA(this, new ISARep(), x, y);
                }
            }
            if (newElement != null) {
                this.addWithUndo(newElement);
                this.select(newElement, true);
                this.updateFrameSize(x, y);
                return;
            }
        }
        if ((connectedElement = this.findElement(x, y)) != null && !(connectedElement instanceof Line)) {
            if (this.fAction == 2) {
                this.fAction = 0;
                this.fLine = null;
                try {
                    Role role = this.fConnectedElement.connect(null, connectedElement);
                    Line line = new Line(this, role, this.fConnectedElement, connectedElement);
                    this.addWithUndo(line);
                }
                catch (LineException e2) {
                    this.fEditor.setStatusMessage(e2.getMessage());
                }
            } else {
                this.fConnectedElement = connectedElement;
                this.fAction = 2;
                this.fLine = new Line2D.Double();
            }
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.fAction == 2) {
            this.fLine.setLine(this.fConnectedElement.getCenterX(), this.fConnectedElement.getCenterY(), e.getX(), e.getY());
            this.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.fAction == 0) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        if (this.fPickedElements.isEmpty() || this.fAction == 1) {
            int y2;
            int y1;
            int x2;
            int x1;
            if (x < this.fDownX) {
                x1 = x;
                x2 = this.fDownX;
            } else {
                x1 = this.fDownX;
                x2 = x;
            }
            if (y < this.fDownY) {
                y1 = y;
                y2 = this.fDownY;
            } else {
                y1 = this.fDownY;
                y2 = y;
            }
            this.fSelection.setFrame(x1, y1, x2 - x1, y2 - y1);
            this.select(this.fSelection);
            this.repaint();
            return;
        }
        if (this.fEditor.getCurrentDrawObject() == 0) {
            if (this.fPickedElements.size() == 1 && this.fPickedElements.get(0) instanceof Line) {
                return;
            }
            int minX = this.fLeftElement.getLeft();
            int minY = this.fTopElement.getTop();
            int maxX = this.fRightElement.getRight();
            int maxY = this.fBottomElement.getBottom();
            int transX = minX + (x - this.fPrevDragX) <= 0 ? (x < this.fPrevDragX ? 0 : x - this.fPrevDragX) : x - this.fPrevDragX;
            int transY = minY + (y - this.fPrevDragY) <= 0 ? (y < this.fPrevDragY ? 0 : y - this.fPrevDragY) : y - this.fPrevDragY;
            this.updateFrameSize(maxX + transX, maxY + transY);
            for (DrawableElement currentElement : this.fPickedElements) {
                currentElement.translate(transX, transY);
            }
            this.fStopX += transX;
            this.fStopY += transY;
            Rectangle rect = new Rectangle(x, y, 0, 0);
            this.scrollRectToVisible(rect);
            this.fPrevDragX = x;
            this.fPrevDragY = y;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.fAction == 1) {
            this.repaint();
            this.fAction = 0;
            this.adjustPanelToSelection();
        } else if (this.fAction == 3) {
            if (this.fStopX != this.fStartX || this.fStopY != this.fStartY) {
                this.translateWithUndo(this.fStopX - this.fStartX, this.fStopY - this.fStartY);
            }
            this.fAction = 0;
        }
    }

    public void updateFrameSize(int x, int y) {
        boolean changed = false;
        if (x > this.fArea.width) {
            this.fArea.width = x;
            changed = true;
        }
        if (y > this.fArea.height) {
            this.fArea.height = y;
            changed = true;
        }
        if (changed) {
            this.setPreferredSize(this.fArea);
            this.revalidate();
        }
        this.repaint();
    }

    public void adjustFrameSize() {
        int maxX = 0;
        int maxY = 0;
        for (DrawableElement element : this.fDrawableElements) {
            int x = element.getRight();
            int y = element.getBottom();
            if (x > maxX) {
                maxX = x;
            }
            if (y <= maxY) continue;
            maxY = y;
        }
        this.fArea.width = maxX + 10;
        this.fArea.height = maxY + 10;
        this.setPreferredSize(this.fArea);
        this.revalidate();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void write(Writer out) throws IOException {
        Element element;
        out.write("<?xml version='1.0'?>\n");
        out.write("<diagram>\n");
        out.write("\t<elements>\n");
        for (DrawableElement drawableElement : this.fDrawableElements) {
            drawableElement.updateRepPosition();
            element = drawableElement.getRep();
            if (element == null || element instanceof Role) continue;
            element.write(out);
        }
        out.write("\t</elements>\n");
        for (DrawableElement drawableElement : this.fDrawableElements) {
            element = drawableElement.getRep();
            if (element == null || element instanceof AttributeRep) continue;
            element.writeReference(out);
        }
        out.write("</diagram>\n");
        out.flush();
    }

    private void adjustPanelToSelection() {
        if (this.fPickedElements.size() == 1) {
            DrawableElement element = (DrawableElement)this.fPickedElements.get(0);
            element.showPanel(this);
        } else {
            this.fEditor.hidePanel();
        }
    }
}

