/*
 * Decompiled with CFR 0.152.
 */
package UI;

import Exceptions.FileException;
import Export.GifEncoder;
import UI.ERDiagramFrame;
import UI.GIFFileFilter;
import UI.Panels.ElementPanel;
import UI.Panels.MapPanel;
import UI.Panels.SQLPanel;
import UI.Parser;
import UI.XMLFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;

public class EREditor
extends JFrame {
    public UndoManager fUndoManager;
    public UndoableEditSupport fUndoSupport;
    private EREditor fEditor = this;
    private JDesktopPane fDesktopPane;
    private JToolBar toolbar;
    private JScrollPane fInfoScrollPane;
    private StatusBar fStatusBar;
    private ButtonGroup fDrawButtonGroup;
    private JButton[] buttons;
    private JToggleButton[] drawButtons;
    private JMenuItem[] fileActions;
    private JMenuItem[] editActions;
    private JMenuItem[] drawActions;
    private JMenuItem[] extraActions;
    private JMenuItem[] helpActions;
    private ElementPanel fCurrentPanel;
    private ERDiagramFrame fCurrentDiagram;
    private JFileChooser fChooser;
    private JFileChooser fGifChooser;
    private int fCurrentDrawObject = 0;
    private boolean fIntelligentDraw = true;
    private boolean fSmoothDraw = false;
    private boolean fColoredDraw = false;

    public EREditor() {
        super("ER-Editor 2.0");
        this.setLocation(200, 200);
        this.setIconImage(new ImageIcon("Images/icon.gif").getImage());
        this.getContentPane().setLayout(new BorderLayout());
        this.fChooser = new JFileChooser();
        this.fGifChooser = new JFileChooser();
        this.fChooser.setFileFilter(new XMLFileFilter());
        this.fGifChooser.setFileFilter(new GIFFileFilter());
        this.frameInit();
        this.setCurrentDiagram(null);
        this.fUndoManager = new UndoManager();
        this.fUndoSupport = new UndoableEditSupport();
        this.fUndoSupport.addUndoableEditListener(new UndoAdapter());
        this.refreshUndoRedo();
    }

    @Override
    protected void frameInit() {
        int i;
        super.frameInit();
        this.fileActions = new JMenuItem[]{new JMenuItem(new FileNewAction()), new JMenuItem(new FileOpenAction()), new JMenuItem(new FileSaveAction()), new JMenuItem(new FileSaveAsAction()), new JMenuItem(new FileCloseAction()), new JMenuItem(new FileCopyToClipboardAction()), new JMenuItem(new FileExportAction()), new JMenuItem(new FileExitAction())};
        this.fileActions[0].setAccelerator(KeyStroke.getKeyStroke(78, 128));
        this.fileActions[1].setAccelerator(KeyStroke.getKeyStroke(79, 128));
        this.fileActions[2].setAccelerator(KeyStroke.getKeyStroke(83, 128));
        this.fileActions[5].setAccelerator(KeyStroke.getKeyStroke(67, 128));
        this.fileActions[6].setAccelerator(KeyStroke.getKeyStroke(69, 128));
        JMenu fileMenu = new JMenu("File");
        for (int i2 = 0; i2 < this.fileActions.length; ++i2) {
            fileMenu.add(this.fileActions[i2]);
            if (i2 != 4 && i2 != 6) continue;
            fileMenu.addSeparator();
        }
        this.editActions = new JMenuItem[]{new JMenuItem(new EditUndoAction()), new JMenuItem(new EditRedoAction()), new JMenuItem(new EditDeleteAction()), new JMenuItem(new EditSelectAllAction()), new JMenuItem(new EditDeselectAllAction()), new JMenuItem(new EditAdjustFrameSizeAction())};
        this.editActions[0].setAccelerator(KeyStroke.getKeyStroke(90, 128));
        this.editActions[1].setAccelerator(KeyStroke.getKeyStroke(89, 128));
        this.editActions[3].setAccelerator(KeyStroke.getKeyStroke(65, 128));
        this.editActions[2].setAccelerator(KeyStroke.getKeyStroke(127, 0));
        JMenu editMenu = new JMenu("Edit");
        for (int i3 = 0; i3 < this.editActions.length; ++i3) {
            editMenu.add(this.editActions[i3]);
            if (i3 != 1 && i3 != 2 && i3 != 4) continue;
            editMenu.addSeparator();
        }
        this.drawActions = new JMenuItem[]{new JMenuItem(new DrawEditAction()), new JMenuItem(new DrawEntityAction()), new JMenuItem(new DrawAttributeAction()), new JMenuItem(new DrawRelationshipAction()), new JMenuItem(new DrawISAAction()), new JMenuItem(new DrawLineAction())};
        this.drawActions[0].setAccelerator(KeyStroke.getKeyStroke(48, 128));
        this.drawActions[1].setAccelerator(KeyStroke.getKeyStroke(49, 128));
        this.drawActions[2].setAccelerator(KeyStroke.getKeyStroke(50, 128));
        this.drawActions[3].setAccelerator(KeyStroke.getKeyStroke(51, 128));
        this.drawActions[4].setAccelerator(KeyStroke.getKeyStroke(52, 128));
        this.drawActions[5].setAccelerator(KeyStroke.getKeyStroke(53, 128));
        JMenu drawMenu = new JMenu("Draw");
        for (int i4 = 0; i4 < this.drawActions.length; ++i4) {
            drawMenu.add(this.drawActions[i4]);
        }
        this.extraActions = new JMenuItem[]{new JMenuItem(new ExtraCheckAction()), new JMenuItem(new ExtraMapAction()), new JMenuItem(new ExtraSQLAction()), new JCheckBoxMenuItem(new ExtraIntelligentDraw()), new JCheckBoxMenuItem(new ExtraColoredDraw()), new JCheckBoxMenuItem(new ExtraSmoothDraw())};
        JMenu extraMenu = new JMenu("Extra");
        for (int i5 = 0; i5 < this.extraActions.length; ++i5) {
            extraMenu.add(this.extraActions[i5]);
            if (i5 != 2) continue;
            extraMenu.addSeparator();
        }
        ((JCheckBoxMenuItem)this.extraActions[3]).setState(this.fIntelligentDraw);
        ((JCheckBoxMenuItem)this.extraActions[4]).setState(this.fColoredDraw);
        ((JCheckBoxMenuItem)this.extraActions[5]).setState(this.fSmoothDraw);
        this.helpActions = new JMenuItem[]{new JMenuItem(new HelpHelpAction()), new JMenuItem(new HelpAboutAction())};
        this.helpActions[0].setAccelerator(KeyStroke.getKeyStroke(112, 0));
        JMenu helpMenu = new JMenu("Help");
        for (int i6 = 0; i6 < this.helpActions.length; ++i6) {
            helpMenu.add(this.helpActions[i6]);
        }
        JMenuBar menubar = new JMenuBar();
        menubar.add(fileMenu);
        menubar.add(editMenu);
        menubar.add(drawMenu);
        menubar.add(extraMenu);
        menubar.add(helpMenu);
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.toolbar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.buttons = new JButton[]{new JButton(this.fileActions[0].getAction()), new JButton(this.fileActions[1].getAction()), new JButton(this.fileActions[2].getAction()), new JButton(this.extraActions[0].getAction()), new JButton(this.extraActions[1].getAction()), new JButton(this.extraActions[2].getAction())};
        for (i = 0; i < 3; ++i) {
            this.buttons[i].setText("");
            this.toolbar.add(this.buttons[i]);
        }
        this.buttons[0].setToolTipText("New diagram");
        this.buttons[1].setToolTipText("Open a diagram");
        this.buttons[2].setToolTipText("Save this diagram");
        this.buttons[3].setToolTipText("Check diagram for errors");
        this.buttons[4].setToolTipText("Map diagram to relational model");
        this.buttons[5].setToolTipText("Generate SQL code");
        this.drawButtons = new JToggleButton[]{new JToggleButton(this.drawActions[0].getAction()), new JToggleButton(this.drawActions[1].getAction()), new JToggleButton(this.drawActions[2].getAction()), new JToggleButton(this.drawActions[3].getAction()), new JToggleButton(this.drawActions[4].getAction()), new JToggleButton(this.drawActions[5].getAction())};
        this.toolbar.addSeparator();
        this.fDrawButtonGroup = new ButtonGroup();
        for (i = 0; i < this.drawButtons.length; ++i) {
            this.drawButtons[i].setText("");
            this.fDrawButtonGroup.add(this.drawButtons[i]);
            this.toolbar.add(this.drawButtons[i]);
        }
        this.drawButtons[0].setToolTipText("Edit");
        this.drawButtons[1].setToolTipText("Draw an entity");
        this.drawButtons[2].setToolTipText("Draw an attribute");
        this.drawButtons[3].setToolTipText("Draw a relationship");
        this.drawButtons[4].setToolTipText("Draw an ISA relationship");
        this.drawButtons[5].setToolTipText("Draw a line");
        this.toolbar.addSeparator();
        for (i = 3; i < this.buttons.length; ++i) {
            this.buttons[i].setText("");
            this.toolbar.add(this.buttons[i]);
        }
        Container contentPane = this.getContentPane();
        contentPane.add((Component)this.toolbar, "North");
        this.setJMenuBar(menubar);
        this.fDesktopPane = new JDesktopPane();
        Dimension windowSize = this.getToolkit().getScreenSize();
        this.fDesktopPane.setPreferredSize(new Dimension(windowSize.width - 250, windowSize.height));
        this.fInfoScrollPane = new JScrollPane();
        JSplitPane splitPane = new JSplitPane(1, this.fDesktopPane, this.fInfoScrollPane);
        splitPane.setDividerSize(6);
        contentPane.add(splitPane);
        this.fStatusBar = new StatusBar("Welcome to the ER Editor...");
        contentPane.add((Component)this.fStatusBar, "South");
        this.setDefaultCloseOperation(0);
    }

    public int getCurrentDrawObject() {
        return this.fCurrentDrawObject;
    }

    public boolean isIntelligentDrawing() {
        return this.fIntelligentDraw;
    }

    public boolean isSmoothDrawing() {
        return this.fSmoothDraw;
    }

    public boolean isColoredDrawing() {
        return this.fColoredDraw;
    }

    private void refreshUndoRedo() {
        this.editActions[0].setEnabled(this.fUndoManager.canUndo());
        this.editActions[0].setText(this.fUndoManager.getUndoPresentationName());
        this.editActions[1].setEnabled(this.fUndoManager.canRedo());
        this.editActions[1].setText(this.fUndoManager.getRedoPresentationName());
    }

    public void showPanel(ElementPanel panel) {
        this.fInfoScrollPane.setViewportView(panel);
        this.fInfoScrollPane.setVisible(true);
        this.fCurrentPanel = panel;
    }

    public void hidePanel() {
        this.fInfoScrollPane.setViewport(null);
        if (this.fCurrentPanel != null) {
            this.fCurrentPanel.removeFocus();
        }
        this.fCurrentPanel = null;
    }

    public void exit() {
        JInternalFrame[] diagramFrames = this.fDesktopPane.getAllFrames();
        for (int i = 0; i < diagramFrames.length; ++i) {
            this.fCurrentDiagram = (ERDiagramFrame)diagramFrames[i];
            if (this.closeDiagram() == 1) continue;
            return;
        }
        this.dispose();
        System.exit(0);
    }

    protected int closeDiagram() {
        if (this.fCurrentDiagram != null) {
            if (!this.fCurrentDiagram.getDiagram().isUnedited()) {
                int n = JOptionPane.showConfirmDialog(this, "Would you like to save changes ?", "Close " + this.fCurrentDiagram.getTitle(), 1, 3);
                switch (n) {
                    case 0: {
                        try {
                            this.saveDiagram();
                            break;
                        }
                        catch (FileException e) {
                            JOptionPane.showMessageDialog(this.fEditor, e.getMessage(), "Save Diagram", 0);
                            return 0;
                        }
                    }
                    case 2: {
                        return 0;
                    }
                    case -1: {
                        return 0;
                    }
                }
            }
            this.fDesktopPane.getDesktopManager().closeFrame(this.fCurrentDiagram);
            --ERDiagramFrame.fFramesOpen;
            this.fDesktopPane.revalidate();
            this.fDesktopPane.repaint();
            if (this.fDesktopPane.getSelectedFrame() == null) {
                this.fCurrentDiagram = null;
                this.fUndoManager.discardAllEdits();
                this.refreshUndoRedo();
                this.hidePanel();
            } else {
                this.fCurrentDiagram = (ERDiagramFrame)this.fDesktopPane.getSelectedFrame();
                this.hidePanel();
            }
            this.updateMenuVisibility();
        }
        return 1;
    }

    public void updateMenuVisibility() {
        int i;
        boolean setVisible = this.fCurrentDiagram != null;
        for (i = 2; i < 7; ++i) {
            this.fileActions[i].setEnabled(setVisible);
        }
        for (i = 2; i < 6; ++i) {
            this.editActions[i].setEnabled(setVisible);
        }
        for (i = 0; i < this.drawActions.length; ++i) {
            this.drawActions[i].setEnabled(setVisible);
        }
        for (i = 0; i < 3; ++i) {
            this.extraActions[i].setEnabled(setVisible);
        }
        for (i = 2; i < this.buttons.length; ++i) {
            this.buttons[i].setEnabled(setVisible);
        }
        for (i = 0; i < this.drawButtons.length; ++i) {
            this.drawButtons[i].setEnabled(setVisible);
        }
    }

    protected void setCurrentDiagram(ERDiagramFrame diagramFrame) {
        this.fCurrentDiagram = diagramFrame;
        this.updateMenuVisibility();
    }

    protected void newDiagram() {
        ERDiagramFrame diagramFrame = new ERDiagramFrame(this);
        this.fDesktopPane.add((Component)diagramFrame, JLayeredPane.DEFAULT_LAYER);
        diagramFrame.setVisible(true);
    }

    public void setStatusMessage(String message) {
        this.fStatusBar.setStatus(message);
    }

    protected void openDiagram() {
        this.fChooser.setSelectedFile(null);
        int n = this.fChooser.showOpenDialog(this);
        if (n == 0) {
            File file = this.fChooser.getSelectedFile();
            try {
                this.newDiagram();
                Parser parser = new Parser(this.fCurrentDiagram.getDiagram());
                parser.run(file);
                this.fCurrentDiagram.setFile(file);
                this.fCurrentDiagram.getDiagram().setUnedited(true);
                this.fCurrentDiagram.setSaved(true);
                this.fCurrentDiagram.getDiagram().adjustFrameSize();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Open an XML File", 0);
            }
        }
        this.repaint();
    }

    protected synchronized void saveDiagramAs() {
        this.fChooser.setSelectedFile(null);
        int n = this.fChooser.showSaveDialog(this);
        if (n == 0) {
            String fileName = this.fChooser.getSelectedFile().getName();
            File file = new File(this.fChooser.getCurrentDirectory(), fileName);
            String filePath = file.getPath();
            if (!filePath.endsWith(".xml") && !filePath.endsWith(".XML")) {
                filePath = filePath + ".xml";
                file = new File(filePath);
            }
            if (file.exists() && 1 == JOptionPane.showConfirmDialog(this, file.getName() + " already exists. Overwrite ?", "Confirm Save As", 0, 2)) {
                return;
            }
            try {
                this.fCurrentDiagram.setSaved(true);
                this.fCurrentDiagram.setFile(file);
                this.saveDiagram();
            }
            catch (FileException e) {
                JOptionPane.showMessageDialog(this.fEditor, e.getMessage(), "Save Diagram", 0);
                this.fCurrentDiagram.setFile(null);
                this.fCurrentDiagram.setSaved(false);
                this.saveDiagramAs();
                return;
            }
        }
        this.repaint();
    }

    protected void exportDiagram() {
        int n = this.fGifChooser.showSaveDialog(this);
        if (n == 0) {
            String fileName = this.fGifChooser.getSelectedFile().getName();
            File file = new File(this.fGifChooser.getCurrentDirectory(), fileName);
            String filePath = file.getPath();
            if (!filePath.endsWith(".gif") && !filePath.endsWith(".GIF")) {
                filePath = filePath + ".gif";
                file = new File(filePath);
            }
            try {
                FileOutputStream out = new FileOutputStream(file);
                Image image = this.fCurrentDiagram.getDiagram().getImage();
                new GifEncoder(image, (OutputStream)out).encode();
                out.flush();
                out.close();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.fEditor, "Illegal File. GIF can not be saved.", "Export to GIF", 0);
                this.exportDiagram();
            }
        }
    }

    protected void copyToClipboard() {
        Image image = this.fCurrentDiagram.getDiagram().getImage();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        ImageSelection imgSel = new ImageSelection(image);
        clipboard.setContents(imgSel, null);
    }

    protected synchronized void saveDiagram() throws FileException {
        if (this.fCurrentDiagram.isSaved()) {
            try {
                FileOutputStream out = new FileOutputStream(this.fCurrentDiagram.getFile());
                BufferedWriter output = new BufferedWriter(new OutputStreamWriter(out));
                this.fCurrentDiagram.getDiagram().write(output);
                output.flush();
                output.close();
            }
            catch (Exception e) {
                throw new FileException("Illegal File. Diagram can not be saved.");
            }
            this.fCurrentDiagram.getDiagram().setUnedited(true);
        } else {
            this.saveDiagramAs();
        }
    }

    private class UndoAdapter
    implements UndoableEditListener {
        private UndoAdapter() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent evt) {
            UndoableEdit edit = evt.getEdit();
            EREditor.this.fUndoManager.addEdit(edit);
            EREditor.this.refreshUndoRedo();
        }
    }

    public static class ImageSelection
    implements Transferable {
        private Image fImage;

        public ImageSelection(Image image) {
            this.fImage = image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.imageFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!DataFlavor.imageFlavor.equals(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.fImage;
        }
    }

    public class StatusBar
    extends JPanel {
        JLabel fLblStatus;

        public StatusBar(String status) {
            super(new BorderLayout(0, 0));
            this.fLblStatus = null;
            this.fLblStatus = new JLabel(status);
            this.fLblStatus.setBorder(BorderFactory.createLoweredBevelBorder());
            this.add((Component)this.fLblStatus, "Center");
        }

        public void setStatus(String text) {
            this.fLblStatus.setText(text);
        }
    }

    class HelpAboutAction
    extends AbstractAction {
        public HelpAboutAction() {
            super("About...", new ImageIcon("Images/about.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String msg = "ER-Editor Copyright 2002-2003\nAuthor: Gert Helsen (gerthelsen@pandora.be)";
            JOptionPane.showMessageDialog((Component)event.getSource(), msg, "About ER-Editor: version 2.0", 1);
        }
    }

    class HelpHelpAction
    extends AbstractAction {
        public HelpHelpAction() {
            super("Help...", new ImageIcon("Images/help.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String msg = "Look for the help PDF file in the directory of this program.";
            JOptionPane.showMessageDialog((Component)event.getSource(), msg, "ER-Editor Help", 1);
        }
    }

    class ExtraSmoothDraw
    extends AbstractAction {
        public ExtraSmoothDraw() {
            super("Smooth Drawing");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            EREditor.this.fSmoothDraw = !EREditor.this.fSmoothDraw;
            if (EREditor.this.fCurrentDiagram != null) {
                EREditor.this.fCurrentDiagram.repaint();
            }
        }
    }

    class ExtraColoredDraw
    extends AbstractAction {
        public ExtraColoredDraw() {
            super("Colored Drawing");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            EREditor.this.fColoredDraw = !EREditor.this.fColoredDraw;
            if (EREditor.this.fCurrentDiagram != null) {
                EREditor.this.fCurrentDiagram.repaint();
            }
        }
    }

    class ExtraIntelligentDraw
    extends AbstractAction {
        public ExtraIntelligentDraw() {
            super("Intelligent Drawing");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            EREditor.this.fIntelligentDraw = !EREditor.this.fIntelligentDraw;
        }
    }

    class ExtraSQLAction
    extends AbstractAction {
        public ExtraSQLAction() {
            super("Generate SQL Code...", new ImageIcon("Images/sql.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String reason = EREditor.this.fCurrentDiagram.getDiagram().check();
            if (reason != "") {
                JOptionPane.showMessageDialog(EREditor.this.fEditor, reason, "Checking ER Diagram", 0);
            } else {
                String sql = EREditor.this.fCurrentDiagram.getDiagram().getSQL();
                SQLPanel sqlPanel = new SQLPanel(sql);
                sqlPanel.show();
            }
        }
    }

    class ExtraMapAction
    extends AbstractAction {
        public ExtraMapAction() {
            super("Map Model...", new ImageIcon("Images/map.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String reason = EREditor.this.fCurrentDiagram.getDiagram().check();
            if (reason != "") {
                JOptionPane.showMessageDialog(EREditor.this.fEditor, reason, "Checking ER Diagram", 0);
            } else {
                MapPanel mapPanel = new MapPanel();
                mapPanel.print(EREditor.this.fCurrentDiagram.getDiagram().getMapping());
                mapPanel.show();
            }
        }
    }

    class ExtraCheckAction
    extends AbstractAction {
        public ExtraCheckAction() {
            super("Check Model", new ImageIcon("Images/check.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String reason = EREditor.this.fCurrentDiagram.getDiagram().check();
            if (reason != "") {
                JOptionPane.showMessageDialog(null, reason, "Checking ER Diagram", 0);
            } else {
                JOptionPane.showMessageDialog(null, "No errors found.", "Checking ER Diagram", 1);
            }
        }
    }

    class DrawLineAction
    extends AbstractAction {
        public DrawLineAction() {
            super("Line", new ImageIcon("Images/line.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            EREditor.this.drawButtons[5].setSelected(true);
            EREditor.this.fCurrentDrawObject = 5;
        }
    }

    class DrawISAAction
    extends AbstractAction {
        public DrawISAAction() {
            super("ISA Relationship", new ImageIcon("Images/isa.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            EREditor.this.drawButtons[4].setSelected(true);
            EREditor.this.fCurrentDrawObject = 4;
            EREditor.this.fCurrentDiagram.repaint();
        }
    }

    class DrawRelationshipAction
    extends AbstractAction {
        public DrawRelationshipAction() {
            super("Relationship", new ImageIcon("Images/relationship.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            EREditor.this.drawButtons[3].setSelected(true);
            EREditor.this.fCurrentDrawObject = 3;
            EREditor.this.fCurrentDiagram.repaint();
        }
    }

    class DrawAttributeAction
    extends AbstractAction {
        public DrawAttributeAction() {
            super("Attribute", new ImageIcon("Images/attribute.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            EREditor.this.drawButtons[2].setSelected(true);
            EREditor.this.fCurrentDrawObject = 2;
            EREditor.this.fCurrentDiagram.repaint();
        }
    }

    class DrawEntityAction
    extends AbstractAction {
        public DrawEntityAction() {
            super("Entity", new ImageIcon("Images/entity.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            EREditor.this.drawButtons[1].setSelected(true);
            EREditor.this.fCurrentDrawObject = 1;
            EREditor.this.fCurrentDiagram.repaint();
        }
    }

    class DrawEditAction
    extends AbstractAction {
        public DrawEditAction() {
            super("Edit", new ImageIcon("Images/edit.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            EREditor.this.drawButtons[0].setSelected(true);
            EREditor.this.fCurrentDrawObject = 0;
            EREditor.this.fCurrentDiagram.repaint();
        }
    }

    class EditAdjustFrameSizeAction
    extends AbstractAction {
        public EditAdjustFrameSizeAction() {
            super("Adjust Frame Size");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            EREditor.this.fCurrentDiagram.getDiagram().adjustFrameSizeWithUndo();
            EREditor.this.fCurrentDiagram.repaint();
        }
    }

    class EditDeselectAllAction
    extends AbstractAction {
        public EditDeselectAllAction() {
            super("Deselect All");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            EREditor.this.fCurrentDiagram.getDiagram().deselectAll();
            EREditor.this.fCurrentDiagram.repaint();
        }
    }

    class EditSelectAllAction
    extends AbstractAction {
        public EditSelectAllAction() {
            super("Select All");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            EREditor.this.fCurrentDiagram.getDiagram().selectAll();
            EREditor.this.fCurrentDiagram.repaint();
        }
    }

    class EditDeleteAction
    extends AbstractAction {
        public EditDeleteAction() {
            super("Delete", new ImageIcon("delete.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            EREditor.this.fCurrentDiagram.getDiagram().deleteWithUndo();
            EREditor.this.fCurrentDiagram.repaint();
        }
    }

    class EditRedoAction
    extends AbstractAction {
        public EditRedoAction() {
            super("Redo", new ImageIcon("Images/redo.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            EREditor.this.fUndoManager.redo();
            EREditor.this.refreshUndoRedo();
        }
    }

    class EditUndoAction
    extends AbstractAction {
        public EditUndoAction() {
            super("Undo", new ImageIcon("Images/undo.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            EREditor.this.fUndoManager.undo();
            EREditor.this.refreshUndoRedo();
        }
    }

    class FileExitAction
    extends AbstractAction {
        public FileExitAction() {
            super("Exit");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            EREditor.this.exit();
        }
    }

    class FileCopyToClipboardAction
    extends AbstractAction {
        public FileCopyToClipboardAction() {
            super("Copy to Clipboard...");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            EREditor.this.copyToClipboard();
        }
    }

    class FileExportAction
    extends AbstractAction {
        public FileExportAction() {
            super("Export To GIF...");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (EREditor.this.fEditor.isColoredDrawing() && EREditor.this.fEditor.isSmoothDrawing()) {
                String err = "Unable to export to GIF when both 'Smooth Drawing' \nand 'Colored Drawing' are turned on";
                JOptionPane.showMessageDialog(EREditor.this.fEditor, err, "Export to GIF", 0);
            } else {
                EREditor.this.exportDiagram();
            }
        }
    }

    class FileCloseAction
    extends AbstractAction {
        public FileCloseAction() {
            super("Close");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            EREditor.this.closeDiagram();
        }
    }

    class FileSaveAsAction
    extends AbstractAction {
        public FileSaveAsAction() {
            super("Save As...", new ImageIcon("Images/save.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            EREditor.this.saveDiagramAs();
        }
    }

    class FileSaveAction
    extends AbstractAction {
        public FileSaveAction() {
            super("Save", new ImageIcon("Images/save.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                EREditor.this.saveDiagram();
            }
            catch (FileException e) {
                JOptionPane.showMessageDialog(EREditor.this.fEditor, "Error while saving.", "Save Diagram", 0);
            }
        }
    }

    class FileOpenAction
    extends AbstractAction {
        public FileOpenAction() {
            super("Open...", new ImageIcon("Images/open.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            EREditor.this.openDiagram();
        }
    }

    class FileNewAction
    extends AbstractAction {
        public FileNewAction() {
            super("New...", new ImageIcon("Images/new.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            EREditor.this.newDiagram();
        }
    }
}

