/*
 * Decompiled with CFR 0.152.
 */
package UI.Panels;

import Reps.AttributeRep;
import Shapes.Attribute;
import UI.ActionChangeProperty;
import UI.Constants;
import UI.ERDiagram;
import javax.swing.table.AbstractTableModel;

class AttributeLengthTableModel
extends AbstractTableModel {
    private AttributeRep fAttributeRep;
    private Attribute fAttribute;
    private ERDiagram fDiagram;

    AttributeLengthTableModel() {
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row == 0 && col == 0) {
            return "Length";
        }
        if (row == 0 && col == 1) {
            return new Integer(this.fAttributeRep.getLength());
        }
        return "";
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        boolean showLength = false;
        if (this.fAttributeRep != null) {
            for (int i = 0; i < Constants.kTypeWithLength.length; ++i) {
                if (!Constants.kTypeWithLength[i].equals(this.fAttributeRep.getDataType())) continue;
                showLength = true;
            }
            if (showLength) {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 0;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this.fireTableCellUpdated(row, col);
        try {
            if (row == 0 && col == 1) {
                ActionChangeProperty edit = new ActionChangeProperty(this.fDiagram, this.fAttribute, "Length", String.valueOf(this.fAttributeRep.getLength()), (String)value);
                this.fAttributeRep.setLength(Integer.parseInt((String)value));
                this.fDiagram.getEditor().fUndoSupport.postEdit(edit);
            }
            this.fDiagram.setUnedited(false);
        }
        catch (NumberFormatException e) {
            this.fDiagram.getEditor().setStatusMessage("Illegal numerical value");
        }
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    public void setAttribute(ERDiagram diagram, Attribute attribute) {
        this.fAttribute = attribute;
        this.fAttributeRep = (AttributeRep)attribute.getRep();
        this.fDiagram = diagram;
    }
}

