/*
 * Decompiled with CFR 0.152.
 */
package UI.Panels;

import Exceptions.AttributeRepException;
import Reps.AttributeRep;
import Shapes.Attribute;
import UI.ActionChangeProperty;
import UI.ERDiagram;
import javax.swing.table.AbstractTableModel;

class AttributeOptionsTableModel
extends AbstractTableModel {
    private AttributeRep fAttributeRep;
    private Attribute fAttribute;
    private ERDiagram fDiagram;

    AttributeOptionsTableModel() {
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row == 0 && col == 0) {
            return "Required";
        }
        if (row == 1 && col == 0) {
            return "Unique";
        }
        if (row == 0 && col == 1) {
            return new Boolean(this.fAttributeRep.isRequired());
        }
        if (row == 1 && col == 1) {
            return new Boolean(this.fAttributeRep.isUnique());
        }
        return "";
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return 2;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 0;
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this.fireTableCellUpdated(row, col);
        this.fDiagram.setUnedited(false);
        try {
            if (row == 0 && col == 1) {
                ActionChangeProperty edit = new ActionChangeProperty(this.fDiagram, this.fAttribute, "Required", String.valueOf(this.fAttributeRep.isRequired()), String.valueOf(value));
                this.fAttributeRep.setRequired((Boolean)value);
                this.fDiagram.getEditor().fUndoSupport.postEdit(edit);
            } else if (row == 1 && col == 1) {
                ActionChangeProperty edit = new ActionChangeProperty(this.fDiagram, this.fAttribute, "Unique", String.valueOf(this.fAttributeRep.isUnique()), String.valueOf(value));
                this.fAttributeRep.setUnique((Boolean)value);
                this.fDiagram.getEditor().fUndoSupport.postEdit(edit);
            }
        }
        catch (AttributeRepException e) {
            this.fDiagram.getEditor().setStatusMessage(e.getMessage());
        }
    }

    public void setAttribute(ERDiagram diagram, Attribute attribute) {
        this.fAttribute = attribute;
        this.fAttributeRep = (AttributeRep)attribute.getRep();
        this.fDiagram = diagram;
    }
}

