/*
 * Decompiled with CFR 0.152.
 */
package UI.Panels;

import Exceptions.AttributeRepException;
import Reps.AttributeRep;
import Shapes.Attribute;
import UI.ActionChangeProperty;
import UI.ERDiagram;
import javax.swing.table.AbstractTableModel;

class AttributeTypeTableModel
extends AbstractTableModel {
    private AttributeRep fAttributeRep;
    private Attribute fAttribute;
    private ERDiagram fDiagram;

    AttributeTypeTableModel() {
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row == 0 && col == 0) {
            return "Type";
        }
        if (row == 0 && col == 1) {
            return this.fAttributeRep.getType();
        }
        return "";
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return 1;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 0;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this.fireTableCellUpdated(row, col);
        this.fDiagram.setUnedited(false);
        if (row == 0 && col == 1) {
            try {
                ActionChangeProperty edit = new ActionChangeProperty(this.fDiagram, this.fAttribute, "Type", this.fAttributeRep.getType(), (String)value);
                this.fAttributeRep.setType(value.toString());
                this.fDiagram.getEditor().fUndoSupport.postEdit(edit);
            }
            catch (AttributeRepException e) {
                this.fDiagram.getEditor().setStatusMessage(e.getMessage());
            }
        }
        this.fDiagram.repaint();
    }

    public void setAttribute(ERDiagram diagram, Attribute attribute) {
        this.fAttribute = attribute;
        this.fAttributeRep = (AttributeRep)attribute.getRep();
        this.fDiagram = diagram;
    }
}

