/*
 * Decompiled with CFR 0.152.
 */
package UI.Panels;

import Reps.EntityRep;
import Reps.RelationshipRep;
import Shapes.Entity;
import UI.ERDiagram;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

class BeginWeakEntityTableModel
extends AbstractTableModel {
    private Entity fEntity;
    private EntityRep fEntityRep;
    private ERDiagram fDiagram;
    private ArrayList fPossibleWeakRelationships = new ArrayList();

    BeginWeakEntityTableModel() {
    }

    @Override
    public Object getValueAt(int row, int col) {
        return "Weak Entities:";
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public int getRowCount() {
        if (!this.fPossibleWeakRelationships.isEmpty()) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void setEntity(ERDiagram diagram, Entity entity) {
        this.fEntity = entity;
        this.fEntityRep = (EntityRep)entity.getRep();
        this.fDiagram = diagram;
        this.setPossibleDependentRelationships();
    }

    private void setPossibleDependentRelationships() {
        this.fPossibleWeakRelationships.clear();
        for (RelationshipRep relationship : this.fEntityRep.getConnectedRelationships()) {
            if (!this.fEntityRep.isWeak() && !this.fEntityRep.canBeSetDependentOf(relationship)) continue;
            this.fPossibleWeakRelationships.add(relationship);
        }
    }
}

