/*
 * Decompiled with CFR 0.152.
 */
package UI.Panels;

import Shapes.DrawableElement;
import Shapes.ISA;
import UI.ActionChangeProperty;
import UI.ERDiagram;
import javax.swing.table.AbstractTableModel;

class ElementTableModel
extends AbstractTableModel {
    private DrawableElement fElement;
    private ERDiagram fDiagram;

    ElementTableModel() {
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row == 0 && col == 0) {
            return "Name";
        }
        if (row == 0 && col == 1) {
            return this.fElement.getRep().getName();
        }
        return "";
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return 1;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 0 && !(this.fElement instanceof ISA);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this.fireTableCellUpdated(row, col);
        this.fDiagram.setUnedited(false);
        if (row == 0 && col == 1) {
            try {
                ActionChangeProperty edit = new ActionChangeProperty(this.fDiagram, this.fElement, "Name", this.fElement.getRep().getName(), (String)value);
                this.fElement.getRep().setName((String)value);
                this.fElement.adjustWidthToName(this.fDiagram);
                this.fDiagram.getEditor().fUndoSupport.postEdit(edit);
            }
            catch (Exception e) {
                this.fDiagram.getEditor().setStatusMessage(e.getMessage());
            }
        }
        this.fDiagram.repaint();
    }

    public void setElement(ERDiagram diagram, DrawableElement element) {
        this.fElement = element;
        this.fDiagram = diagram;
    }
}

