/*
 * Decompiled with CFR 0.152.
 */
package UI.Panels;

import Reps.EntityRep;
import Reps.ISARep;
import Shapes.ISA;
import UI.ERDiagram;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

class ISATableModel
extends AbstractTableModel {
    private ISARep fIsaRep;
    private ISA fIsa;
    private ERDiagram fDiagram;
    private ArrayList fSubEntities;
    private EntityRep fSuperEntity;

    ISATableModel() {
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row == 0 && col == 0) {
            return "Super Entity";
        }
        if (row == 0 && col == 1) {
            if (this.fSuperEntity != null) {
                return this.fSuperEntity.getName();
            }
            return "";
        }
        if (row == 1 && col == 0) {
            return "Sub Entities";
        }
        if (row > 0 && col == 1) {
            if (this.fSubEntities != null && !this.fSubEntities.isEmpty()) {
                return ((EntityRep)this.fSubEntities.get(row - 1)).getName();
            }
            return "";
        }
        return "";
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        if (this.fSubEntities != null && !this.fSubEntities.isEmpty()) {
            return this.fSubEntities.size() + 1;
        }
        return 2;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void setISA(ERDiagram diagram, ISA isa) {
        this.fIsa = isa;
        this.fIsaRep = (ISARep)isa.getRep();
        this.fDiagram = diagram;
        if (this.fIsaRep != null) {
            this.fSuperEntity = this.fIsaRep.getSuperEntity();
            this.fSubEntities = this.fIsaRep.getSubEntities();
        } else {
            this.fSuperEntity = null;
            this.fSubEntities = null;
        }
    }
}

