/*
 * Decompiled with CFR 0.152.
 */
package UI.Panels;

import Mapping.Relation;
import Reps.AttributeRep;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class MapPanel
extends JDialog {
    static final String NORMAL = "Normal";
    static final String UNDERLINED = "Underlined";
    static final String BOLD = "Bold";
    private Style fStyleNormal;
    private Style fStyleUnderlined;
    private Style fStyleBold;
    private DefaultStyledDocument fDoc;
    private JTextPane fPane;

    public MapPanel() {
        this.setModal(true);
        this.fDoc = new DefaultStyledDocument();
        this.fPane = new JTextPane(this.fDoc);
        this.fPane.setEnabled(false);
        JScrollPane scrollPane = new JScrollPane(this.fPane);
        this.getContentPane().add(scrollPane);
        this.setSize(600, 300);
        this.setTitle("ER Mapping");
        Dimension dim = this.getToolkit().getScreenSize();
        Rectangle abounds = this.getBounds();
        this.setLocation((dim.width - abounds.width) / 2, (dim.height - abounds.height) / 2);
        this.fStyleNormal = StyleContext.getDefaultStyleContext().getStyle("default");
        this.fStyleUnderlined = this.fPane.addStyle("underlined", this.fStyleNormal);
        this.fStyleBold = this.fPane.addStyle("bold", this.fStyleNormal);
        StyleConstants.setUnderline(this.fStyleUnderlined, true);
        StyleConstants.setFontSize(this.fStyleNormal, 16);
        StyleConstants.setBold(this.fStyleBold, true);
    }

    public void print(ArrayList relations) {
        for (Relation relation : relations) {
            this.printRelation(relation);
        }
    }

    private void printRelation(Relation relation) {
        try {
            String str = relation.getName();
            this.fDoc.insertString(this.fDoc.getLength(), str, this.fStyleBold);
            this.fDoc.insertString(this.fDoc.getLength(), "(", this.fStyleNormal);
            Iterator itAttributes = relation.getKeyAttributes().iterator();
            while (itAttributes.hasNext()) {
                str = "";
                AttributeRep attribute = (AttributeRep)itAttributes.next();
                if (!attribute.getType().equals("multivalued") && (relation.alreadyExists(attribute) || attribute.getAttributedElement().getName() != relation.getName())) {
                    str = attribute.getAttributedElement().getName() + ".";
                }
                str = str + attribute.getName();
                this.fDoc.insertString(this.fDoc.getLength(), str, this.fStyleUnderlined);
                if (!itAttributes.hasNext()) continue;
                this.fDoc.insertString(this.fDoc.getLength(), ", ", this.fStyleNormal);
            }
            ArrayList nonKeyAttributes = relation.getNonKeyAttributes();
            if (!nonKeyAttributes.isEmpty()) {
                this.fDoc.insertString(this.fDoc.getLength(), ", ", this.fStyleNormal);
                itAttributes = nonKeyAttributes.iterator();
                while (itAttributes.hasNext()) {
                    str = "";
                    AttributeRep attribute = (AttributeRep)itAttributes.next();
                    if (relation.alreadyExists(attribute) || attribute.getAttributedElement().getName() != relation.getName()) {
                        str = attribute.getAttributedElement().getName() + ".";
                    }
                    str = str + attribute.getName();
                    this.fDoc.insertString(this.fDoc.getLength(), str, this.fStyleNormal);
                    if (!itAttributes.hasNext()) continue;
                    this.fDoc.insertString(this.fDoc.getLength(), ", ", this.fStyleNormal);
                }
            }
            this.fDoc.insertString(this.fDoc.getLength(), ")\n", this.fStyleNormal);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error While Mapping", 0);
        }
    }
}

