/*
 * Decompiled with CFR 0.152.
 */
package UI.Panels;

import Exceptions.RoleException;
import Reps.Role;
import Shapes.Line;
import UI.ActionChangeProperty;
import UI.ERDiagram;
import javax.swing.table.AbstractTableModel;

class RoleRefIntegrityTableModel
extends AbstractTableModel {
    private Role fRole;
    private Line fLine;
    private ERDiagram fDiagram;

    RoleRefIntegrityTableModel() {
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row == 0 && col == 0) {
            return "Ref. Integrity";
        }
        if (row == 0 && col == 1) {
            return new Boolean(this.fRole.getRefIntegrity());
        }
        return "";
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return 1;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 0;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this.fireTableCellUpdated(row, col);
        this.fDiagram.setUnedited(false);
        if (row == 0 && col == 1) {
            try {
                ActionChangeProperty edit = new ActionChangeProperty(this.fDiagram, this.fLine, "RefIntegrity", String.valueOf(this.fRole.getRefIntegrity()), String.valueOf(value));
                this.fRole.setRefIntegrity((Boolean)value, false);
                this.fDiagram.getEditor().fUndoSupport.postEdit(edit);
            }
            catch (RoleException e) {
                this.fDiagram.getEditor().setStatusMessage(e.getMessage());
            }
        }
        this.fDiagram.repaint();
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    public void setLine(ERDiagram diagram, Line line) {
        this.fLine = line;
        this.fRole = (Role)line.getRep();
        this.fDiagram = diagram;
    }
}

