/*
 * Decompiled with CFR 0.152.
 */
package UI.Panels;

import Exceptions.RoleException;
import Reps.Role;
import Shapes.Line;
import UI.ActionChangeProperty;
import UI.ERDiagram;
import javax.swing.table.AbstractTableModel;

class RoleTableModel
extends AbstractTableModel {
    private Role fRole;
    private Line fLine;
    private ERDiagram fDiagram;

    RoleTableModel() {
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row == 0 && col == 0) {
            return "Min Cardinality";
        }
        if (row == 1 && col == 0) {
            return "Max Cardinality";
        }
        if (row == 0 && col == 1) {
            return this.fRole.getMinCard();
        }
        if (row == 1 && col == 1) {
            return this.fRole.getMaxCard();
        }
        return "";
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return 2;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 0;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this.fireTableCellUpdated(row, col);
        this.fDiagram.setUnedited(false);
        try {
            if (row == 0 && col == 1) {
                ActionChangeProperty edit = new ActionChangeProperty(this.fDiagram, this.fLine, "MinCard", this.fRole.getMinCard(), (String)value);
                this.fRole.setMinCard((String)value);
                this.fDiagram.getEditor().fUndoSupport.postEdit(edit);
            } else if (row == 1 && col == 1) {
                ActionChangeProperty edit = new ActionChangeProperty(this.fDiagram, this.fLine, "MaxCard", this.fRole.getMaxCard(), (String)value);
                this.fRole.setMaxCard((String)value);
                this.fDiagram.getEditor().fUndoSupport.postEdit(edit);
            }
        }
        catch (RoleException e) {
            this.fDiagram.getEditor().setStatusMessage(e.getMessage());
        }
        catch (NumberFormatException e) {
            this.fDiagram.getEditor().setStatusMessage("Illegal cardinality value");
        }
        catch (Exception e) {
            this.fDiagram.getEditor().setStatusMessage(e.getMessage());
        }
        this.fDiagram.repaint();
    }

    public void setLine(ERDiagram diagram, Line line) {
        this.fLine = line;
        this.fRole = (Role)line.getRep();
        this.fDiagram = diagram;
    }
}

