/*
 * Decompiled with CFR 0.152.
 */
package UI.Panels;

import Reps.EntityRep;
import Reps.RelationshipRep;
import Reps.Role;
import Shapes.Entity;
import UI.ActionChangeProperty;
import UI.ERDiagram;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

class WeakEntitiesTableModel
extends AbstractTableModel {
    private EntityRep fEntityRep;
    private Entity fEntity;
    private ERDiagram fDiagram;
    private ArrayList fPossibleWeakRelationships = new ArrayList();

    WeakEntitiesTableModel() {
    }

    @Override
    public Object getValueAt(int row, int col) {
        RelationshipRep relationship = (RelationshipRep)this.fPossibleWeakRelationships.get(row);
        if (col == 0) {
            ArrayList roles = relationship.getRoles();
            EntityRep entity1 = ((Role)roles.get(0)).getEntity();
            EntityRep entity2 = ((Role)roles.get(1)).getEntity();
            if (entity1 != this.fEntityRep) {
                return entity1.getName();
            }
            return entity2.getName();
        }
        if (col == 1) {
            return relationship.getName();
        }
        if (col == 2) {
            return new Boolean(relationship.isWeak());
        }
        return "";
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.fPossibleWeakRelationships.size();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 2;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this.fireTableCellUpdated(row, col);
        this.fDiagram.setUnedited(false);
        RelationshipRep relationship = (RelationshipRep)this.fPossibleWeakRelationships.get(row);
        ArrayList roles = relationship.getRoles();
        EntityRep entity1 = ((Role)roles.get(0)).getEntity();
        EntityRep entity2 = ((Role)roles.get(1)).getEntity();
        try {
            if (col == 2 && ((Boolean)value).booleanValue()) {
                if (entity1 != this.fEntityRep) {
                    ActionChangeProperty edit = new ActionChangeProperty(this.fDiagram, this.fEntity, "Weak", String.valueOf(this.fEntityRep.isWeak()), String.valueOf(value), entity1, relationship);
                    this.fEntityRep.addDependency(relationship, false);
                    this.fDiagram.getEditor().fUndoSupport.postEdit(edit);
                } else {
                    ActionChangeProperty edit = new ActionChangeProperty(this.fDiagram, this.fEntity, "Weak", String.valueOf(this.fEntityRep.isWeak()), String.valueOf(value), entity2, relationship);
                    this.fEntityRep.addDependency(relationship, false);
                    this.fDiagram.getEditor().fUndoSupport.postEdit(edit);
                }
            } else if (col == 2) {
                if (entity1 != this.fEntityRep) {
                    ActionChangeProperty edit = new ActionChangeProperty(this.fDiagram, this.fEntity, "Weak", String.valueOf(this.fEntityRep.isWeak()), String.valueOf(value), entity1, relationship);
                    this.fEntityRep.removeDependency(relationship);
                    this.fDiagram.getEditor().fUndoSupport.postEdit(edit);
                } else {
                    ActionChangeProperty edit = new ActionChangeProperty(this.fDiagram, this.fEntity, "Weak", String.valueOf(this.fEntityRep.isWeak()), String.valueOf(value), entity2, relationship);
                    this.fEntityRep.removeDependency(relationship);
                    this.fDiagram.getEditor().fUndoSupport.postEdit(edit);
                }
            }
        }
        catch (Exception e) {
            this.fDiagram.getEditor().setStatusMessage(e.getMessage());
        }
        this.fDiagram.repaint();
    }

    public void setEntity(ERDiagram diagram, Entity entity) {
        this.fEntity = entity;
        this.fEntityRep = (EntityRep)entity.getRep();
        this.fDiagram = diagram;
        this.setPossibleDependentRelationships();
    }

    private void setPossibleDependentRelationships() {
        this.fPossibleWeakRelationships.clear();
        for (RelationshipRep relationship : this.fEntityRep.getConnectedRelationships()) {
            if (!this.fEntityRep.isWeak() && !this.fEntityRep.canBeSetDependentOf(relationship)) continue;
            this.fPossibleWeakRelationships.add(relationship);
        }
    }
}

