/*
 * Decompiled with CFR 0.152.
 */
package UI;

import Exceptions.ParseException;
import Reps.AttributeRep;
import Reps.EntityRep;
import Reps.ISARep;
import Reps.RelationshipRep;
import Reps.Role;
import Shapes.Attribute;
import Shapes.DrawableElement;
import Shapes.Entity;
import Shapes.ISA;
import Shapes.Line;
import Shapes.Relationship;
import UI.ERDiagram;
import java.io.File;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Parser
extends DefaultHandler {
    private HashMap fElements = new HashMap();
    private ERDiagram fDiagram;
    private String fId;

    public Parser(ERDiagram diagram) throws ParseException {
        if (diagram == null) {
            throw new ParseException("Parsing Error: Illegal Diagram");
        }
        this.fDiagram = diagram;
    }

    public void run(File file) throws ParseException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(file, (DefaultHandler)this);
        }
        catch (Exception e) {
            throw new ParseException("Parsing Error: Illegal XML File\n" + e.getMessage());
        }
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attrs) throws SAXException {
        try {
            if (name.equals("entityid")) {
                this.addEntity(attrs);
            } else if (name.equals("relationshipid")) {
                this.addRelationship(attrs);
            } else if (name.equals("weakentityid")) {
                this.addWeakEntity(attrs);
            } else if (name.equals("weakrelationshipid")) {
                this.addWeakRelationship(attrs);
            } else if (name.equals("attributeid")) {
                this.addAttribute(attrs);
            } else if (name.equals("isaid")) {
                this.addISA(attrs);
            } else if (name.equals("attribute")) {
                this.addAttributeToElement(attrs);
            } else if (name.equals("role")) {
                this.addRoleToElement(attrs);
            } else if (name.equals("entity")) {
                this.fId = attrs.getValue("id");
            } else if (name.equals("relationship")) {
                this.fId = attrs.getValue("id");
            } else if (name.equals("weakentity")) {
                this.fId = attrs.getValue("id");
            } else if (name.equals("weakrelationship")) {
                this.fId = attrs.getValue("id");
            } else if (name.equals("isa")) {
                this.fId = attrs.getValue("id");
            } else if (name.equals("superentity")) {
                this.setSuperEntity(attrs);
            } else if (name.equals("subentity")) {
                this.addSubEntity(attrs);
            } else if (name.equals("dependencyref")) {
                this.addDependentElement(attrs);
            }
        }
        catch (ParseException e) {
            throw new SAXException(e.getMessage());
        }
    }

    public void endElement(String name) throws SAXException {
    }

    @Override
    public void characters(char[] p0, int p1, int p2) {
    }

    private void addEntity(Attributes attrs) {
        String id = attrs.getValue("id");
        int x = new Integer(attrs.getValue("posX"));
        int y = new Integer(attrs.getValue("posY"));
        String name = attrs.getValue("name");
        EntityRep entityRep = new EntityRep(name);
        Entity entity = new Entity(this.fDiagram, entityRep, x, y);
        entity.adjustWidthToName(this.fDiagram);
        this.fDiagram.add(entity);
        this.fElements.put(id, entity);
    }

    private void addRelationship(Attributes attrs) {
        String id = attrs.getValue("id");
        int x = new Integer(attrs.getValue("posX"));
        int y = new Integer(attrs.getValue("posY"));
        String name = attrs.getValue("name");
        RelationshipRep relationshipRep = new RelationshipRep(name);
        Relationship relationship = new Relationship(this.fDiagram, relationshipRep, x, y);
        relationship.adjustWidthToName(this.fDiagram);
        this.fDiagram.updateFrameSize(x, y);
        this.fDiagram.add(relationship);
        this.fElements.put(id, relationship);
    }

    private void addWeakEntity(Attributes attrs) {
        String id = attrs.getValue("id");
        int x = new Integer(attrs.getValue("posX"));
        int y = new Integer(attrs.getValue("posY"));
        String name = attrs.getValue("name");
        EntityRep weakEntityRep = new EntityRep(name);
        Entity weakEntity = new Entity(this.fDiagram, weakEntityRep, x, y);
        weakEntity.adjustWidthToName(this.fDiagram);
        this.fDiagram.add(weakEntity);
        this.fElements.put(id, weakEntity);
    }

    private void addWeakRelationship(Attributes attrs) {
        String id = attrs.getValue("id");
        int x = new Integer(attrs.getValue("posX"));
        int y = new Integer(attrs.getValue("posY"));
        String name = attrs.getValue("name");
        RelationshipRep weakRelationshipRep = new RelationshipRep(name);
        Relationship weakRelationship = new Relationship(this.fDiagram, weakRelationshipRep, x, y);
        weakRelationship.adjustWidthToName(this.fDiagram);
        this.fDiagram.add(weakRelationship);
        this.fElements.put(id, weakRelationship);
    }

    private void addAttribute(Attributes attrs) throws ParseException {
        String id = attrs.getValue("id");
        int x = new Integer(attrs.getValue("posX"));
        int y = new Integer(attrs.getValue("posY"));
        String type = attrs.getValue("type");
        String name = attrs.getValue("name");
        boolean required = new Boolean(attrs.getValue("required"));
        boolean unique = new Boolean(attrs.getValue("unique"));
        String datatype = attrs.getValue("datatype");
        int length = new Integer(attrs.getValue("length"));
        AttributeRep attributeRep = new AttributeRep(name, type);
        Attribute attribute = new Attribute(this.fDiagram, attributeRep, x, y);
        attribute.adjustWidthToName(this.fDiagram);
        attributeRep.setDataType(datatype);
        try {
            attributeRep.setRequired(required);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage());
        }
        attributeRep.setUnique(unique);
        attributeRep.setLength(length);
        this.fDiagram.add(attribute);
        this.fElements.put(id, attribute);
    }

    private void addISA(Attributes attrs) {
        String id = attrs.getValue("id");
        int x = new Integer(attrs.getValue("posX"));
        int y = new Integer(attrs.getValue("posY"));
        ISARep isaRep = new ISARep();
        ISA isa = new ISA(this.fDiagram, isaRep, x, y);
        this.fDiagram.updateFrameSize(x, y);
        this.fDiagram.add(isa);
        this.fElements.put(id, isa);
    }

    private void addAttributeToElement(Attributes attrs) throws ParseException {
        DrawableElement drawableElement = (DrawableElement)this.fElements.get(this.fId);
        Attribute attribute = (Attribute)this.fElements.get(attrs.getValue("id"));
        try {
            drawableElement.connect(null, attribute);
            Line line = new Line(this.fDiagram, null, drawableElement, attribute);
            this.fDiagram.add(line);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage());
        }
    }

    private void addRoleToElement(Attributes attrs) throws ParseException {
        String mincard = attrs.getValue("mincard");
        String maxcard = attrs.getValue("maxcard");
        String name = attrs.getValue("name");
        boolean refintegrity = new Boolean(attrs.getValue("refintegrity"));
        Entity entity = (Entity)this.fElements.get(attrs.getValue("entityid"));
        Relationship relationship = (Relationship)this.fElements.get(this.fId);
        try {
            Role role = entity.connect(null, relationship);
            role.setMaxCard(maxcard);
            role.setMinCard(mincard);
            role.setName(name);
            if (refintegrity) {
                role.setRefIntegrity(refintegrity, true);
            }
            Line line = new Line(this.fDiagram, role, entity, relationship);
            this.fDiagram.add(line);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage());
        }
    }

    private void addSubEntity(Attributes attrs) throws ParseException {
        Entity entity = (Entity)this.fElements.get(attrs.getValue("id"));
        ISA isa = (ISA)this.fElements.get(this.fId);
        try {
            isa.connect(null, entity);
            Line line = new Line(this.fDiagram, null, isa, entity);
            this.fDiagram.add(line);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage());
        }
    }

    private void setSuperEntity(Attributes attrs) throws ParseException {
        Entity entity = (Entity)this.fElements.get(attrs.getValue("id"));
        ISA isa = (ISA)this.fElements.get(this.fId);
        try {
            entity.connect(null, isa);
            Line line = new Line(this.fDiagram, null, entity, isa);
            this.fDiagram.add(line);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage());
        }
    }

    private void addDependentElement(Attributes attrs) throws ParseException {
        Entity weakEntity = (Entity)this.fElements.get(this.fId);
        Relationship relationship = (Relationship)this.fElements.get(attrs.getValue("relationshipid"));
        try {
            ((EntityRep)weakEntity.getRep()).addDependency((RelationshipRep)relationship.getRep(), true);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage());
        }
    }
}

