/*
 * Decompiled with CFR 0.152.
 */
package VBA;

import VBA.Information;
import VBA.VBArrayByte;
import VBA.VBArrayChar;
import VBA.VBVariant;
import java.io.BufferedReader;
import java.io.InputStream;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Conversion {
    private char[] alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
    private static final String[][] CheckDatePatterns = new String[][]{{"yyyy-MM-dd", " hh:mm", ":ss", " a"}, {"dd.MM.yyyy", " hh:mm", ":ss", " a"}, {"dd/mm/yyyy", " hh:mm", ":ss", " a"}, {"#dd/mm/yyyy#", " hh:mm", ":ss", " a"}, {"dd-MM-yyyy", " hh:mm", ":ss", " a"}, {"E, d. MMMM", " yyyy"}, {"d. MMMM", " yyyy", " hh:mm", ":ss", " a"}, {"MMMM d", ", yyyy", " hh:mm", ":ss", " a"}, {"hh:mm", ":ss", " a"}, {"yyyy"}};

    public static boolean CBool(VBVariant Expression) {
        return Conversion.CInt(Expression) != 0;
    }

    public static byte CByte(VBVariant Expression) {
        return (byte)Conversion.CInt(Expression);
    }

    public static byte CByte(Object Expression) {
        return Conversion.CByte(Conversion.CVar(Expression));
    }

    public static char CChar(VBVariant Expression) {
        return (char)Conversion.CInt(Expression);
    }

    public static char CChar(Object Expression) {
        return Conversion.CChar(Conversion.CVar(Expression));
    }

    public static long CCur(VBVariant Expression) {
        return Conversion.CLng(Expression);
    }

    public static long CLng(VBVariant Expression) {
        return Expression.longValue();
    }

    public static long CLng(Object Expression) {
        return Conversion.CLng(Conversion.CVar(Expression));
    }

    public static int CInt(VBVariant Expression) {
        return Expression.intValue();
    }

    public static int CInt(byte Expression) {
        return Expression;
    }

    public static int CInt(Object Expression) {
        return Conversion.CInt(Conversion.CVar(Expression));
    }

    public static int Int(VBVariant Expression) {
        return Conversion.CInt(Expression);
    }

    public static double CDbl(VBVariant Expression) {
        return Expression.doubleValue();
    }

    public static double CDbl(Object Expression) {
        return Conversion.CDbl(Conversion.CVar(Expression));
    }

    public static double Val(String Expression) {
        if (Expression == null) {
            return 0.0;
        }
        StringBuffer strBuff = new StringBuffer();
        char decimalSeparator = new DecimalFormatSymbols().getDecimalSeparator();
        boolean bSetOperator = false;
        boolean bSetDecimalSeparator = false;
        for (int i = 0; i < Expression.length(); ++i) {
            char c = Expression.charAt(i);
            if (Character.isDigit(c)) {
                strBuff.append(c);
                continue;
            }
            if (c == '-') {
                if (bSetOperator) continue;
                bSetOperator = true;
                strBuff.append("-");
                continue;
            }
            if (c != '.' && c != ',' || bSetDecimalSeparator) continue;
            bSetDecimalSeparator = true;
            strBuff.append(decimalSeparator);
        }
        return Conversion.CDbl(new VBVariant(strBuff.toString()));
    }

    public static String CStr(InputStream Expression) {
        try {
            byte[] tmp = new byte[Expression.available()];
            Expression.read(tmp);
            return new String(tmp);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String CStr(BufferedReader Expression) {
        StringBuffer ret = new StringBuffer();
        String tmp = null;
        try {
            while ((tmp = Expression.readLine()) != null) {
                ret.append(tmp + "\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret.toString();
    }

    public static String CStr(VBArrayByte Expression) {
        return Expression.toString();
    }

    public static String CStr(VBArrayChar Expression) {
        return Expression.toString();
    }

    public static String CStr(VBVariant Expression) {
        return Expression.toString();
    }

    public static String CStr(Object Expression) {
        return Conversion.CStr(Conversion.CVar(Expression));
    }

    public static String CStr(char Expression) {
        char[] myExpression = new char[]{Expression};
        return Conversion.CStr(myExpression);
    }

    public static String CStr(char[] Expression) {
        return new String(Expression);
    }

    public static String CStr(double Expression) {
        if (Information.IsFloatingPoint(Expression)) {
            return String.valueOf(Expression);
        }
        return String.valueOf((long)Expression);
    }

    public static String CStr(Date Expression) {
        if (Expression == null) {
            return new Date().toString();
        }
        return Expression.toLocaleString();
    }

    public static VBVariant CVar(Object Expression) {
        return new VBVariant(Expression);
    }

    public static VBVariant CVar(VBVariant Expression) {
        return Expression;
    }

    public static String Str(VBVariant Expression) {
        return Conversion.CStr(Expression);
    }

    public static Date CDate(VBVariant Expression) {
        if (Expression.isDate()) {
            return Expression.toDate();
        }
        return Conversion.CDate(Expression.toString());
    }

    public static Date CDate(String Expression) {
        Date ret = null;
        for (int i = 0; i < CheckDatePatterns.length; ++i) {
            for (int x = 0; x < CheckDatePatterns[i].length; ++x) {
                ret = Conversion.CreateDateFormater(Expression, Conversion.Join(CheckDatePatterns[i], CheckDatePatterns[i].length - x));
                if (ret == null) continue;
                return ret;
            }
        }
        return new Date();
    }

    private static String Join(String[] val, int max) {
        StringBuffer strBuffer = new StringBuffer();
        for (int i = 0; i < max; ++i) {
            strBuffer.append(val[i]);
        }
        return strBuffer.toString();
    }

    private static Date CreateDateFormater(String InputDate, String DatePattern) {
        try {
            SimpleDateFormat sdFormat = new SimpleDateFormat(DatePattern);
            return sdFormat.parse(InputDate);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static VBVariant Hex(VBVariant Expression) {
        return new VBVariant(Integer.toHexString(Expression.intValue()));
    }

    public static VBVariant Fix(VBVariant Expression) {
        return new VBVariant(Conversion.CInt(Expression));
    }

    public static VBVariant Oct(VBVariant Expression) {
        try {
            return new VBVariant(Integer.toOctalString(Expression.intValue()));
        }
        catch (Exception exception) {
            return new VBVariant();
        }
    }

    public static float CSng(VBVariant Expression) {
        try {
            return (float)Expression.doubleValue();
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    public static VBVariant CDec(VBVariant Expression) {
        try {
            if (Expression.toString().toLowerCase().startsWith("&h")) {
                String val = new VBVariant(Conversion.Val(Expression.toString())).toString();
                int ival = Integer.valueOf(val, 16);
                return new VBVariant(ival);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new VBVariant();
    }

    public static Date CVDate(VBVariant Expression) {
        return Conversion.CDate(Expression);
    }
}

