/*
 * Decompiled with CFR 0.152.
 */
package VBA;

import VBA.Constants;
import VBA.Conversion;
import VBA.Information;
import VBA.VBArray;
import VBA.VBArrayString;
import VBA.VBCompareMethod;
import VBA.VBDateParser;
import VBA.VBDayOfWeek;
import VBA.VBStrConv;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Strings {
    public static int AscB(String String1) {
        return Strings.Asc(String1);
    }

    public static int AscW(String String1) {
        return Strings.Asc(String1);
    }

    public static int Asc(String String1) {
        return String1.charAt(0);
    }

    public static String ChrB(int Char) {
        return Strings.Chr(Char);
    }

    public static String ChrW(int Char) {
        return Strings.Chr(Char);
    }

    public static String Chr(int Char) {
        byte[] b = new byte[]{(byte)Char};
        try {
            return new String(b, "ISO-8859-1");
        }
        catch (Exception e) {
            return new String(b);
        }
    }

    public static int InStr(String String1, String String2) {
        return Strings.InStr(1, String1, String2);
    }

    public static int InStr(int Start, String String1, String String2) {
        return Strings.InStr(Start, String1, String2, VBCompareMethod.vbBinaryCompare);
    }

    public static int InStr(int Start, String String1, String String2, VBCompareMethod CompareMet) {
        switch (CompareMet.intValue()) {
            case 0: {
                return String1.indexOf(String2, Start - 1) + 1;
            }
            case 1: {
                return String1.toLowerCase().indexOf(String2.toLowerCase(), Start - 1) + 1;
            }
        }
        return String1.indexOf(String2, Start - 1) + 1;
    }

    public static int InStrRev(String String1, String String2) {
        return Strings.InStrRev(String1, String2, Strings.Len(String1));
    }

    public static int InStrRev(String String1, String String2, int Start) {
        return Strings.InStrRev(String1, String2, Start, VBCompareMethod.vbBinaryCompare);
    }

    public static int InStrRev(String String1, String String2, int Start, VBCompareMethod CompareMet) {
        if (Start > Strings.Len(String1)) {
            return 0;
        }
        switch (CompareMet.intValue()) {
            case 0: {
                return String1.lastIndexOf(String2, Start - 1) + 1;
            }
            case 1: {
                return String1.toLowerCase().lastIndexOf(String2, Start - 1) + 1;
            }
        }
        return String1.lastIndexOf(String2, Start - 1) + 1;
    }

    public static int Len(String String1) {
        return String1.length();
    }

    public static String Mid(String String1, int Start) {
        return Strings.Mid(String1, Start, String1.length() - Start + 1);
    }

    public static String Mid(String String1, int Start, int Length) {
        if (Start <= 0) {
            return Constants.vbNullString;
        }
        int iStartPos = Start - 1;
        int iEndPos = iStartPos + Length;
        if (iStartPos > String1.length()) {
            return "";
        }
        if (iEndPos > String1.length()) {
            iEndPos = String1.length();
        }
        return String1.substring(iStartPos, iEndPos);
    }

    public static String Right(String String1, int Length) {
        int iStartPos = String1.length() - Length;
        if (iStartPos < 0) {
            iStartPos = 0;
        }
        return String1.substring(iStartPos, String1.length());
    }

    public static String Left(String String1, int Length) {
        int iEndPos = Length;
        if (iEndPos > String1.length()) {
            iEndPos = String1.length();
        }
        return String1.substring(0, iEndPos);
    }

    public static String StrMerge(String String1, String String2) {
        if (Information.IsNumeric(String1) && Information.IsNumeric(String2)) {
            return Conversion.CStr(Conversion.CDbl(String1) + Conversion.CDbl(String2));
        }
        return Strings.StrCat(String1, String2);
    }

    public static String StrCat(String String1, String String2) {
        StringBuffer myStringBuffer = new StringBuffer();
        myStringBuffer.append(String1);
        myStringBuffer.append(String2);
        return myStringBuffer.toString();
    }

    public static String Replace(String Source, String Pattern, String Replace) {
        int len = Pattern.length();
        if (len == 0) {
            return Source;
        }
        StringBuffer sb = new StringBuffer();
        int found = -1;
        int start = 0;
        while ((found = Source.indexOf(Pattern, start)) != -1) {
            sb.append(Source.substring(start, found));
            sb.append(Replace);
            start = found + len;
        }
        sb.append(Source.substring(start));
        return sb.toString();
    }

    public static String LCase(String String1) {
        return String1.toLowerCase();
    }

    public static String UCase(String String1) {
        return String1.toUpperCase();
    }

    public static String Trim(String String1) {
        return String1.trim();
    }

    public static String LTrim(String String1) {
        int iStart = 0;
        for (int i = 0; i < String1.length(); ++i) {
            if (String1.charAt(i) == ' ') {
                iStart = i + 1;
                continue;
            }
            i = String1.length();
        }
        return String1.substring(iStart);
    }

    public static String RTrim(String String1) {
        int iEnd = String1.length();
        for (int i = String1.length() - 1; i >= 0; --i) {
            if (String1.charAt(i) == ' ') {
                iEnd = i;
                continue;
            }
            i = 0;
        }
        return String1.substring(0, iEnd);
    }

    public static String String(int Numbers, String TCharacter) {
        byte[] tmpAry = new byte[Numbers];
        int iTCharacter = Strings.Asc(TCharacter);
        for (int i = 0; i < Numbers; ++i) {
            tmpAry[i] = (byte)iTCharacter;
        }
        try {
            return new String(tmpAry, "ISO-8859-1");
        }
        catch (Exception e) {
            return new String(tmpAry);
        }
    }

    public static String Space(int Numbers) {
        byte[] tmpAry = new byte[Numbers];
        for (int i = 0; i < Numbers; ++i) {
            tmpAry[i] = 32;
        }
        try {
            return new String(tmpAry, "ISO-8859-1");
        }
        catch (Exception e) {
            return new String(tmpAry);
        }
    }

    public static boolean StrCompPattern(String String1, String String2) {
        Pattern pt = Pattern.compile(String2, 2);
        Matcher mt = pt.matcher(String1);
        return mt.find();
    }

    public static int StrCompText(String String1, String String2) {
        return Strings.StrComp(String1, String2, VBCompareMethod.vbTextCompare);
    }

    public static int StrComp(String String1, String String2) {
        return Strings.StrComp(String1, String2, VBCompareMethod.vbBinaryCompare);
    }

    public static int StrComp(String String1, String String2, VBCompareMethod CompareMet) {
        int ret = 0;
        if (String1 == null || String2 == null) {
            if (String1 == String2) {
                return 0;
            }
            if (String1 == null) {
                return -1;
            }
            return 1;
        }
        switch (CompareMet.intValue()) {
            case 0: {
                ret = String1.compareTo(String2);
                break;
            }
            case 1: {
                ret = String1.compareToIgnoreCase(String2);
                break;
            }
            default: {
                ret = String1.compareToIgnoreCase(String2);
            }
        }
        if (ret > 0) {
            ret = 1;
        }
        return ret;
    }

    public static String ArrayToString(byte[] strArray) {
        try {
            return new String(strArray, "ISO-8859-1");
        }
        catch (Exception e) {
            try {
                return new String(strArray);
            }
            catch (Exception e2) {
                return "";
            }
        }
    }

    public static byte[] StringToArray(String strVal) {
        byte[] val;
        try {
            val = strVal.getBytes("ISO-8859-1");
        }
        catch (Exception e) {
            val = new byte[]{};
        }
        return val;
    }

    public static String StrReverse(String String1) {
        byte[] val = Strings.StringToArray(String1);
        byte[] val2 = new byte[val.length];
        for (int i = 0; i < val.length; ++i) {
            val2[val.length - i - 1] = val[i];
        }
        return Strings.ArrayToString(val2);
    }

    private static String PCase(String String1) {
        return String1;
    }

    private static String XCase(String String1) {
        return String1;
    }

    public static String StrConv(String String1, VBStrConv ConvMet) {
        switch (ConvMet.intValue()) {
            case 1: {
                return Strings.UCase(String1);
            }
            case 2: {
                return Strings.LCase(String1);
            }
            case 3: {
                return Strings.PCase(String1);
            }
            case 4: {
                return Strings.XCase(String1);
            }
            case 8: {
                return Strings.XCase(String1);
            }
            case 16: {
                return Strings.XCase(String1);
            }
            case 32: {
                return Strings.XCase(String1);
            }
            case 64: {
                return Strings.XCase(String1);
            }
            case 128: {
                return Strings.XCase(String1);
            }
        }
        return String1;
    }

    public static VBArrayString Split(String String1) throws Exception {
        VBArray ret = new VBArray();
        byte[] myAry = Strings.StringToArray(String1);
        ret.setBound(0, myAry.length - 1, false);
        for (int i = 0; i < myAry.length; ++i) {
            ret.setValueStr(i, Strings.Chr(myAry[i]));
        }
        return ret;
    }

    public static VBArrayString Split(String String1, String Delimiter) throws Exception {
        return Strings.Split(String1, Delimiter, -1L);
    }

    public static VBArrayString Split(String String1, String Delimiter, long Limit) throws Exception {
        return Strings.Split(String1, Delimiter, Limit, VBCompareMethod.vbBinaryCompare);
    }

    public static VBArrayString Split(String String1, String Delimiter, long Limit, VBCompareMethod CompareMet) throws Exception {
        VBArray ret = new VBArray();
        if (Limit == 0L) {
            Limit = -1L;
        }
        if (Limit == 1L) {
            ret.addStringItem(String1);
            return ret;
        }
        int iStart = 1;
        int iLast = 1;
        int iMemStart = 0;
        int iLenDelimiter = Delimiter.length();
        int i = 1;
        while (((long)i < Limit || Limit == -1L) && iStart >= 0) {
            if ((iStart = Strings.InStr(iStart, String1, Delimiter, CompareMet)) == 0) {
                iStart = -1;
            } else {
                iMemStart = iStart;
                ret.addStringItem(Strings.Mid(String1, iLast, (iStart += iLenDelimiter) - iLast - iLenDelimiter));
                iLast = iStart;
            }
            ++i;
        }
        if (iMemStart == 0) {
            ret.addStringItem(String1);
        } else {
            ret.addStringItem(Strings.Mid(String1, iMemStart + iLenDelimiter, Strings.Len(String1) - iMemStart + 1 - iLenDelimiter));
        }
        return ret;
    }

    public static String WeekdayName(int Weekday) {
        return Strings.WeekdayName(Weekday, false);
    }

    public static String WeekdayName(int Weekday, boolean Abbreviate) {
        return Strings.WeekdayName(Weekday, Abbreviate, VBDayOfWeek.vbMonday);
    }

    public static String WeekdayName(int Weekday, boolean Abbreviate, VBDayOfWeek FirstDayOfWeek) {
        int WeekdayIntern;
        if (Weekday < 1 || Weekday > 7) {
            return Constants.vbNullString;
        }
        String[] weekdayName = new String[]{"Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"};
        String[] weekdayNameAbbreviate = new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};
        int iFirstDayOfWeek = FirstDayOfWeek.intValue();
        if (iFirstDayOfWeek == 0) {
            iFirstDayOfWeek = 1;
        }
        if ((WeekdayIntern = Weekday + iFirstDayOfWeek - 3) < 0) {
            WeekdayIntern = 7 + WeekdayIntern;
        }
        if (WeekdayIntern > 6) {
            WeekdayIntern -= 7;
        }
        if (WeekdayIntern >= 0 && WeekdayIntern < 7) {
            if (Abbreviate) {
                return weekdayNameAbbreviate[WeekdayIntern];
            }
            return weekdayName[WeekdayIntern];
        }
        return Constants.vbNullString;
    }

    public static String MonthName(int Month) {
        return Strings.MonthName(Month, false);
    }

    public static String MonthName(int Month, boolean Abbreviate) {
        String[] monthName = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        String[] monthNameAbbreviate = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        if (--Month >= 0 && Month < 12) {
            if (Abbreviate) {
                return monthNameAbbreviate[Month];
            }
            return monthName[Month];
        }
        return Constants.vbNullString;
    }

    public static String Join(VBArrayString val) throws Exception {
        return Strings.Join(val, Constants.vbNullString);
    }

    public static String Join(VBArrayString val, String Delimiter) throws Exception {
        StringBuffer strBuffer = new StringBuffer();
        for (int i = val.getLBound(); i <= val.getUBound(); ++i) {
            strBuffer.append(val.valueOfStr(i));
            if (i >= val.getUBound() || Delimiter.length() <= 0) continue;
            strBuffer.append(Delimiter);
        }
        return strBuffer.toString();
    }

    public static VBArrayString Filter(VBArrayString val, String Match) throws Exception {
        return Strings.Filter(val, Match, true);
    }

    public static VBArrayString Filter(VBArrayString val, String Match, boolean Include) throws Exception {
        return Strings.Filter(val, Match, Include, VBCompareMethod.vbBinaryCompare);
    }

    public static VBArrayString Filter(VBArrayString val, String Match, boolean Include, VBCompareMethod CompareMet) throws Exception {
        VBArray ret = new VBArray();
        for (int i = val.getLBound(); i <= val.getUBound(); ++i) {
            String CurrentItem = val.valueOfStr(i);
            if (Strings.InStr(1, CurrentItem, Match, CompareMet) > 0) {
                if (!Include) continue;
                ret.addStringItem(CurrentItem);
                continue;
            }
            if (Include) continue;
            ret.addStringItem(CurrentItem);
        }
        return ret;
    }

    public static String Format(String Expression, String Format2) {
        try {
            GregorianCalendar tmpCal = VBDateParser.parse(Expression);
            return tmpCal.toString();
        }
        catch (Exception e) {
            return e.toString();
        }
    }
}

