/*
 * Decompiled with CFR 0.152.
 */
package VBA;

import VBA.VBDateParserState;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VBDateParser {
    public static final int YEAR_BEFORE_MONTH = 4;
    public static final int YEAR_BEFORE_DAY = 2;
    public static final int MONTH_BEFORE_DAY = 1;
    public static final int YEAR_AFTER_MONTH = 0;
    public static final int YEAR_AFTER_DAY = 0;
    public static final int MONTH_AFTER_DAY = 0;
    public static final int DD_MM_YY = 0;
    public static final int MM_DD_YY = 1;
    public static final int MM_YY_DD = 3;
    public static final int DD_YY_MM = 4;
    public static final int YY_DD_MM = 6;
    public static final int YY_MM_DD = 7;
    private static final int PLACE_UNKNOWN = 0;
    private static final int PLACE_HOUR = 1;
    private static final int PLACE_MINUTE = 2;
    private static final int PLACE_SECOND = 3;
    private static final int PLACE_MILLI = 4;
    private static final int CENTURY_OFFSET = 2000;
    private static final int UNSET = Integer.MIN_VALUE;
    private static final boolean DEBUG = false;
    private static final String[] WEEKDAY_NAMES = new String[]{"sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday"};
    private static final String[][] MONTHS = new String[][]{{"jan", "January"}, {"feb", "February"}, {"mar", "March"}, {"apr", "April"}, {"may", "May"}, {"jun", "June"}, {"jul", "July"}, {"aug", "August"}, {"sep", "September"}, {"oct", "October"}, {"nov", "November"}, {"dec", "December"}};

    private static final void appendTimeString(StringBuffer buf, GregorianCalendar cal, boolean needSpace) {
        TimeZone tz;
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        int milli = cal.get(14);
        if (hour != 0 || minute != 0 || second != 0 || milli != 0) {
            if (needSpace) {
                buf.append(' ');
            }
            if (hour < 10) {
                buf.append(' ');
            }
            buf.append(hour);
            if (minute < 10) {
                buf.append(":0");
            } else {
                buf.append(':');
            }
            buf.append(minute);
            if (second != 0 || milli != 0) {
                if (second < 10) {
                    buf.append(":0");
                } else {
                    buf.append(':');
                }
                buf.append(second);
                if (milli != 0) {
                    if (milli < 10) {
                        buf.append(".00");
                    } else if (milli < 100) {
                        buf.append(".0");
                    } else {
                        buf.append('.');
                    }
                    buf.append(milli);
                }
            }
        }
        if ((tz = cal.getTimeZone()).getRawOffset() == 0) {
            buf.append(" GMT");
        } else {
            buf.append(' ');
            int offset = tz.getRawOffset() / 60000;
            if (offset < 0) {
                buf.append('-');
                offset = -offset;
            } else {
                buf.append('+');
            }
            int hrOff = offset / 60;
            if (hrOff < 10) {
                buf.append('0');
            }
            buf.append(hrOff);
            buf.append(':');
            int minOff = offset % 60;
            if (minOff < 10) {
                buf.append('0');
            }
            buf.append(minOff);
        }
    }

    public static final String getOrderString(int order) {
        switch (order) {
            case 0: {
                return "DD_MM_YY";
            }
            case 1: {
                return "MM_DD_YY";
            }
            case 3: {
                return "MM_YY_DD";
            }
            case 4: {
                return "DD_YY_MM";
            }
            case 6: {
                return "YY_DD_MM";
            }
            case 7: {
                return "YY_MM_DD";
            }
        }
        return "??" + order + "??";
    }

    private static final int getOrdinalNumber(String str) {
        String suffix;
        int len;
        int n = len = str == null ? 0 : str.length();
        if (len >= 3 && ((suffix = str.substring(len - 2)).equalsIgnoreCase("st") || suffix.equalsIgnoreCase("nd") || suffix.equalsIgnoreCase("rd") || suffix.equalsIgnoreCase("th"))) {
            try {
                return Integer.parseInt(str.substring(0, len - 2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Integer.MIN_VALUE;
    }

    private static final String getTimePlaceString(int place) {
        switch (place) {
            case 1: {
                return "hour";
            }
            case 2: {
                return "minute";
            }
            case 3: {
                return "second";
            }
            case 4: {
                return "millisecond";
            }
        }
        return "unknown";
    }

    private static final boolean isWeekdayName(String str) {
        if (str == null || str.length() < 3) {
            return false;
        }
        String lstr = str.toLowerCase();
        for (int i = 0; i < WEEKDAY_NAMES.length; ++i) {
            if (!lstr.startsWith(WEEKDAY_NAMES[i]) && !WEEKDAY_NAMES[i].toLowerCase().startsWith(lstr)) continue;
            return true;
        }
        return false;
    }

    public static int monthNameToNumber(String str) {
        if (str != null && str.length() >= 3) {
            String lstr = str.toLowerCase();
            for (int i = 0; i < MONTHS.length; ++i) {
                if (!lstr.startsWith(MONTHS[i][0]) && !MONTHS[i][1].toLowerCase().startsWith(lstr)) continue;
                return i + 1;
            }
        }
        return Integer.MIN_VALUE;
    }

    public static final GregorianCalendar parse(String dateStr) throws Exception {
        return VBDateParser.parse(dateStr, 7);
    }

    public static final GregorianCalendar parse(String dateStr, int order) throws Exception {
        return VBDateParser.parse(dateStr, order, true);
    }

    public static final GregorianCalendar parse(String dateStr, int order, boolean ignoreChanges) throws Exception {
        if (dateStr == null) {
            return null;
        }
        return VBDateParser.parseString(dateStr, order, ignoreChanges);
    }

    private static final void parseNonNumericToken(String dateStr, VBDateParserState state, String token) throws Exception {
        if (VBDateParser.isWeekdayName(token)) {
            return;
        }
        if (token.indexOf(58) > 0) {
            char firstChar = token.charAt(0);
            if (Character.isDigit(firstChar)) {
                VBDateParser.parseTime(dateStr, state, token);
                return;
            }
            if (firstChar == '+' || firstChar == '-') {
                VBDateParser.parseTimeZoneOffset(dateStr, state, token);
                return;
            }
            throw new Exception("Unrecognized time \"" + token + "\" in date \"" + dateStr + "\"");
        }
        int tmpMon = VBDateParser.monthNameToNumber(token);
        if (tmpMon != Integer.MIN_VALUE) {
            if (!state.isMonthSet()) {
                state.setMonth(tmpMon);
                return;
            }
            if (!state.isYearSet()) {
                if (state.isDateSet() || state.isYearBeforeDay()) {
                    state.setYear(state.getMonth());
                    state.setMonth(tmpMon);
                } else {
                    state.setDate(state.getMonth());
                    state.setMonth(tmpMon);
                }
                return;
            }
            if (!state.isDateSet()) {
                state.setDate(state.getMonth());
                state.setMonth(tmpMon);
                return;
            }
            throw new Exception("Too many numbers in date \"" + dateStr + "\"");
        }
        int val = VBDateParser.getOrdinalNumber(token);
        if (val == Integer.MIN_VALUE) {
            String lToken = token.toLowerCase();
            if (lToken.equals("am")) {
                return;
            }
            if (lToken.equals("pm")) {
                if (!state.isHourSet()) {
                    state.setTimePostMeridian(true);
                } else {
                    state.setHour(state.getHour() + 12);
                }
                return;
            }
            throw new Exception("Unknown string \"" + token + "\" in date \"" + dateStr + "\"");
        }
        if (!state.isDateSet()) {
            state.setDate(val);
            return;
        }
        if (!state.isYearSet() || !state.isMonthSet()) {
            if (state.getDate() > 12) {
                if (!state.isYearSet()) {
                    state.setYear(state.getDate());
                    state.setDate(val);
                    return;
                }
                if (state.getYear() <= 12) {
                    state.setMonth(state.getYear());
                    state.setYear(state.getDate());
                    state.setDate(val);
                    return;
                }
            } else {
                if (!state.isYearSet()) {
                    if (!state.isMonthSet() && !state.isYearBeforeMonth()) {
                        state.setMonth(state.getDate());
                        state.setDate(val);
                        return;
                    }
                    state.setYear(state.getDate());
                    state.setDate(val);
                    return;
                }
                state.setMonth(state.getDate());
                state.setDate(val);
                return;
            }
        }
        throw new Exception("Cannot assign ordinal in \"" + dateStr + "\"");
    }

    private static final void parseNumericBlob(String dateStr, VBDateParserState state, int val) throws Exception {
        if (state.isYearSet() || state.isMonthSet() || state.isDateSet()) {
            throw new Exception("Unknown value " + val + " in date \"" + dateStr + "\"");
        }
        int tmpVal = val;
        if (state.isYearBeforeMonth()) {
            if (state.isYearBeforeDay()) {
                int last = tmpVal % 100;
                int middle = (tmpVal /= 100) % 100;
                state.setYear(tmpVal /= 100);
                if (state.isMonthBeforeDay()) {
                    state.setMonth(middle);
                    state.setDate(last);
                } else {
                    state.setDate(middle);
                    state.setMonth(last);
                }
            } else {
                state.setMonth(tmpVal % 100);
                state.setYear((tmpVal /= 100) % 10000);
                state.setDate(tmpVal /= 10000);
            }
        } else if (state.isYearBeforeDay()) {
            state.setDate(tmpVal % 100);
            state.setYear((tmpVal /= 100) % 10000);
            state.setMonth(tmpVal /= 10000);
        } else {
            state.setYear(tmpVal % 10000);
            int middle = (tmpVal /= 10000) % 100;
            tmpVal /= 100;
            if (state.isMonthBeforeDay()) {
                state.setDate(middle);
                state.setMonth(tmpVal);
            } else {
                state.setDate(tmpVal);
                state.setMonth(middle);
            }
        }
    }

    private static final void parseNumericToken(String dateStr, VBDateParserState state, int val) throws Exception {
        if (state.isYearSet() && state.isMonthSet() && state.isDateSet()) {
            throw new Exception("Extra value \"" + val + "\" in date \"" + dateStr + "\"");
        }
        if (val < 0) {
            throw new Exception("Found negative number in date \"" + dateStr + "\"");
        }
        if (val > 9999) {
            VBDateParser.parseNumericBlob(dateStr, state, val);
            return;
        }
        if (val > 31) {
            if (!state.isYearSet()) {
                state.setYear(val);
                return;
            }
            if (state.getYear() > 31) {
                String errMsg = "Couldn't decide on year number in date \"" + dateStr + "\"";
                throw new Exception(errMsg);
            }
            if (state.getYear() > 12) {
                if (!state.isDateSet()) {
                    state.setDate(state.getYear());
                    state.setYear(val);
                    return;
                }
                if (state.getDate() <= 12) {
                    state.setMonth(state.getDate());
                    state.setDate(state.getYear());
                    state.setYear(val);
                    return;
                }
                throw new Exception("Bad number " + val + " found in date \"" + dateStr + "\"");
            }
            if (!state.isDateSet() && !state.isMonthSet()) {
                if (state.isMonthBeforeDay()) {
                    state.setMonth(state.getYear());
                    state.setYear(val);
                } else {
                    state.setDate(state.getYear());
                    state.setYear(val);
                }
                return;
            }
            if (!state.isDateSet()) {
                state.setDate(state.getYear());
                state.setYear(val);
                return;
            }
            state.setMonth(state.getYear());
            state.setYear(val);
            return;
        }
        if (val > 12) {
            if (!state.isYearSet()) {
                if (state.isDateSet() || state.isYearBeforeDay()) {
                    state.setYear(val);
                } else {
                    state.setDate(val);
                }
                return;
            }
            if (!state.isDateSet()) {
                state.setDate(val);
                return;
            }
            throw new Exception("Bad number " + val + " found in date \"" + dateStr + "\"");
        }
        if (state.isYearSet()) {
            if (state.isMonthSet() || !state.isDateSet() && !state.isMonthBeforeDay()) {
                state.setDate(val);
            } else {
                state.setMonth(val);
            }
            return;
        }
        if (state.isMonthSet()) {
            if (state.isDateSet() || state.isYearBeforeDay()) {
                state.setYear(val);
            } else {
                state.setDate(val);
            }
            return;
        }
        if (state.isDateSet()) {
            if (state.isYearBeforeMonth()) {
                state.setYear(val);
            } else {
                state.setMonth(val);
            }
            return;
        }
        if (state.isYearBeforeMonth()) {
            if (state.isYearBeforeDay()) {
                state.setYear(val);
            } else {
                state.setDate(val);
            }
        } else if (state.isMonthBeforeDay()) {
            state.setMonth(val);
        } else {
            state.setDate(val);
        }
    }

    private static final GregorianCalendar parseString(String dateStr, int order, boolean ignoreChanges) throws Exception {
        VBDateParserState state = new VBDateParserState(order);
        Pattern pat = Pattern.compile("([\\s/,]+|(\\S)\\-)");
        Matcher matcher = pat.matcher(dateStr);
        int prevEnd = 0;
        while (prevEnd < dateStr.length()) {
            String token;
            if (!matcher.find()) {
                token = dateStr.substring(prevEnd);
                prevEnd = dateStr.length();
            } else {
                boolean isMinus = matcher.groupCount() == 2 && matcher.group(2) != null;
                token = !isMinus ? dateStr.substring(prevEnd, matcher.start()) : dateStr.substring(prevEnd, matcher.start()) + matcher.group(2);
                prevEnd = matcher.end();
            }
            try {
                int val = Integer.parseInt(token);
                try {
                    VBDateParser.parseNumericToken(dateStr, state, val);
                }
                catch (Exception ex) {
                }
            }
            catch (NumberFormatException e) {
                try {
                    VBDateParser.parseNonNumericToken(dateStr, state, token);
                }
                catch (Exception ex) {}
            }
        }
        if (!state.isDateSet() && state.getYear() <= 31) {
            int tmp = state.getDate();
            try {
                state.setDate(state.getYear());
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                state.setYear(tmp);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (!state.isDateSet()) {
            if (!state.isMonthSet()) {
                if (!state.isYearSet()) {
                    throw new Exception("No date found in \"" + dateStr + "\"");
                }
                throw new Exception("Day and month missing from \"" + dateStr + "\"");
            }
            throw new Exception("Day missing from \"" + dateStr + "\"");
        }
        if (!state.isMonthSet()) {
            if (!state.isYearSet()) {
                throw new Exception("Year and month missing from \"" + dateStr + "\"");
            }
            throw new Exception("Month missing from \"" + dateStr + "\"");
        }
        if (!state.isYearSet()) {
            throw new Exception("Year missing from \"" + dateStr + "\"");
        }
        int tmpYear = state.getYear();
        if (tmpYear < 50) {
            state.setYear(tmpYear + 2000);
        } else if (tmpYear < 100) {
            state.setYear(tmpYear + 1900);
        }
        GregorianCalendar cal = new GregorianCalendar();
        state.setCalendar(cal, ignoreChanges);
        return cal;
    }

    private static final void parseTime(String dateStr, VBDateParserState state, String timeStr) throws Exception {
        String tmpTime;
        int place = 1;
        char lastChar = timeStr.charAt(timeStr.length() - 1);
        if (lastChar != 'm' && lastChar != 'M') {
            tmpTime = timeStr;
        } else {
            char preLast = timeStr.charAt(timeStr.length() - 2);
            if (preLast == 'a' || preLast == 'A') {
                state.setTimePostMeridian(false);
            } else if (preLast == 'p' || preLast == 'P') {
                state.setTimePostMeridian(true);
            } else {
                throw new Exception("Bad time \"" + timeStr + "\" in date \"" + dateStr + "\"");
            }
            tmpTime = timeStr.substring(0, timeStr.length() - 2);
        }
        String[] tList = tmpTime.split("[:\\.]");
        block16: for (int i = 0; i < tList.length; ++i) {
            int val;
            String token = tList[i];
            try {
                val = Integer.parseInt(token);
            }
            catch (NumberFormatException nfe) {
                throw new Exception("Bad " + VBDateParser.getTimePlaceString(place) + " string \"" + token + "\" in \"" + dateStr + "\"");
            }
            switch (place) {
                case 1: {
                    try {
                        state.setHour(val);
                    }
                    catch (Exception dfe) {
                        throw new Exception(dfe.getMessage() + " in \"" + dateStr + "\"");
                    }
                    place = 2;
                    continue block16;
                }
                case 2: {
                    try {
                        state.setMinute(val);
                    }
                    catch (Exception dfe) {
                        throw new Exception(dfe.getMessage() + " in \"" + dateStr + "\"");
                    }
                    place = 3;
                    continue block16;
                }
                case 3: {
                    try {
                        state.setSecond(val);
                    }
                    catch (Exception dfe) {
                        throw new Exception(dfe.getMessage() + " in \"" + dateStr + "\"");
                    }
                    place = 4;
                    continue block16;
                }
                case 4: {
                    try {
                        state.setMillisecond(val);
                    }
                    catch (Exception dfe) {
                        throw new Exception(dfe.getMessage() + " in \"" + dateStr + "\"");
                    }
                    place = 0;
                    continue block16;
                }
                default: {
                    throw new Exception("Unexpected place value " + place);
                }
            }
        }
    }

    private static final void parseTimeZoneOffset(String dateStr, VBDateParserState state, String zoneStr) throws Exception {
        boolean isNegative;
        int place = 1;
        boolean bl = isNegative = zoneStr.charAt(0) == '-';
        if (!isNegative && zoneStr.charAt(0) != '+') {
            throw new Exception("Bad time zone offset \"" + zoneStr + "\" in date \"" + dateStr + "\"");
        }
        int hour = Integer.MIN_VALUE;
        int minute = Integer.MIN_VALUE;
        String[] tList = zoneStr.substring(1).split(":");
        block6: for (int i = 0; i < tList.length; ++i) {
            int val;
            String token = tList[i];
            try {
                val = Integer.parseInt(token);
            }
            catch (NumberFormatException nfe) {
                throw new Exception("Bad time zone " + VBDateParser.getTimePlaceString(place) + " offset \"" + token + "\" in \"" + dateStr + "\"");
            }
            switch (place) {
                case 1: {
                    hour = val;
                    place = 2;
                    continue block6;
                }
                case 2: {
                    minute = val;
                    place = 0;
                    continue block6;
                }
                default: {
                    throw new Exception("Unexpected place value " + place);
                }
            }
        }
        String customID = "GMT" + (isNegative ? "-" : "+") + hour + ":" + (minute < 10 ? "0" : "") + minute;
        state.setTimeZone(TimeZone.getTimeZone(customID));
    }

    public static final String prettyString(GregorianCalendar cal) {
        if (cal == null) {
            return null;
        }
        int calYear = cal.get(1);
        int calMonth = cal.get(2);
        int calDay = cal.get(5);
        boolean needSpace = false;
        StringBuffer buf = new StringBuffer();
        if (calMonth >= 0 && calMonth < MONTHS.length) {
            if (needSpace) {
                buf.append(' ');
            }
            buf.append(MONTHS[calMonth][1]);
            needSpace = true;
        }
        if (calDay > 0) {
            if (needSpace) {
                buf.append(' ');
            }
            buf.append(calDay);
            if (calYear > Integer.MIN_VALUE) {
                buf.append(',');
            }
            needSpace = true;
        }
        if (calYear > Integer.MIN_VALUE) {
            if (needSpace) {
                buf.append(' ');
            }
            buf.append(calYear);
        }
        VBDateParser.appendTimeString(buf, cal, needSpace);
        return buf.toString();
    }

    public static final String toString(GregorianCalendar cal) {
        if (cal == null) {
            return null;
        }
        int calYear = cal.get(1);
        int calMonth = cal.get(2);
        int calDay = cal.get(5);
        boolean needSpace = false;
        StringBuffer buf = new StringBuffer();
        if (calDay > 0) {
            if (needSpace) {
                buf.append(' ');
            }
            buf.append(calDay);
            needSpace = true;
        }
        if (calMonth >= 0 && calMonth < MONTHS.length) {
            if (needSpace) {
                buf.append(' ');
            }
            buf.append(MONTHS[calMonth][1].substring(0, 3));
            needSpace = true;
        }
        if (calYear > Integer.MIN_VALUE) {
            if (needSpace) {
                buf.append(' ');
            }
            buf.append(calYear);
        }
        VBDateParser.appendTimeString(buf, cal, needSpace);
        return buf.toString();
    }

    public static final String toSQLString(GregorianCalendar cal) {
        if (cal == null) {
            return null;
        }
        int calYear = cal.get(1);
        int calMonth = cal.get(2);
        int calDay = cal.get(5);
        StringBuffer buf = new StringBuffer();
        buf.append(calYear);
        buf.append('-');
        if (calMonth + 1 < 10) {
            buf.append('0');
        }
        buf.append(calMonth + 1);
        buf.append('-');
        if (calDay < 10) {
            buf.append('0');
        }
        buf.append(calDay);
        VBDateParser.appendTimeString(buf, cal, true);
        return buf.toString();
    }
}

