/*
 * Decompiled with CFR 0.152.
 */
package com.eaio.nativecall;

import com.eaio.nativecall.Verifier;

public class Win32Verifier
implements Verifier {
    public boolean supports() throws SecurityException {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public String verifyModuleName(String module) {
        if (module == null || module.length() == 0) {
            return this.getDefaultModule();
        }
        if (module.indexOf(47) != -1) {
            module = module.replace('/', '\\');
        }
        return module;
    }

    public String verifyFunctionName(String function) {
        if (function == null || function.length() == 0) {
            throw new NullPointerException();
        }
        return function;
    }

    public String getDefaultModule() {
        return "kernel32";
    }

    public Object handleString(String val, String module, String function) {
        if (function.charAt(function.length() - 1) == 'W') {
            char[] buf = new char[val.length() + 1];
            val.getChars(0, val.length(), buf, 0);
            return buf;
        }
        byte[] buf = new byte[val.length() + 1];
        val.getBytes(0, val.length(), buf, 0);
        return buf;
    }
}

