/*
 * Decompiled with CFR 0.152.
 */
package com.eaio.util.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class NativeLoader {
    private static String osPrefix;
    private static String osSuffix;
    private final String name;
    private final String nativeName;
    private boolean attemptedLoading;
    private boolean loadingSuccessful;

    static {
        String n = System.getProperty("os.name");
        String a = System.getProperty("os.arch");
        NativeLoader.init(n, a);
    }

    private static void init(String name, String arch) {
        if (name.startsWith("Windows")) {
            osSuffix = ".dll";
        } else if (name.equals("Mac OS X")) {
            osPrefix = "lib";
            osSuffix = ".jnilib";
        } else {
            osPrefix = "lib";
            if (name.equals("Linux")) {
                osSuffix = arch.indexOf("64") == -1 ? "-linux-x86.so" : "-linux-x86_64.so";
            } else if (name.equals("Solaris") || name.equals("SunOS")) {
                osSuffix = arch.indexOf("86") > -1 ? "-solaris-x86.so" : "-solaris-sparc.so";
            } else if (name.indexOf("BSD") > -1) {
                osSuffix = "-bsd.so";
            }
        }
    }

    public NativeLoader(String name) {
        this.name = name;
        StringBuffer buf = new StringBuffer(name.length() + (osPrefix == null ? 0 : osPrefix.length()) + osSuffix.length());
        if (osPrefix != null) {
            buf.append(osPrefix);
        }
        buf.append(name);
        buf.append(osSuffix);
        this.nativeName = buf.toString();
    }

    public final synchronized void load() throws SecurityException, UnsatisfiedLinkError, IOException {
        if (!this.attemptedLoading) {
            URL u;
            this.attemptedLoading = true;
            try {
                Runtime.getRuntime().loadLibrary(this.name);
                this.loadingSuccessful = true;
                return;
            }
            catch (SecurityException securityException) {
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
            File f = new File(this.nativeName);
            if (f.isFile()) {
                try {
                    Runtime.getRuntime().load(f.getAbsolutePath());
                    this.loadingSuccessful = true;
                    return;
                }
                catch (SecurityException securityException) {
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    // empty catch block
                }
            }
            if ((u = this.findURL(this.getClass().getClassLoader())) != null) {
                f = new File(u.getFile());
                if (f.exists()) {
                    Runtime.getRuntime().load(f.getAbsolutePath());
                    this.loadingSuccessful = true;
                    return;
                }
                BufferedInputStream in = null;
                FilterOutputStream out = null;
                File tempFile = null;
                try {
                    int len;
                    tempFile = File.createTempFile("temp", osSuffix, null);
                    tempFile.deleteOnExit();
                    in = new BufferedInputStream(u.openStream(), 4096);
                    out = new BufferedOutputStream(new FileOutputStream(tempFile), 4096);
                    byte[] buf = new byte[4096];
                    while ((len = in.read(buf)) > 0) {
                        ((BufferedOutputStream)out).write(buf, 0, len);
                    }
                }
                catch (Throwable throwable) {
                    Object var8_13 = null;
                    try {
                        in.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        out.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    throw throwable;
                }
                Object var8_14 = null;
                try {
                    in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    out.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (tempFile != null) {
                    Runtime.getRuntime().load(tempFile.getAbsolutePath());
                    this.loadingSuccessful = true;
                    return;
                }
            }
            this.loadingSuccessful = false;
            throw new UnsatisfiedLinkError(this.name);
        }
    }

    public final synchronized boolean tryLoad() {
        if (!this.attemptedLoading) {
            try {
                this.load();
                return this.loadingSuccessful;
            }
            catch (SecurityException securityException) {
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        return this.loadingSuccessful;
    }

    protected URL findURL(ClassLoader cl) {
        File f;
        URL u = cl.getResource(this.nativeName);
        String nativeFile = new StringBuffer("native/".length() + this.nativeName.length()).append("native/").append(this.nativeName).toString();
        String metaInfFile = new StringBuffer("META-INF/".length() + this.nativeName.length()).append("META-INF/").append(this.nativeName).toString();
        if (u == null) {
            u = cl.getResource(nativeFile);
        }
        if (u == null) {
            u = cl.getResource(metaInfFile);
        }
        if (u == null && (f = new File(nativeFile)).exists()) {
            try {
                u = f.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (u == null && (f = new File(metaInfFile)).exists()) {
            try {
                u = f.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return u;
    }

    public final String getGeneratedName() {
        return this.nativeName;
    }

    public final String getName() {
        return this.name;
    }

    public final String toString() {
        return this.toStringBuffer(null).toString();
    }

    public StringBuffer toStringBuffer(StringBuffer in) {
        if (in == null) {
            in = new StringBuffer(64);
        } else {
            in.ensureCapacity(in.length() + 64);
        }
        in.append("{ NativeLoader: name = ");
        in.append(this.name);
        in.append(", nativeName = ");
        in.append(this.nativeName);
        in.append(" }");
        return in;
    }
}

