/*
 * Decompiled with CFR 0.152.
 */
package VBA;

import VBA.Constants;
import VBA.VBArray;
import VBA.VBEnumClass;
import VBA.VBVarType;
import VBA.VBVariant;
import java.awt.Color;
import java.awt.SystemColor;
import java.util.Date;

public class Information {
    public static Color RGBtoColor(long lRGB) {
        if (lRGB < 0L) {
            if (lRGB == -2147483647L) {
                return SystemColor.desktop;
            }
            if (lRGB == -2147483646L) {
                return SystemColor.activeCaption;
            }
            if (lRGB == -2147483639L) {
                return SystemColor.activeCaptionText;
            }
            if (lRGB == -2147483638L) {
                return SystemColor.activeCaptionBorder;
            }
            if (lRGB == -2147483645L) {
                return SystemColor.inactiveCaption;
            }
            if (lRGB == -2147483629L) {
                return SystemColor.inactiveCaptionText;
            }
            if (lRGB == -2147483637L) {
                return SystemColor.inactiveCaptionBorder;
            }
            if (lRGB == -2147483643L) {
                return SystemColor.window;
            }
            if (lRGB == -2147483642L) {
                return SystemColor.windowBorder;
            }
            if (lRGB == -2147483640L) {
                return SystemColor.windowText;
            }
            if (lRGB == -2147483644L) {
                return SystemColor.menu;
            }
            if (lRGB == -2147483641L) {
                return SystemColor.menuText;
            }
            if (lRGB == -2147483635L) {
                return SystemColor.textHighlight;
            }
            if (lRGB == -2147483634L) {
                return SystemColor.textHighlightText;
            }
            if (lRGB == -2147483633L) {
                return SystemColor.control;
            }
            if (lRGB == -2147483630L) {
                return SystemColor.controlText;
            }
            if (lRGB == -2147483626L) {
                return SystemColor.controlShadow;
            }
            if (lRGB == -2147483627L) {
                return SystemColor.controlDkShadow;
            }
            if (lRGB == -2147483631L) {
                return SystemColor.textInactiveText;
            }
            if (lRGB == Integer.MIN_VALUE) {
                return SystemColor.scrollbar;
            }
            if (lRGB == -2147483624L) {
                return SystemColor.info;
            }
            if (lRGB == -2147483625L) {
                return SystemColor.infoText;
            }
            return Information.RGBtoColor(Information.RGB(255, 55, 55));
        }
        return new Color(Information.getRfromRGB(lRGB), Information.getGfromRGB(lRGB), Information.getBfromRGB(lRGB));
    }

    private static int getRfromRGB(long lRGB) {
        return (int)(lRGB / 1L & 0xFFL);
    }

    private static int getGfromRGB(long lRGB) {
        return (int)(lRGB / 256L & 0xFFL);
    }

    private static int getBfromRGB(long lRGB) {
        return (int)(lRGB / 65536L & 0xFFL);
    }

    private static int getAfromRGB(long lRGB) {
        return (int)(lRGB / 0x1000000L & 0xFFL);
    }

    public static long ColorToRGB(Color cColor) {
        return Information.RGB(cColor.getRed(), cColor.getGreen(), cColor.getBlue());
    }

    public static long BGRtoRGB(long lBGR) {
        return Information.RGBtoBGR(lBGR);
    }

    public static long RGBtoBGR(long lRGB) {
        Color tmpColor = new Color((int)lRGB);
        return Information.RGB(tmpColor.getRed(), tmpColor.getGreen(), tmpColor.getBlue());
    }

    public static long RGB(int R, int G, int B) {
        return Information.RGB(R, G, B, 0);
    }

    public static long RGB(int R, int G, int B, int A) {
        return A * 256 * 256 * 256 + B * 256 * 256 + G * 256 + R;
    }

    public static long QBColor(int iColor) {
        switch (iColor) {
            case 0: {
                return Information.RGB(0, 0, 0);
            }
            case 1: {
                return Information.RGB(0, 0, 128);
            }
            case 2: {
                return Information.RGB(0, 128, 0);
            }
            case 3: {
                return Information.RGB(0, 128, 128);
            }
            case 4: {
                return Information.RGB(128, 0, 0);
            }
            case 5: {
                return Information.RGB(128, 0, 128);
            }
            case 6: {
                return Information.RGB(128, 128, 0);
            }
            case 7: {
                return Information.RGB(192, 192, 192);
            }
            case 8: {
                return Information.RGB(128, 128, 128);
            }
            case 9: {
                return Information.RGB(0, 0, 255);
            }
            case 10: {
                return Information.RGB(0, 255, 0);
            }
            case 11: {
                return Information.RGB(0, 255, 255);
            }
            case 12: {
                return Information.RGB(255, 0, 0);
            }
            case 13: {
                return Information.RGB(255, 0, 255);
            }
            case 14: {
                return Information.RGB(255, 255, 0);
            }
            case 15: {
                return Information.RGB(255, 255, 255);
            }
        }
        return 0L;
    }

    public static boolean IsFloatingPoint(double val) {
        return val != (double)((long)val);
    }

    public static boolean IsNumeric(String val) {
        try {
            Double.parseDouble(val);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean IsNull(Object val) {
        return val == null;
    }

    public static boolean IsArray(Object val) {
        return val instanceof VBArray;
    }

    public static boolean IsEnum(Object val) {
        return val instanceof VBEnumClass;
    }

    public static String TypeName(Object val) {
        if (val == null) {
            return "Nothing";
        }
        return val.getClass().getName();
    }

    public static VBVarType VarType(Object val) {
        if (Information.IsNull(val)) {
            return VBVarType.vbNull;
        }
        if (Information.IsArray(val)) {
            return VBVarType.vbArray;
        }
        if (Information.IsEnum(val)) {
            return VBVarType.vbUserDefinedType;
        }
        if (val instanceof VBVariant) {
            return VBVarType.vbVariant;
        }
        if (val instanceof String) {
            if (val == Constants.vbNullString) {
                return VBVarType.vbEmpty;
            }
            return VBVarType.vbString;
        }
        if (val instanceof Date) {
            return VBVarType.vbDate;
        }
        if (val instanceof Exception) {
            return VBVarType.vbError;
        }
        if (val instanceof Integer) {
            return VBVarType.vbInteger;
        }
        if (val instanceof Long) {
            return VBVarType.vbLong;
        }
        if (val instanceof Float) {
            return VBVarType.vbSingle;
        }
        if (val instanceof Double) {
            return VBVarType.vbDouble;
        }
        if (val instanceof Boolean) {
            return VBVarType.vbBoolean;
        }
        if (val instanceof Byte) {
            return VBVarType.vbByte;
        }
        return VBVarType.vbObject;
    }
}

