/*
 * Decompiled with CFR 0.152.
 */
package VBA;

import VBA.Conversion;
import VBA.IVBArray;
import VBA.Strings;
import VBA.VBArrayBoolean;
import VBA.VBArrayByte;
import VBA.VBArrayChar;
import VBA.VBArrayDate;
import VBA.VBArrayDouble;
import VBA.VBArrayInteger;
import VBA.VBArrayIterator;
import VBA.VBArrayLong;
import VBA.VBArrayObject;
import VBA.VBArraySingle;
import VBA.VBArrayString;
import VBA.VBArrayVariant;
import VBA.VBVariant;
import java.util.Date;
import java.util.Iterator;

public class VBArray
implements Cloneable,
VBArrayString,
VBArrayVariant,
VBArrayChar,
VBArrayByte,
VBArrayDate,
VBArrayDouble,
VBArrayInteger,
VBArrayLong,
VBArrayBoolean,
VBArraySingle,
VBArrayObject,
IVBArray {
    Class myClass;
    int iUBound = -1;
    int iLBound = 0;
    int iDimension = 0;
    Object[] colObject;
    boolean writeBack = false;
    byte[] colByte;
    int[] colInteger;
    double[] colDouble;
    long[] colLong;
    float[] colFloat;
    boolean[] colBoolean;
    int LastIndex = -1;

    public VBArray() {
    }

    public byte[] byteArray() throws Exception {
        this.writeBackArray();
        if (this.colObject == null) {
            return null;
        }
        this.colByte = new byte[this.colObject.length];
        for (int i = 0; i < this.colObject.length; ++i) {
            this.colByte[i] = Conversion.CByte(this.colObject[i]);
        }
        this.writeBack = true;
        return this.colByte;
    }

    public boolean[] boolArray() throws Exception {
        this.writeBackArray();
        if (this.colObject == null) {
            return null;
        }
        this.colBoolean = new boolean[this.colObject.length];
        for (int i = 0; i < this.colObject.length; ++i) {
            this.colBoolean[i] = Conversion.CInt(this.colObject[i]) != 0;
        }
        this.writeBack = true;
        return this.colBoolean;
    }

    public int[] intArray() throws Exception {
        this.writeBackArray();
        if (this.colObject == null) {
            return null;
        }
        this.colInteger = new int[this.colObject.length];
        for (int i = 0; i < this.colObject.length; ++i) {
            this.colInteger[i] = Conversion.CInt(this.colObject[i]);
        }
        this.writeBack = true;
        return this.colInteger;
    }

    public double[] doubleArray() throws Exception {
        this.writeBackArray();
        if (this.colObject == null) {
            return null;
        }
        this.colDouble = new double[this.colObject.length];
        for (int i = 0; i < this.colObject.length; ++i) {
            this.colDouble[i] = Conversion.CDbl(this.colObject[i]);
        }
        this.writeBack = true;
        return this.colDouble;
    }

    public long[] longArray() throws Exception {
        this.writeBackArray();
        if (this.colObject == null) {
            return null;
        }
        this.colLong = new long[this.colObject.length];
        for (int i = 0; i < this.colObject.length; ++i) {
            this.colLong[i] = Conversion.CLng(this.colObject[i]);
        }
        this.writeBack = true;
        return this.colLong;
    }

    public float[] floatArray() throws Exception {
        this.writeBackArray();
        if (this.colObject == null) {
            return null;
        }
        this.colFloat = new float[this.colObject.length];
        for (int i = 0; i < this.colObject.length; ++i) {
            this.colFloat[i] = new Float(Conversion.CDbl(this.colObject[i])).floatValue();
        }
        this.writeBack = true;
        return this.colFloat;
    }

    public String[] stringArray() throws Exception {
        if (this.colObject == null) {
            return null;
        }
        String[] colString = new String[this.colObject.length];
        for (int i = 0; i < this.colObject.length; ++i) {
            colString[i] = new String((String)this.colObject[i]);
        }
        return colString;
    }

    public Object[] objectArray() throws Exception {
        return this.colObject;
    }

    public Object[] objectArrayClone() {
        if (this.colObject == null) {
            return null;
        }
        Object[] colClone = new Object[this.colObject.length];
        for (int i = 0; i < this.colObject.length; ++i) {
            colClone[i] = this.colObject[i] instanceof Boolean ? new Boolean((Boolean)this.colObject[i]) : (this.colObject[i] instanceof Byte ? new Byte((Byte)this.colObject[i]) : (this.colObject[i] instanceof Long ? new Long((Long)this.colObject[i]) : (this.colObject[i] instanceof Integer ? new Integer((Integer)this.colObject[i]) : (this.colObject[i] instanceof Double ? new Double((Double)this.colObject[i]) : (this.colObject[i] instanceof Float ? new Float(((Float)this.colObject[i]).floatValue()) : (this.colObject[i] instanceof String ? new String(((String)this.colObject[i]).toString()) : this.colObject[i]))))));
        }
        return colClone;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception e) {
            return this;
        }
    }

    public VBArray cloneSimple() throws Exception {
        Object[] obj = this.objectArrayClone();
        VBArray ret = new VBArray();
        ret = obj == null ? new VBArray() : new VBArray(obj);
        return ret;
    }

    public VBArray cloneArray() throws Exception {
        if (this.iDimension == 0) {
            return this.cloneSimple();
        }
        VBArray ret = new VBArray(this.iLBound, this.iUBound, this.iDimension);
        for (int i = 0; i < this.colObject.length; ++i) {
            ret.setValueNative(i, ((VBArray)this.colObject[i]).cloneArray());
        }
        return ret;
    }

    private void writeBackArray() {
        if (!this.writeBack) {
            return;
        }
        for (int i = 0; i < this.colObject.length; ++i) {
            if (this.colByte != null && this.colByte.length == this.colObject.length) {
                this.colObject[i] = new Integer(this.colByte[i]);
            }
            if (this.colInteger != null && this.colInteger.length == this.colObject.length) {
                this.colObject[i] = new Integer(this.colInteger[i]);
            }
            if (this.colDouble != null && this.colDouble.length == this.colObject.length) {
                this.colObject[i] = new Double(this.colDouble[i]);
            }
            if (this.colLong != null && this.colLong.length == this.colObject.length) {
                this.colObject[i] = new Long(this.colLong[i]);
            }
            if (this.colFloat != null && this.colFloat.length == this.colObject.length) {
                this.colObject[i] = new Double(this.colFloat[i]);
            }
            if (this.colBoolean == null || this.colBoolean.length != this.colObject.length) continue;
            this.colObject[i] = new Integer(this.colBoolean[i] ? 1 : 0);
        }
        this.clearWriteBackArray();
    }

    private void clearWriteBackArray() {
        this.colByte = null;
        this.colInteger = null;
        this.colDouble = null;
        this.colLong = null;
        this.colFloat = null;
        this.colBoolean = null;
        this.writeBack = false;
    }

    public Iterator iterator() {
        return new VBArrayIterator(this.colObject);
    }

    public Object valueOf(int Index) throws Exception {
        this.writeBackArray();
        this.LastIndex = this.calcOffset(Index);
        if (this.myClass != null) {
            try {
                if (this.colObject[this.LastIndex] == null) {
                    this.colObject[this.LastIndex] = this.myClass.newInstance();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.colObject[this.LastIndex];
    }

    public void setValueNative(int Index, Object Value) {
        this.colObject[Index] = Value;
    }

    public void setValue(int Index, Object Value) throws Exception {
        this.writeBackArray();
        try {
            this.LastIndex = this.calcOffset(Index);
            this.colObject[this.calcOffset((int)Index)] = Value;
        }
        catch (Exception e) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public int getLBound() throws Exception {
        return this.getLBound(1);
    }

    public int getLBound(int Index) throws Exception {
        return this.getLBoundInternal(this.iDimension + 1 - Index);
    }

    private int getLBoundInternal(int Index) throws Exception {
        try {
            if (Index < 0 || Index > this.iDimension) {
                return -1;
            }
            if (Index == 0) {
                return this.iLBound;
            }
            return ((VBArray)this.colObject[0]).getLBoundInternal(Index - 1);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int getUBound() throws Exception {
        return this.getUBound(1);
    }

    public int getUBound(int Index) throws Exception {
        return this.getUBoundInternal(this.iDimension + 1 - Index);
    }

    public int getUBoundInternal(int Index) throws Exception {
        try {
            if (Index < 0 || Index > this.iDimension) {
                return -1;
            }
            if (Index == 0) {
                return this.iUBound;
            }
            return ((VBArray)this.colObject[0]).getUBoundInternal(Index - 1);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int getBase() {
        return 0;
    }

    public void setBound(int iNewLBound, int iNewUBound, boolean bPreserve) throws Exception {
        this.writeBackArray();
        this.iLBound = iNewLBound;
        this.iUBound = iNewUBound;
        Object[] tmpArray = new Object[this.iUBound + -this.iLBound + 1];
        if (bPreserve && this.colObject != null) {
            int iLen = this.colObject.length;
            if (iLen > tmpArray.length) {
                iLen = tmpArray.length;
            }
            System.arraycopy(this.colObject, 0, tmpArray, 0, iLen);
        }
        this.colObject = tmpArray;
    }

    public VBArray getFromDimension(int Index) throws Exception {
        if (this.iDimension != 0) {
            return (VBArray)this.valueOf(Index);
        }
        return null;
    }

    public void addDimension(int iNewLBound, int iNewUBound, boolean bPreserve) throws Exception {
        this.writeBackArray();
        if (this.iDimension == 0) {
            for (int i = 0; i < this.colObject.length; ++i) {
                this.colObject[i] = new VBArray(this.myClass);
                ((VBArray)this.colObject[i]).setBound(iNewLBound, iNewUBound, bPreserve);
            }
        } else {
            for (int i = 0; i < this.colObject.length; ++i) {
                VBArray tmp = (VBArray)this.colObject[i];
                tmp.addDimension(iNewLBound, iNewUBound, bPreserve);
            }
        }
        ++this.iDimension;
    }

    private int calcOffset(int Index) {
        return Index - this.iLBound;
    }

    private int calcOffsetReverse(int Index) {
        return Index + this.iLBound;
    }

    public double valueOfDbl(int Index) throws Exception {
        return Conversion.CDbl(this.valueOf(Index));
    }

    public void setValueDbl(int Index, double Value) throws Exception {
        this.setValue(Index, new Double(Value));
    }

    public int valueOfInt(int Index) throws Exception {
        return Conversion.CInt(this.valueOf(Index));
    }

    public void setValueInt(int Index, int Value) throws Exception {
        this.setValue(Index, new Integer(Value));
    }

    public long valueOfLng(int Index) throws Exception {
        return Conversion.CLng(this.valueOf(Index));
    }

    public void setValueLng(int Index, long Value) throws Exception {
        this.setValue(Index, new Long(Value));
    }

    public Object valueOfObj(int Index) throws Exception {
        try {
            return this.valueOf(Index);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setValueObj(int Index, Object Value) throws Exception {
        this.setValue(Index, Value);
    }

    public String valueOfStr(int Index) throws Exception {
        return Conversion.CStr(this.valueOf(Index));
    }

    public VBVariant valueOfVar(int Index) throws Exception {
        try {
            if (this.valueOf(Index) instanceof VBVariant) {
                return (VBVariant)this.valueOf(Index);
            }
            return new VBVariant(this.valueOf(Index));
        }
        catch (Exception e) {
            this.setValueVar(Index, new VBVariant());
            try {
                return (VBVariant)this.valueOf(Index);
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    public void setValueVar(int Index, VBVariant Value) throws Exception {
        this.setValue(Index, Value);
    }

    public void setValueStr(int Index, String Value) throws Exception {
        this.setValue(Index, Value);
    }

    public void addStringItem(String NewItem) throws Exception {
        int iNewUBound = this.getUBound() + 1;
        this.setBound(this.getLBound(), iNewUBound, true);
        this.setValueStr(iNewUBound, NewItem);
    }

    public String toDebugString() {
        this.writeBackArray();
        try {
            int myIndexMax;
            if (this.iUBound - this.iLBound < 0) {
                return "Empty";
            }
            if (this.colObject == null) {
                return "Null";
            }
            String ret = "";
            String tmp = "";
            int myIndex = this.LastIndex - 3;
            if (myIndex < 0) {
                myIndex = 0;
            }
            if ((myIndexMax = myIndex + 7) > this.colObject.length) {
                myIndexMax = this.colObject.length;
            }
            for (int i = myIndex; i < myIndexMax; ++i) {
                if (this.colObject[i] != null) {
                    tmp = this.colObject[i].toString().replaceAll("\n", "\\n");
                    if (tmp.length() > 25) {
                        tmp = tmp.substring(0, 25);
                    }
                    ret = ret + "|VAR|(" + new Integer(this.calcOffsetReverse(i)).toString() + "): " + tmp + "\n";
                    continue;
                }
                ret = ret + "|VAR|(" + new Integer(this.calcOffsetReverse(i)).toString() + "): empty\n";
            }
            return ret;
        }
        catch (Exception e) {
            return "DBGERR: " + e.toString();
        }
    }

    public String toString() {
        String ret = "";
        try {
            ret = new String(this.byteArray(), "ISO-8859-1");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.clearWriteBackArray();
        return ret;
    }

    public VBArray(Class refClass) {
        try {
            this.myClass = refClass;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public VBArray(int refLBound, int refUBound, int refDimension) throws Exception {
        this.setBound(refLBound, refUBound, false);
        this.iDimension = refDimension;
    }

    public VBArray(String strVal) throws Exception {
        byte[] val = Strings.StringToArray(strVal);
        this.setBound(0, val.length - 1, false);
        for (int i = 0; i <= val.length - 1; ++i) {
            this.setValueInt(i, val[i]);
        }
    }

    public VBArray(String[] val) throws Exception {
        this.setBound(0, val.length - 1, false);
        System.arraycopy(val, 0, this.colObject, 0, val.length);
    }

    public VBArray(long[] val) throws Exception {
        this.setBound(0, val.length - 1, false);
        for (int i = 0; i <= val.length - 1; ++i) {
            this.setValueLng(i, val[i]);
        }
    }

    public VBArray(int[] val) throws Exception {
        this.setBound(0, val.length - 1, false);
        for (int i = 0; i <= val.length - 1; ++i) {
            this.setValueInt(i, val[i]);
        }
    }

    public VBArray(double[] val) throws Exception {
        this.setBound(0, val.length - 1, false);
        for (int i = 0; i <= val.length - 1; ++i) {
            this.setValueDbl(i, val[i]);
        }
    }

    public VBArray(float[] val) throws Exception {
        this.setBound(0, val.length - 1, false);
        for (int i = 0; i <= val.length - 1; ++i) {
            this.setValueDbl(i, val[i]);
        }
    }

    public VBArray(byte[] val) throws Exception {
        this.setBound(0, val.length - 1, false);
        for (int i = 0; i <= val.length - 1; ++i) {
            this.setValueInt(i, val[i]);
        }
    }

    public VBArray(Object[] val) throws Exception {
        this.setBound(0, val.length - 1, false);
        System.arraycopy(val, 0, this.colObject, 0, val.length);
    }

    public VBArray(boolean[] val) throws Exception {
        this.setBound(0, val.length - 1, false);
        for (int i = 0; i <= val.length - 1; ++i) {
            this.setValueInt(i, !val[i] ? 0 : -1);
        }
    }

    public VBArray(Date[] val) throws Exception {
        this.setBound(0, val.length - 1, false);
        System.arraycopy(val, 0, this.colObject, 0, val.length);
    }

    public VBArray(VBVariant[] val) throws Exception {
        this.setBound(0, val.length - 1, false);
        System.arraycopy(val, 0, this.colObject, 0, val.length);
    }

    public static VBArrayVariant createParamArray(int LBound, int UBound) throws Exception {
        VBArray ret = new VBArray();
        if (UBound > -1) {
            ret.setBound(LBound, UBound, false);
        }
        return ret;
    }

    public static VBArrayVariant createParamArray(int UBound) throws Exception {
        VBArray ret = new VBArray();
        if (UBound > -1) {
            ret.setBound(0, UBound, false);
        }
        return ret;
    }

    public static VBArray createVBArray(Class val) throws Exception {
        return new VBArray(val);
    }

    public static VBArrayByte createVBArray(String strVal) throws Exception {
        return new VBArray(Strings.StringToArray(strVal));
    }

    public static VBArray createVBArray(Object[] objVal) throws Exception {
        return new VBArray(objVal);
    }

    public static VBArrayString createVBArray(String[] strVal) throws Exception {
        return new VBArray(strVal);
    }

    public static VBArrayInteger createVBArray(int[] val) throws Exception {
        return new VBArray(val);
    }

    public static VBArrayBoolean createVBArray(boolean[] val) throws Exception {
        return new VBArray(val);
    }

    public static VBArraySingle createVBArray(float[] val) throws Exception {
        return new VBArray(val);
    }

    public static VBArrayLong createVBArray(long[] val) throws Exception {
        return new VBArray(val);
    }

    public static VBArrayDouble createVBArray(double[] val) throws Exception {
        return new VBArray(val);
    }

    public static VBArrayByte createVBArray(byte[] val) throws Exception {
        return new VBArray(val);
    }

    public static VBArrayDate createVBArray(Date[] val) throws Exception {
        return new VBArray(val);
    }

    public static VBArrayVariant createVBArray(VBVariant[] val) throws Exception {
        return new VBArray(val);
    }
}

