/*
 * Decompiled with CFR 0.152.
 */
package VBA;

import java.util.GregorianCalendar;
import java.util.TimeZone;

class VBDateParserState {
    static final int YEAR_BEFORE_MONTH = 4;
    static final int YEAR_BEFORE_DAY = 2;
    static final int MONTH_BEFORE_DAY = 1;
    static final int YEAR_AFTER_MONTH = 0;
    static final int YEAR_AFTER_DAY = 0;
    static final int MONTH_AFTER_DAY = 0;
    static final int UNSET = Integer.MIN_VALUE;
    private boolean yearBeforeMonth;
    private boolean yearBeforeDay;
    private boolean monthBeforeDay;
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private int second;
    private int milli;
    private boolean timePostMeridian;
    private TimeZone timeZone;

    VBDateParserState(int order) {
        this.yearBeforeMonth = (order & 4) == 4;
        this.yearBeforeDay = (order & 2) == 2;
        this.monthBeforeDay = (order & 1) == 1;
        this.year = Integer.MIN_VALUE;
        this.month = Integer.MIN_VALUE;
        this.day = Integer.MIN_VALUE;
        this.hour = Integer.MIN_VALUE;
        this.minute = Integer.MIN_VALUE;
        this.second = Integer.MIN_VALUE;
        this.timePostMeridian = false;
    }

    int getDate() {
        return this.day;
    }

    int getHour() {
        return this.hour;
    }

    int getMillisecond() {
        return this.milli;
    }

    int getMinute() {
        return this.minute;
    }

    int getMonth() {
        return this.month;
    }

    int getSecond() {
        return this.second;
    }

    TimeZone getTimeZone() {
        return this.timeZone;
    }

    int getYear() {
        return this.year;
    }

    boolean isDateSet() {
        return this.day != Integer.MIN_VALUE;
    }

    boolean isHourSet() {
        return this.hour != Integer.MIN_VALUE;
    }

    boolean isMillisecondSet() {
        return this.milli != Integer.MIN_VALUE;
    }

    boolean isMinuteSet() {
        return this.minute != Integer.MIN_VALUE;
    }

    boolean isMonthBeforeDay() {
        return this.monthBeforeDay;
    }

    boolean isMonthSet() {
        return this.month != Integer.MIN_VALUE;
    }

    boolean isSecondSet() {
        return this.second != Integer.MIN_VALUE;
    }

    boolean isTimePostMeridian() {
        return this.timePostMeridian || this.hour > 12;
    }

    boolean isYearBeforeDay() {
        return this.yearBeforeDay;
    }

    boolean isYearBeforeMonth() {
        return this.yearBeforeMonth;
    }

    boolean isYearSet() {
        return this.year != Integer.MIN_VALUE;
    }

    void setCalendar(GregorianCalendar cal, boolean ignoreChanges) throws Exception {
        cal.clear();
        if (this.year != Integer.MIN_VALUE && this.month != Integer.MIN_VALUE && this.day != Integer.MIN_VALUE) {
            cal.set(1, this.year);
            cal.set(2, this.month - 1);
            cal.set(5, this.day);
            if (!ignoreChanges) {
                int calYear = cal.get(1);
                int calMonth = cal.get(2);
                int calDay = cal.get(5);
                if (calYear != this.year || calMonth + 1 != this.month || calDay != this.day) {
                    throw new Exception("Date was set to " + calYear + "/" + (calMonth + 1) + "/" + calDay + " not requested " + this.year + "/" + this.month + "/" + this.day);
                }
            }
        }
        cal.clear(10);
        cal.clear(12);
        cal.clear(13);
        cal.clear(14);
        if (this.hour != Integer.MIN_VALUE && this.minute != Integer.MIN_VALUE) {
            cal.set(10, this.hour);
            cal.set(12, this.minute);
            if (this.second != Integer.MIN_VALUE) {
                cal.set(13, this.second);
                if (this.milli != Integer.MIN_VALUE) {
                    cal.set(14, this.milli);
                }
            }
            if (this.timeZone != null) {
                cal.setTimeZone(this.timeZone);
            }
        }
    }

    void setDate(int val) throws Exception {
        if (val < 1 || val > 31) {
            throw new Exception("Bad day " + val);
        }
        this.day = val;
    }

    void setHour(int val) throws Exception {
        int tmpHour;
        if (this.timePostMeridian) {
            tmpHour = val + 12;
            this.timePostMeridian = false;
        } else {
            tmpHour = val;
        }
        if (tmpHour < 0 || tmpHour > 23) {
            throw new Exception("Bad hour " + val);
        }
        this.hour = tmpHour;
    }

    void setMillisecond(int val) throws Exception {
        if (val < 0 || val > 999) {
            throw new Exception("Bad millisecond " + val);
        }
        this.milli = val;
    }

    void setMinute(int val) throws Exception {
        if (val < 0 || val > 59) {
            throw new Exception("Bad minute " + val);
        }
        this.minute = val;
    }

    void setMonth(int val) throws Exception {
        if (val < 1 || val > 12) {
            throw new Exception("Bad month " + val);
        }
        this.month = val;
    }

    void setSecond(int val) throws Exception {
        if (val < 0 || val > 59) {
            throw new Exception("Bad second " + val);
        }
        this.second = val;
    }

    void setTimePostMeridian(boolean val) {
        this.timePostMeridian = val;
    }

    void setTimeZone(TimeZone tz) {
        this.timeZone = tz;
    }

    void setYear(int val) throws Exception {
        if (val < 0) {
            throw new Exception("Bad year " + val);
        }
        this.year = val;
    }
}

