/*
 * Decompiled with CFR 0.152.
 */
package com.eaio.nativecall;

import com.eaio.nativecall.Holder;
import com.eaio.nativecall.Verifier;
import com.eaio.nativecall.Verifiers;
import com.eaio.util.lang.NativeLoader;
import java.io.IOException;
import sun.misc.ServiceConfigurationError;

public abstract class NativeCall {
    private static boolean initialized = false;
    private int lastErrorCode;
    private int functionHandle;
    private int moduleHandle;
    private String function;
    private String module;

    private static final native void initIDs();

    public static synchronized void init() throws IOException, SecurityException, UnsatisfiedLinkError, ServiceConfigurationError, UnsupportedOperationException {
        if (!initialized) {
            Verifiers.init();
            if (Verifiers.getInstance() == null) {
                throw new UnsupportedOperationException();
            }
            new NativeLoader("NativeCall").load();
            NativeCall.initIDs();
            initialized = true;
        }
    }

    private final native boolean initHandles();

    public final int getLastErrorCode() {
        return this.lastErrorCode;
    }

    public final native String getLastError();

    public synchronized native void destroy();

    protected void check(Object[] params) throws ClassCastException {
        if (params == null) {
            return;
        }
        int i = 0;
        while (i < params.length) {
            this.checkParam(params[i]);
            if (params[i] instanceof String) {
                params[i] = Verifiers.getInstance().handleString((String)params[i], this.module, this.function);
            }
            ++i;
        }
    }

    protected void checkParam(Object o) throws ClassCastException {
        if (o == null || o instanceof Boolean || o instanceof Integer || o instanceof byte[] || o instanceof char[] || o instanceof String) {
            return;
        }
        if (o instanceof Holder) {
            this.checkParam(((Holder)o).get());
            return;
        }
        throw new ClassCastException(o.getClass().getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NativeCall)) {
            return false;
        }
        if (!this.getClass().getName().equals(obj.getClass().getName())) {
            return false;
        }
        NativeCall c = (NativeCall)obj;
        boolean bl = false;
        if (this.module.equals(c.module) && this.function.equals(c.function)) {
            bl = true;
        }
        return bl;
    }

    public int hashCode() {
        int out = this.function.hashCode();
        return out ^= this.module.hashCode();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void finalize() throws Throwable {
        try {
            this.destroy();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        {
            Object var2_3 = null;
        }
        super.finalize();
    }

    public final String toString() {
        return this.toStringBuffer(null).toString();
    }

    public StringBuffer toStringBuffer(StringBuffer in) {
        if (in == null) {
            in = new StringBuffer(64);
        } else {
            in.ensureCapacity(in.length() + 64);
        }
        in.append("{ ");
        int idx = this.getClass().getName().lastIndexOf(".");
        if (idx > -1) {
            in.append(this.getClass().getName().substring(++idx));
        } else {
            in.append(this.getClass().getName());
        }
        in.append(": module = ");
        in.append(this.module);
        in.append(", function = ");
        in.append(this.function);
        in.append(" }");
        return in;
    }

    public NativeCall(String function) throws IllegalArgumentException, NullPointerException {
        this(Verifiers.getInstance().getDefaultModule(), function);
    }

    public NativeCall(String module, String function) throws IllegalArgumentException, NullPointerException {
        Verifier v = Verifiers.getInstance();
        this.function = v.verifyFunctionName(function);
        this.module = v.verifyModuleName(module);
        if (!this.initHandles()) {
            if (this.lastErrorCode != 0) {
                throw new IllegalArgumentException(this.getLastError());
            }
            throw new IllegalArgumentException();
        }
    }
}

