/*
 * Decompiled with CFR 0.152.
 */
package filedropper;

import filedropper.AboutFileDropperUploader;
import filedropper.FileDropperUploadThread;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URI;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import neembuuuploader.RecentlyUploaded;
import neembuuuploader.Uploader;

public class FileDropperUploader
extends JFrame
implements Uploader {
    File file;
    private FileDropperUploadThread fileDropperUploadThread;
    public JLabel progressMessage;
    public JTextField uploadURL;
    private JButton cancelButton;
    private JTextField inputFileTextField;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JLabel logo;
    private JButton openDownloadPageButton;
    private JLabel progressMessageLabel;
    private JButton selectFileButton;
    private JButton startButton;
    private JLabel uploadURLLabel;
    private JTextField uploadURLTextField;

    public FileDropperUploader() throws Exception {
        this.initComponents();
        this.setLocationByPlatform(true);
        this.fileDropperUploadThread = new FileDropperUploadThread(this);
        this.uploadURL = this.uploadURLTextField;
        this.progressMessage = this.progressMessageLabel;
    }

    public FileDropperUploader(File file) throws Exception {
        this.initComponents();
        this.setLocationByPlatform(true);
        this.fileDropperUploadThread = new FileDropperUploadThread(this);
        this.file = this.fileDropperUploadThread.file = file;
        this.uploadURL = this.uploadURLTextField;
        this.progressMessage = this.progressMessageLabel;
    }

    public void upload() throws Exception {
        this.fileDropperUploadThread.start();
    }

    public void cancelUpload() throws Exception {
        this.fileDropperUploadThread.httppost.abort();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.logo = new JLabel();
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.inputFileTextField = new JTextField();
        this.selectFileButton = new JButton();
        this.cancelButton = new JButton();
        this.startButton = new JButton();
        this.jPanel3 = new JPanel();
        this.progressMessageLabel = new JLabel();
        this.uploadURLLabel = new JLabel();
        this.uploadURLTextField = new JTextField();
        this.openDownloadPageButton = new JButton();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("FileDropper Uploader");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/filedropper/resources/logo_new_1_2_2.png")));
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.logo.setIcon(new ImageIcon(this.getClass().getResource("/filedropper/resources/logo_new_1_2_2.png")));
        this.jLabel1.setFont(new Font("Arial", 3, 24));
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/filedropper/resources/rsz_1im.png")));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.logo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1, -2, 388, -2).addContainerGap(42, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.logo)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Select File to upload:"));
        this.inputFileTextField.setEditable(false);
        this.inputFileTextField.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FileDropperUploader.this.inputFileTextFieldMouseClicked(evt);
            }
        });
        this.selectFileButton.setText("Select File");
        this.selectFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileDropperUploader.this.selectFileButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel Upload");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileDropperUploader.this.cancelButtonActionPerformed(evt);
            }
        });
        this.startButton.setText("Start Upload");
        this.startButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileDropperUploader.this.startButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.inputFileTextField, -1, 372, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.selectFileButton)).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.startButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cancelButton))).addContainerGap()));
        jPanel2Layout.linkSize(0, this.cancelButton, this.startButton);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.inputFileTextField, -2, -1, -2).addComponent(this.selectFileButton)).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cancelButton).addComponent(this.startButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Progress:"));
        this.progressMessageLabel.setText("No uploading in progress..");
        this.progressMessageLabel.setToolTipText("Progress bar not implemented yet. So if you are uploading a really large file, minimize the window and do something else :P");
        this.uploadURLLabel.setText("Download URL: ");
        this.uploadURLTextField.setEditable(false);
        this.uploadURLTextField.setText("NA");
        this.openDownloadPageButton.setText("Open Download page");
        this.openDownloadPageButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileDropperUploader.this.openDownloadPageButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.progressMessageLabel).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.uploadURLLabel).addGap(18, 18, 18).addComponent(this.uploadURLTextField, -1, 369, Short.MAX_VALUE)).addComponent(this.openDownloadPageButton, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.progressMessageLabel).addGap(18, 18, 18).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.uploadURLLabel).addComponent(this.uploadURLTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.openDownloadPageButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButton1.setText("Exit");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileDropperUploader.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("About");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileDropperUploader.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton3.setText("Show Recently Uploaded Files");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileDropperUploader.this.jButton3ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addGap(10, 10, 10)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(188, Short.MAX_VALUE).addComponent(this.jButton3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton1).addContainerGap()));
        layout.linkSize(0, this.jButton1, this.jButton2);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2).addComponent(this.jButton3)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void selectFileButtonActionPerformed(ActionEvent evt) {
        JFileChooser f = new JFileChooser();
        f.showOpenDialog(this);
        if (f.getSelectedFile() == null) {
            return;
        }
        this.file = this.fileDropperUploadThread.file = f.getSelectedFile();
        this.inputFileTextField.setText(this.file + "");
    }

    private void startButtonActionPerformed(ActionEvent evt) {
        if (this.file == null) {
            JOptionPane.showMessageDialog(this, "Select file first");
            return;
        }
        try {
            this.upload();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.progressMessage.setText("Uploading in progress.. Please Wait...");
    }

    private void inputFileTextFieldMouseClicked(MouseEvent evt) {
        this.selectFileButtonActionPerformed(null);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        if (this.file == null) {
            JOptionPane.showMessageDialog(this, "Select file first", "Error", 0);
            this.getToolkit().beep();
            return;
        }
        try {
            this.cancelUpload();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void openDownloadPageButtonActionPerformed(ActionEvent evt) {
        if (this.uploadURLTextField.getText().equals("NA")) {
            JOptionPane.showMessageDialog(this, "Invalid URL", "Error", 0);
            this.getToolkit().beep();
            return;
        }
        if (!Desktop.isDesktopSupported()) {
            return;
        }
        try {
            Desktop.getDesktop().browse(new URI(this.uploadURLTextField.getText()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        RecentlyUploaded foo = new RecentlyUploaded();
        foo.setLocationRelativeTo(this);
        foo.setVisible(true);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        AboutFileDropperUploader foo = new AboutFileDropperUploader();
        foo.setLocationRelativeTo(this);
        foo.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException ex) {
            ex.printStackTrace();
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    new FileDropperUploader().setVisible(true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }
}

