/*
 * Decompiled with CFR 0.152.
 */
package mediafire;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import mediafire.MFProgressMonitorThread;
import mediafire.MFUploadThread;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

public class MediafireUploader {
    public static final String Letters = "2359abcdfghlmnqrtuvwxyz";
    public static final String QK_Lookup = "\"sharedtabsfileinfo1-qk\" value=\"";
    public static final String HOST_BASE_URL = "http://www.mediafire.com/";
    public static final String BASE_UPLOAD_URL = "http://upload.mediafire.com/";
    public static final String BASE_REFERENCE_PAGE_URL = "http://www.mediafire.com/";
    public static final String BASE_STATUS_VERIFICATION_URL = "http://www.mediafire.com/dynamic/verifystatus.php?identifier=";
    public static final int MEDIAFIRE_UPLOAD_SESSION_ID_LENGTH = 11;
    private String sessionID;
    protected String quickKey;
    private MFUploadThread mFUploadThread;
    private MFProgressMonitorThread mFProgressMonitorThread;
    protected DefaultHttpClient uploaderClient = new DefaultHttpClient();
    protected DefaultHttpClient browserClient = new DefaultHttpClient();
    protected File file;
    protected String currentUploadURL;

    public MediafireUploader(File f) throws Exception {
        this.file = f;
        if (!f.exists() || !f.isFile()) {
            throw new FileNotFoundException("Should be a file");
        }
        this.sessionID = MediafireUploader.makeNewRandomID();
        this.currentUploadURL = MediafireUploader.getNewUploadURL(this.sessionID);
        this.mFUploadThread = new MFUploadThread(this);
        this.mFProgressMonitorThread = new MFProgressMonitorThread(this);
    }

    public void startUploading() throws Exception {
        System.out.println("starting uploading");
        this.mFUploadThread.start();
    }

    public static String getNewUploadURL() {
        return MediafireUploader.getNewUploadURL(MediafireUploader.makeNewRandomID());
    }

    public static String getNewUploadURL(String ID) {
        return BASE_UPLOAD_URL + ID + "p0";
    }

    public static void main(String[] args) throws Exception {
        System.out.println("heeloo");
        MediafireUploader inst = new MediafireUploader(new File("D:\\twitter-guide.pdf"));
        inst.startUploading();
    }

    private static String makeNewRandomID() {
        char[] ret = new char[11];
        for (int j = 0; j < 11; ++j) {
            ret[j] = Letters.charAt((int)(Math.random() * (double)Letters.length()));
        }
        return new String(ret);
    }

    public String getLinkProviderPageURL() {
        return "http://www.mediafire.com/upload_complete.php?id=" + this.sessionID;
    }

    public String getStatusVerificationURL() {
        return BASE_STATUS_VERIFICATION_URL + this.sessionID;
    }

    protected void setQuickKey(String quickKey) {
        this.quickKey = quickKey;
    }

    protected void startUpdating() {
        this.mFProgressMonitorThread.start();
    }

    public String getReferenceLink() {
        if (this.quickKey == null) {
            // empty if block
        }
        return "http://www.mediafire.com/?" + this.quickKey;
    }

    public String getQuickKey() {
        return this.quickKey;
    }

    public static void loadCookies(HttpClient client, String URLsource) throws IOException {
        System.out.println("loading " + URLsource);
        HttpGet httpGet = new HttpGet(URLsource);
        client.execute((HttpUriRequest)httpGet);
        System.out.println("loddded cookies of " + URLsource);
    }

    public void startMonitoringProgress() {
        this.mFProgressMonitorThread.start();
    }

    private static void setHttpClientLoggingSettings() {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.showdatetime", "true");
        System.setProperty("org.apache.commons.logging.simplelog.log.httpclient.wire", "debug");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.commons.httpclient", "debug");
    }
}

