(*  GREATIS CLIPBOARD HISTORY                  *)
(*  Copyright (C) 2005-2008 Greatis Software   *)
(*  http://www.greatis.com/delphicb/cliphist/  *)
(*  http://www.greatis.com/bteam.html          *)
(*                                             *)
(*  GREATIS DELPHI TOYS                        *)
(*  http://www.greatis.com/delphicb/toys/      *)

unit CHMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ClipHist, StdCtrls, ExtCtrls, Clipbrd;

type
  TfrmClipHistMain = class(TForm)
    cmpClipboardHistory: TClipboardHistory;
    lsbHistory: TListBox;
    splMain: TSplitter;
    memClip: TMemo;
    pnlControls: TPanel;
    lblCount: TLabel;
    pnlButtons: TPanel;
    btnClear: TButton;
    btnCopy: TButton;
    btnLoad: TButton;
    btnSave: TButton;
    opdHistory: TOpenDialog;
    svdHistory: TSaveDialog;
    procedure cmpClipboardHistoryChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure lsbHistoryClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnCopyClick(Sender: TObject);
    procedure btnClearClick(Sender: TObject);
    procedure btnLoadClick(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
  private
    { Private declarations }
    procedure SynchronizeList;
    procedure UpdateClip;
  public
    { Public declarations }
  end;

var
  frmClipHistMain: TfrmClipHistMain;

implementation

{$R *.DFM}

procedure TfrmClipHistMain.SynchronizeList;
begin
  with lsbHistory,Items do
  begin
    cmpClipboardHistory.HistoryShortToStrings(Items);
    if Count>0 then ItemIndex:=0;
  end;
  UpdateClip;
end;

procedure TfrmClipHistMain.UpdateClip;
begin
  with lsbHistory,cmpClipboardHistory do
  begin
    if ItemIndex=-1 then memClip.Text:=''
    else memClip.Text:=History[ItemIndex];
    lblCount.Caption:=IntToStr(HistoryCount)+' clip(s)';
  end;
end;

procedure TfrmClipHistMain.cmpClipboardHistoryChange(Sender: TObject);
begin
  SynchronizeList;
end;

procedure TfrmClipHistMain.FormShow(Sender: TObject);
begin
  with cmpClipboardHistory do
  begin
    try
      if FileExists('demo.his') then LoadFromFile('demo.his');
    except
    end;
    Active:=True;
    SynchronizeList;
  end;
end;

procedure TfrmClipHistMain.lsbHistoryClick(Sender: TObject);
begin
  UpdateClip;
end;

procedure TfrmClipHistMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  with cmpClipboardHistory do
  begin
    Active:=False;
    SaveToFile('demo.his');
  end;
end;

procedure TfrmClipHistMain.btnCopyClick(Sender: TObject);
begin
  Clipboard.AsText:=cmpClipboardHistory.History[lsbHistory.ItemIndex];
end;

procedure TfrmClipHistMain.btnClearClick(Sender: TObject);
begin
  cmpClipboardHistory.Clear;
  SynchronizeList;
end;

procedure TfrmClipHistMain.btnLoadClick(Sender: TObject);
begin
  with opdHistory do
    if Execute then
    begin
      cmpClipboardHistory.LoadFromFile(FileName);
      SynchronizeList;
    end;
end;

procedure TfrmClipHistMain.btnSaveClick(Sender: TObject);
begin
  with svdHistory do
    if Execute then
      cmpClipboardHistory.SaveToFile(FileName);
end;

end.
