(*  GREATIS DESKTOP SETTINGS                   *)
(*  Copyright (C) 2005-2008 Greatis Software   *)
(*  http://www.greatis.com/delphicb/desksets/  *)
(*  http://www.greatis.com/bteam.html          *)
(*                                             *)
(*  GREATIS DELPHI TOYS                        *)
(*  http://www.greatis.com/delphicb/toys/      *)

unit DSMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DeskSets, StdCtrls, ExtCtrls, ComCtrls;

type
  TfrmDeskSetsMain = class(TForm)
    cmpDesktopSettings: TDesktopSettings;
    grbSystemColors: TGroupBox;
    lsbSystemColors: TListBox;
    pnlCurrentColor: TPanel;
    btnChangeColor: TButton;
    lblCurrentColor: TLabel;
    lblDefaultColor: TLabel;
    pnlDefaultColor: TPanel;
    btnRestoreColors: TButton;
    cldChangeColor: TColorDialog;
    grbWallpaper: TGroupBox;
    rgrWallpaperStyle: TRadioGroup;
    grbWallpaperOffset: TGroupBox;
    lblWallpaperOffsetX: TLabel;
    edtWallpaperOffsetX: TEdit;
    udnWallpaperOffsetX: TUpDown;
    lblWallpaperOffsetY: TLabel;
    edtWallpaperOffsetY: TEdit;
    udnWallpaperOffsetY: TUpDown;
    lblWallpaperFile: TLabel;
    edtWallpaperFile: TEdit;
    btnWallpaperFile: TButton;
    grbScreenSaver: TGroupBox;
    lblScreenSaverFile: TLabel;
    edtScreenSaverFile: TEdit;
    btnScreenSaverFile: TButton;
    btnScreenSaverRun: TButton;
    opdWallpaperFile: TOpenDialog;
    opdScreenSaverFile: TOpenDialog;
    btnWallpaperFileClear: TButton;
    btnScreenSaverFileClear: TButton;
    procedure FormCreate(Sender: TObject);
    procedure lsbSystemColorsClick(Sender: TObject);
    procedure btnChangeColorClick(Sender: TObject);
    procedure btnRestoreColorsClick(Sender: TObject);
    procedure rgrWallpaperStyleClick(Sender: TObject);
    procedure edtWallpaperOffsetKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure btnWallpaperFileClick(Sender: TObject);
    procedure btnScreenSaverFileClick(Sender: TObject);
    procedure btnScreenSaverRunClick(Sender: TObject);
    procedure btnWallpaperFileClearClick(Sender: TObject);
    procedure btnScreenSaverFileClearClick(Sender: TObject);
    procedure udnWallpaperOffsetXChanging(Sender: TObject;
      var AllowChange: Boolean);
    procedure udnWallpaperOffsetYChanging(Sender: TObject;
      var AllowChange: Boolean);
  private
    { Private declarations }
    procedure UpdateColors;
  public
    { Public declarations }
  end;

var
  frmDeskSetsMain: TfrmDeskSetsMain;

implementation

{$R *.DFM}

procedure TfrmDeskSetsMain.UpdateColors;
begin
  with lsbSystemColors do
  begin
    pnlDefaultColor.Color:=cmpDesktopSettings.DefaultColors[Integer(Items.Objects[ItemIndex])];
    pnlCurrentColor.Color:=cmpDesktopSettings.SystemColors[Integer(Items.Objects[ItemIndex])];
  end;
end;

procedure TfrmDeskSetsMain.FormCreate(Sender: TObject);
var
  i: Integer;
  S: string;
begin
  with lsbSystemColors,Items do
  begin
    for i:=SysColor to SysColor+$100 do
      if ColorToIdent(i,S) then AddObject(Copy(S,3,Length(S)-2),TObject(i));
    ItemIndex:=0;
  end;
  with cmpDesktopSettings do
  begin
    rgrWallpaperStyle.ItemIndex:=Integer(WallpaperStyle);
    udnWallpaperOffsetX.Position:=WallpaperOffsetX;
    udnWallpaperOffsetY.Position:=WallpaperOffsetY;
    edtWallpaperFile.Text:=WallpaperFile;
    edtScreenSaverFile.Text:=ScreenSaverFile;
  end;
end;

procedure TfrmDeskSetsMain.lsbSystemColorsClick(Sender: TObject);
begin
  UpdateColors;
end;

procedure TfrmDeskSetsMain.btnChangeColorClick(Sender: TObject);
begin
  with cldChangeColor do
  begin
    Color:=pnlCurrentColor.Color;
    if Execute then
    begin
      cmpDesktopSettings.SystemColors[lsbSystemColors.ItemIndex]:=Color;
      UpdateColors;
    end;
  end;
end;

procedure TfrmDeskSetsMain.btnRestoreColorsClick(Sender: TObject);
begin
  cmpDesktopSettings.RestoreDefaultColors;
  UpdateColors;
end;

procedure TfrmDeskSetsMain.rgrWallpaperStyleClick(Sender: TObject);
begin
  cmpDesktopSettings.WallpaperStyle:=TWallpaperStyle(rgrWallpaperStyle.ItemIndex);
end;

procedure TfrmDeskSetsMain.edtWallpaperOffsetKeyDown(Sender: TObject;
  var Key: Word; Shift: TShiftState);
var
  UDN: TUpDown;
begin
  if (Sender as TControl).Tag=1 then UDN:=udnWallpaperOffsetX
  else UDN:=udnWallpaperOffsetY;
  with UDN do
    case Key of
      VK_NEXT: Position:=Position-10;
      VK_PRIOR: Position:=Position+10;
    end;
end;

procedure TfrmDeskSetsMain.btnWallpaperFileClick(Sender: TObject);
begin
  with edtWallpaperFile,opdWallpaperFile do
  begin
    FileName:=Text;
    if Execute then
    begin
      Text:=FileName;
      cmpDesktopSettings.WallpaperFile:=FileName;
    end;
  end;
end;

procedure TfrmDeskSetsMain.btnScreenSaverFileClick(Sender: TObject);
begin
  with edtScreenSaverFile,opdScreenSaverFile do
  begin
    FileName:=Text;
    if Execute then
    begin
      Text:=FileName;
      cmpDesktopSettings.ScreenSaverFile:=FileName;
    end;
  end;
end;

procedure TfrmDeskSetsMain.btnScreenSaverRunClick(Sender: TObject);
begin
  cmpDesktopSettings.RunScreenSaver;
end;

procedure TfrmDeskSetsMain.btnWallpaperFileClearClick(Sender: TObject);
begin
  cmpDesktopSettings.WallpaperFile:='';
  edtWallpaperFile.Text:='';
end;

procedure TfrmDeskSetsMain.btnScreenSaverFileClearClick(Sender: TObject);
begin
  cmpDesktopSettings.ScreenSaverFile:='';
  edtScreenSaverFile.Text:='';
end;

procedure TfrmDeskSetsMain.udnWallpaperOffsetXChanging(Sender: TObject;
  var AllowChange: Boolean);
begin
  cmpDesktopSettings.WallpaperOffsetX:=udnWallpaperOffsetX.Position;
end;

procedure TfrmDeskSetsMain.udnWallpaperOffsetYChanging(Sender: TObject;
  var AllowChange: Boolean);
begin
  cmpDesktopSettings.WallpaperOffsetY:=udnWallpaperOffsetY.Position;
end;

end.
