(*  GREATIS FILE SEARCH                       *)
(*  Copyright (C) 2005-2008 Greatis Software  *)
(*  http://www.greatis.com/delphicb/fsearch/  *)
(*  http://www.greatis.com/bteam.html         *)
(*                                            *)
(*  GREATIS DELPHI TOYS                       *)
(*  http://www.greatis.com/delphicb/toys/     *)

unit FSMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  FSearch, StdCtrls, ExtCtrls, ComCtrls, ShlObj, ImgList;

type
  TfrmFSearchMain = class(TForm)
    cmpFileSearch: TFileSearch;
    lsvResults: TListView;
    pnlControls: TPanel;
    btnAbort: TButton;
    imlResults: TImageList;
    lblSearchPath: TLabel;
    edtSearchPath: TEdit;
    btnSearchPath: TButton;
    lblFolderMask: TLabel;
    edtFolderMask: TEdit;
    lblFileMask: TLabel;
    edtFileMask: TEdit;
    grbOptions: TGroupBox;
    chbFiles: TCheckBox;
    chbFileAttributes: TCheckBox;
    chbFolders: TCheckBox;
    chbRecurseSubfolders: TCheckBox;
    grbFileAttributes: TGroupBox;
    chbFileReadOnly: TCheckBox;
    chbFileHidden: TCheckBox;
    chbFileSystem: TCheckBox;
    chbFileVolumeID: TCheckBox;
    chbFileArchive: TCheckBox;
    chbFileCompressed: TCheckBox;
    chbFileOffline: TCheckBox;
    chbFileTemporary: TCheckBox;
    grbResults: TGroupBox;
    lblFoldersCaption: TLabel;
    lblFilesCaption: TLabel;
    lblFolders: TLabel;
    lblFiles: TLabel;
    btnSearch: TButton;
    chbFolderAttributes: TCheckBox;
    grbFolderAttributes: TGroupBox;
    chbFolderArchive: TCheckBox;
    chbFolderReadOnly: TCheckBox;
    chbFolderHidden: TCheckBox;
    chbFolderSystem: TCheckBox;
    chbFolderVolumeID: TCheckBox;
    chbFolderCompressed: TCheckBox;
    chbFolderOffline: TCheckBox;
    chbFolderTemporary: TCheckBox;
    procedure cmpFileSearchFound(Sender: TObject; FileInfo: TFileInfo;
      var Abort: Boolean);
    procedure SearchClick(Sender: TObject);
    procedure btnAbortClick(Sender: TObject);
    procedure cmpFileSearchFinished(Sender: TObject);
    procedure cmpFileSearchStarted(Sender: TObject);
    procedure btnSearchPathClick(Sender: TObject);
    procedure chbFoldersClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmFSearchMain: TfrmFSearchMain;

implementation

{$R *.DFM}

procedure TfrmFSearchMain.cmpFileSearchFound(Sender: TObject; FileInfo: TFileInfo;
  var Abort: Boolean);
begin
  with FileInfo,lsvResults.Items.Add do
  begin
    if Directory then ImageIndex:=0
    else ImageIndex:=1;
    Caption:=Path+Name;
    Subitems.Text:=
      DateTimeToStr(CreationTime)+#13+
      DateTimeToStr(LastAccessTime)+#13+
      DateTimeToStr(LastWriteTime)+#13+
      IntToStr(FileSize)+#13+
      AttributesText;
  end;
  with Sender as TFileSearch do
  begin
    lblFolders.Caption:=IntToStr(FolderCount);
    lblFiles.Caption:=IntToStr(FileCount);
  end;
  Application.ProcessMessages;
end;

procedure TfrmFSearchMain.SearchClick(Sender: TObject);
begin
  with lsvResults.Items do
  try
    BeginUpdate;
    Clear;
    with cmpFileSearch do
    begin
      SearchPath:=edtSearchPath.Text;
      FolderMask:=edtFolderMask.Text;
      FileMask:=edtFileMask.Text;
      Options:=[];
      if chbFiles.Checked then Options:=Options+[soFiles];
      if chbFileAttributes.Checked then Options:=Options+[soFileAttributes];
      if chbFolders.Checked then Options:=Options+[soFolders];
      if chbFolderAttributes.Checked then Options:=Options+[soFolderAttributes];
      if chbRecurseSubfolders.Checked then Options:=Options+[soRecurseSubfolders];
      FileAttributes:=[];
      if chbFileArchive.Checked then FileAttributes:=FileAttributes+[atArchive];
      if chbFileReadOnly.Checked then FileAttributes:=FileAttributes+[atReadOnly];
      if chbFileHidden.Checked then FileAttributes:=FileAttributes+[atHidden];
      if chbFileSystem.Checked then FileAttributes:=FileAttributes+[atSystem];
      if chbFileVolumeID.Checked then FileAttributes:=FileAttributes+[atVolumeID];
      if chbFileCompressed.Checked then FileAttributes:=FileAttributes+[atCompressed];
      if chbFileOffline.Checked then FileAttributes:=FileAttributes+[atOffline];
      if chbFileTemporary.Checked then FileAttributes:=FileAttributes+[atTemporary];
      FolderAttributes:=[];
      if chbFolderArchive.Checked then FolderAttributes:=FolderAttributes+[atArchive];
      if chbFolderReadOnly.Checked then FolderAttributes:=FolderAttributes+[atReadOnly];
      if chbFolderHidden.Checked then FolderAttributes:=FolderAttributes+[atHidden];
      if chbFolderSystem.Checked then FolderAttributes:=FolderAttributes+[atSystem];
      if chbFolderVolumeID.Checked then FolderAttributes:=FolderAttributes+[atVolumeID];
      if chbFolderCompressed.Checked then FolderAttributes:=FolderAttributes+[atCompressed];
      if chbFolderOffline.Checked then FolderAttributes:=FolderAttributes+[atOffline];
      if chbFolderTemporary.Checked then FolderAttributes:=FolderAttributes+[atTemporary];
      Search;
    end;
  finally
    EndUpdate;
  end;
end;

procedure TfrmFSearchMain.btnAbortClick(Sender: TObject);
begin
  cmpFileSearch.Abort;
end;

procedure TfrmFSearchMain.cmpFileSearchFinished(Sender: TObject);
begin
  with grbResults do
    if cmpFileSearch.Aborted then Caption:='Results (aborted)'
    else Caption:='Results (finished)';
end;

procedure TfrmFSearchMain.cmpFileSearchStarted(Sender: TObject);
begin
  grbResults.Caption:='Results (searching)';
  lblFolders.Caption:='0';
  lblFiles.Caption:='0';
end;

function BrowseProc(Handle: HWND; Msg: UINT; L,Data: LPARAM): Integer; stdcall;
begin
  Result:=0;
  if Msg=BFFM_INITIALIZED then
    SendMessage(Handle,BFFM_SETSELECTION,1,Data);
end;

procedure TfrmFSearchMain.btnSearchPathClick(Sender: TObject);
var
  BI: TBrowseInfo;
  Result: PItemIDList;
  Temp: array[0..MAX_PATH] of Char;
begin
  FillChar(BI,SizeOf(BI),0);
  with BI do
  begin
    hwndOwner:=Handle;
    lpszTitle:='Specify search path';
    ulFlags:=BIF_RETURNONLYFSDIRS or BIF_RETURNFSANCESTORS;
    lpfn:=@BrowseProc;
    lParam:=Integer(PChar(edtSearchPath.Text));
    Result:=SHBrowseForFolder(BI);
    if Assigned(Result) then
    begin
      SHGetPathFromIDList(Result,Temp);
      edtSearchPath.Text:=Temp;
    end;
  end;
end;

procedure TfrmFSearchMain.chbFoldersClick(Sender: TObject);
begin
  chbRecurseSubfolders.Enabled:=chbFolders.Checked;
end;

end.
