(*  GREATIS FILE VERSION                      *)
(*  Copyright (C) 2005-2008 Greatis Software  *)
(*  http://www.greatis.com/delphicb/filever/  *)
(*  http://www.greatis.com/bteam.html         *)
(*                                            *)
(*  GREATIS DELPHI TOYS                       *)
(*  http://www.greatis.com/delphicb/toys/     *)

unit FVMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, FileVer;

type
  TfrmFileVerMain = class(TForm)
    lblFileName: TLabel;
    edtFileName: TEdit;
    btnFileName: TButton;
    memFileVersion: TMemo;
    lblFileVersion: TLabel;
    cmpFileVersion: TFileVersion;
    btnCopy: TButton;
    btnExit: TButton;
    opdFileName: TOpenDialog;
    procedure FormShow(Sender: TObject);
    procedure btnCopyClick(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure btnFileNameClick(Sender: TObject);
  private
    { Private declarations }
    procedure UpdateInfo;
  public
    { Public declarations }
  end;

var
  frmFileVerMain: TfrmFileVerMain;

implementation

{$R *.DFM}

procedure TfrmFileVerMain.UpdateInfo;
begin
  with memFileVersion.Lines,cmpFileVersion do
  begin
    FileName:=edtFileName.Text;
    Clear;
    Add('Original file name'#9+OriginalFileName);
    Add('File description'#9+FileDescription);
    Add('File version'#9+FileVersion);
    Add('Products name'#9+ProductName);
    Add('Products version'#9+ProductVersion);
    Add('Internal name'#9+InternalName);
    Add('Legal copyrights'#9+LegalCopyright);
    Add('Legal trademarks'#9+LegalTrademarks);
    Add('CompanyName'#9+CompanyName);
    Add('Comments'#9+Comments);
  end;
end;

procedure TfrmFileVerMain.FormShow(Sender: TObject);
begin
  edtFileName.Text:=Application.ExeName;
  UpdateInfo;
end;

procedure TfrmFileVerMain.btnCopyClick(Sender: TObject);
begin
  with memFileVersion do
  begin
    SelectAll;
    CopyToClipboard;
  end;
end;

procedure TfrmFileVerMain.btnExitClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmFileVerMain.btnFileNameClick(Sender: TObject);
begin
  with opdFileName do
  begin
    FileName:=edtFileName.Text;
    if Execute then
    begin
      edtFileName.Text:=FileName;
      cmpFileVersion.FileName:=FileName;
      UpdateInfo;
    end;
  end;
end;

end.
