(*  GREATIS FOLDER MONITOR                    *)
(*  Copyright (C) 2005-2008 Greatis Software  *)
(*  http://www.greatis.com/delphicb/fnotify/  *)
(*  http://www.greatis.com/bteam.html         *)
(*                                            *)
(*  GREATIS DELPHI TOYS                       *)
(*  http://www.greatis.com/delphicb/toys/     *)

unit FMMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ShlObj, FoldMon;

type
  TfrmFoldMonMain = class(TForm)
    memLog: TMemo;
    pnlControls: TPanel;
    edtFolder: TEdit;
    btnFolder: TButton;
    lblFolder: TLabel;
    chbActive: TCheckBox;
    cmpFolderMonitor: TFolderMonitor;
    chbRecurseSubfolders: TCheckBox;
    procedure btnFolderClick(Sender: TObject);
    procedure chbActiveClick(Sender: TObject);
    procedure cmpFolderMonitorChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmFoldMonMain: TfrmFoldMonMain;

implementation

{$R *.DFM}

function BrowseProc(Handle: HWND; Msg: UINT; L,Data: LPARAM): Integer; stdcall;
begin
  Result:=0;
  if Msg=BFFM_INITIALIZED then
    SendMessage(Handle,BFFM_SETSELECTION,1,Data);
end;

procedure TfrmFoldMonMain.btnFolderClick(Sender: TObject);
var
  BI: TBrowseInfo;
  Result: PItemIDList;
  Temp: array[0..MAX_PATH] of Char;
begin
  FillChar(BI,SizeOf(BI),0);
  with BI do
  begin
    hwndOwner:=Handle;
    lpszTitle:='Specify folder for monitoring';
    ulFlags:=BIF_RETURNONLYFSDIRS or BIF_RETURNFSANCESTORS;
    lpfn:=@BrowseProc;
    lParam:=Integer(PChar(edtFolder.Text));
    Result:=SHBrowseForFolder(BI);
    if Assigned(Result) then
    begin
      SHGetPathFromIDList(Result,Temp);
      edtFolder.Text:=Temp;
    end;
  end;
end;

procedure TfrmFoldMonMain.chbActiveClick(Sender: TObject);
begin
  with cmpFolderMonitor do
  begin
    Folder:=edtFolder.Text;
    RecurseSubfolders:=chbRecurseSubfolders.Checked;
    Active:=chbActive.Checked;
    lblFolder.Enabled:=not Active;
    edtFolder.Enabled:=not Active;
    btnFolder.Enabled:=not Active;
    chbRecurseSubfolders.Enabled:=not Active;
  end;
end;

procedure TfrmFoldMonMain.cmpFolderMonitorChange(Sender: TObject);
begin
  with Sender as TFolderMonitor do
    memLog.Lines.Add('Content of "'+Folder+'" was changed at '+DateTimeToStr(Now));
end;

end.
