(*  GREATIS FORM SAVER                         *)
(*  Copyright (C) 2005-2008 Greatis Software   *)
(*  http://www.greatis.com/delphicb/formsave/  *)
(*  http://www.greatis.com/bteam.html          *)
(*                                             *)
(*  GREATIS DELPHI TOYS                        *)
(*  http://www.greatis.com/delphicb/toys/      *)

unit FRMSMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  FormSave, StdCtrls, ExtCtrls;

const
  WM_LOADFORM = WM_USER+1;

type
  TfrmFormSaveMain = class(TForm)
    cmpFormSaver: TFormSaver;
    pnlControls: TPanel;
    btnSave: TButton;
    btnLoad: TButton;
    pnlData: TPanel;
    grbData: TGroupBox;
    lblEdit: TLabel;
    lblMemo: TLabel;
    edtEdit: TEdit;
    memMemo: TMemo;
    grbCheckBoxes: TGroupBox;
    chbFirst: TCheckBox;
    chbSecond: TCheckBox;
    chbThird: TCheckBox;
    rgrRadioGroup: TRadioGroup;
    opdDFM: TOpenDialog;
    svdDFM: TSaveDialog;
    lblData: TLabel;
    btnSaveData: TButton;
    btnLoadData: TButton;
    opdData: TOpenDialog;
    svdData: TSaveDialog;
    procedure btnSaveClick(Sender: TObject);
    procedure btnLoadClick(Sender: TObject);
    procedure btnSaveDataClick(Sender: TObject);
    procedure btnLoadDataClick(Sender: TObject);
    procedure cmpFormSaverReadError(Reader: TReader; const Message: String;
      var Handled: Boolean);
  private
    { Private declarations }
    procedure WMLoadForm(var Msg: TMessage); message WM_LOADFORM;
  public
    { Public declarations }
  end;

var
  frmFormSaveMain: TfrmFormSaveMain;

implementation

{$R *.DFM}

procedure TfrmFormSaveMain.WMLoadForm(var Msg: TMessage);
begin
  cmpFormSaver.LoadFromDFM(opdDFM.FileName);
end;

procedure TfrmFormSaveMain.btnSaveClick(Sender: TObject);
begin
  with svdDFM do
    if Execute then
      cmpFormSaver.SaveToDFM(FileName);
end;

procedure TfrmFormSaveMain.btnLoadClick(Sender: TObject);
begin
  // we cannot call the loading procedure directly
  // because the btnLoadClick will be destroyed before
  // the mouse button release processing and we'll have
  // Access Violation exception
  if opdDFM.Execute then
    PostMessage(Handle,WM_LOADFORM,0,0);
end;


procedure TfrmFormSaveMain.btnSaveDataClick(Sender: TObject);
begin
  with svdData do
    if Execute then
      cmpFormSaver.SaveComponentToFile(FileName,grbData);
end;

procedure TfrmFormSaveMain.btnLoadDataClick(Sender: TObject);
begin
  with opdData do
    if Execute then
      cmpFormSaver.LoadComponentFromFile(FileName,grbData);
end;

procedure TfrmFormSaveMain.cmpFormSaverReadError(Reader: TReader;
  const Message: String; var Handled: Boolean);
begin
  Handled:=True;
  ShowMessage(Message);
end;

end.
