(*  GREATIS HOT KEYS                          *)
(*  Copyright (C) 2005-2008 Greatis Software  *)
(*  http://www.greatis.com/delphicb/hotkeys/  *)
(*  http://www.greatis.com/bteam.html         *)
(*                                            *)
(*  GREATIS DELPHI TOYS                       *)
(*  http://www.greatis.com/delphicb/toys/     *)

unit HKMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  HotKeys, ComCtrls, StdCtrls, Menus;

type
  TfrmHotKeysMain = class(TForm)
    cmpHotKeys: THotKeys;
    lblHotKeys: TLabel;
    lsbHotKeys: TListBox;
    btnRegister: TButton;
    btnUnregister: TButton;
    btnPauseResume: TButton;
    procedure btnRegisterClick(Sender: TObject);
    procedure btnUnregisterClick(Sender: TObject);
    procedure btnPauseResumeClick(Sender: TObject);
    procedure cmpHotKeysChange(Sender: TObject);
    procedure cmpHotKeysHotKey(Sender: TObject; Key: Word;
      Shift: TShiftState);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
    procedure CheckCount;
  public
    { Public declarations }
  end;

var
  frmHotKeysMain: TfrmHotKeysMain;

implementation

uses HotKey;

{$R *.DFM}

procedure TfrmHotKeysMain.btnRegisterClick(Sender: TObject);
begin
  cmpHotKeys.Pause;
  try
    with lsbHotKeys,TfrmHotKey.Create(Application) do
    try
      if ShowModal=mrOK then
        if cmpHotKeys.RegisterShortCut(htkHotKey.HotKey) then ItemIndex:=Pred(Items.Count)
        else
          Application.MessageBox(
            PChar('The "'+ShortCutToText(htkHotKey.HotKey)+'" key cannot be registered.'),
            'Hot Keys Error',
            MB_OK or MB_ICONERROR);
    finally
      Free;
    end;
  finally
    cmpHotKeys.Resume;
    CheckCount;
  end;
end;

procedure TfrmHotKeysMain.btnUnregisterClick(Sender: TObject);
var
  OldIndex: Integer;
begin
  with cmpHotKeys,lsbHotKeys,Items do
  begin
    OldIndex:=ItemIndex;
    if UnregisterIndexKey(ItemIndex) then
    begin
      if OldIndex>Pred(Count) then OldIndex:=Pred(Count);
      ItemIndex:=OldIndex;
    end
    else
      Application.MessageBox(
        'The hot key cannot be unregistered.',
        'Hot Keys Error',
        MB_OK or MB_ICONERROR);
    CheckCount;
  end;
end;

procedure TfrmHotKeysMain.btnPauseResumeClick(Sender: TObject);
begin
  with cmpHotKeys,btnPauseResume do
  begin
    Active:=not Active;
    if Active then Caption:='Pause'
    else Caption:='Resume';
  end;
end;

procedure TfrmHotKeysMain.cmpHotKeysChange(Sender: TObject);
var
  i: Integer;
begin
  with cmpHotKeys,lsbHotKeys,Items do
  try
    BeginUpdate;
    Clear;
    for i:=0 to Pred(Keys.Count) do Add(Keys[i].Text);
    btnUnregister.Enabled:=Count>0;
  finally
    EndUpdate;
  end;
end;

procedure TfrmHotKeysMain.cmpHotKeysHotKey(Sender: TObject; Key: Word;
  Shift: TShiftState);
begin
  SetForegroundWindow(Handle);
  Application.MessageBox(
    PChar('The "'+ShortCutToText(ShortCut(Key,Shift))+'" hot key is pressed.'),
    'Hot Key',
    MB_OK or MB_ICONINFORMATION);
end;

procedure TfrmHotKeysMain.FormShow(Sender: TObject);
begin
  cmpHotKeys.Active:=True;
  with lsbHotKeys,Items do
    if Count>0 then ItemIndex:=0;
end;

procedure TfrmHotKeysMain.CheckCount;
begin
  with lsbHotKeys,Items do
    btnUnregister.Enabled:=ItemIndex<>-1;
end;

end.
