(*  GREATIS WINDOWS SHUTDOWN                   *)
(*  Copyright (C) 2005-2008 Greatis Software   *)
(*  http://www.greatis.com/delphicb/shutdown/  *)
(*  http://www.greatis.com/bteam.html          *)
(*                                             *)
(*  GREATIS DELPHI TOYS                        *)
(*  http://www.greatis.com/delphicb/toys/      *)

unit WSDMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Shutdown, StdCtrls;

type
  TfrmShutdownMain = class(TForm)
    cmpWindowsShutdown: TWindowsShutdown;
    chbForce: TCheckBox;
    btnTurnOffDialog: TButton;
    btnSleep: TButton;
    btnHibernate: TButton;
    btnLogOff: TButton;
    btnPowerOff: TButton;
    btnReboot: TButton;
    btnShutdown: TButton;
    procedure FormClick(Sender: TObject);
    procedure chbForceClick(Sender: TObject);
    procedure btnTurnOffDialogClick(Sender: TObject);
    procedure btnSleepClick(Sender: TObject);
    procedure btnHibernateClick(Sender: TObject);
    procedure btnLogOffClick(Sender: TObject);
    procedure btnPowerOffClick(Sender: TObject);
    procedure btnRebootClick(Sender: TObject);
    procedure btnShutdownClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmShutdownMain: TfrmShutdownMain;

implementation

{$R *.DFM}

procedure TfrmShutdownMain.FormClick(Sender: TObject);
begin
  cmpWindowsShutdown.Hibernate;
end;

procedure TfrmShutdownMain.chbForceClick(Sender: TObject);
begin
  with chbForce do
  begin
    if Checked then
      MessageBox(Handle,
        'Using the FORCE option can cause programs to lose data.',
        'Warning',MB_OK or MB_ICONWARNING);
    cmpWindowsShutdown.Force:=Checked;
  end;
end;

procedure TfrmShutdownMain.btnTurnOffDialogClick(Sender: TObject);
begin
  cmpWindowsShutdown.TurnOffDialog;
end;

procedure TfrmShutdownMain.btnSleepClick(Sender: TObject);
begin
  cmpWindowsShutdown.Sleep;
end;

procedure TfrmShutdownMain.btnHibernateClick(Sender: TObject);
begin
  cmpWindowsShutdown.Hibernate;
end;

procedure TfrmShutdownMain.btnLogOffClick(Sender: TObject);
begin
  cmpWindowsShutdown.LogOff;
end;

procedure TfrmShutdownMain.btnPowerOffClick(Sender: TObject);
begin
  cmpWindowsShutdown.PowerOff;
end;

procedure TfrmShutdownMain.btnRebootClick(Sender: TObject);
begin
  cmpWindowsShutdown.Reboot;
end;

procedure TfrmShutdownMain.btnShutdownClick(Sender: TObject);
begin
  cmpWindowsShutdown.Shutdown;
end;

end.
