// Borland C++ Builder
// Copyright (c) 1995, 2002 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'FSearch.pas' rev: 6.00

#ifndef FSearchHPP
#define FSearchHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <Classes.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Fsearch
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum FSearch__1 { atArchive, atReadOnly, atHidden, atSystem, atVolumeID, atCompressed, atOffline, atTemporary };
#pragma option pop

typedef Set<FSearch__1, atArchive, atTemporary>  TAttributes;

struct TFileInfo
{
	bool Directory;
	TAttributes Attributes;
	WideString AttributesText;
	System::TDateTime CreationTime;
	System::TDateTime LastAccessTime;
	System::TDateTime LastWriteTime;
	int FileSize;
	WideString Path;
	WideString Name;
	WideString ShortName;
} ;

#pragma option push -b-
enum TSearchOption { soFiles, soFileAttributes, soFolders, soFolderAttributes, soRecurseSubfolders };
#pragma option pop

typedef Set<TSearchOption, soFiles, soRecurseSubfolders>  TSearchOptions;

typedef void __fastcall (__closure *TFoundEvent)(System::TObject* Sender, const TFileInfo &FileInfo, bool &Abort);

typedef void __fastcall (__closure *TFolderSkipEvent)(System::TObject* Sender, const TFileInfo &FileInfo, bool &Skip);

class DELPHICLASS TCustomFileSearch;
class PASCALIMPLEMENTATION TCustomFileSearch : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	TAttributes FFileAttributes;
	TAttributes FFolderAttributes;
	WideString FSearchPath;
	WideString FFolderMask;
	WideString FFileMask;
	TSearchOptions FOptions;
	int FFolderCount;
	int FFileCount;
	bool FAborted;
	TFolderSkipEvent FOnFolderSkip;
	TFoundEvent FOnFound;
	Classes::TNotifyEvent FOnStarted;
	Classes::TNotifyEvent FOnFinished;
	void __fastcall SetSearchPath(const WideString Value);
	void __fastcall SetFileMask(const WideString Value);
	void __fastcall SetFolderMask(const WideString Value);
	bool __fastcall UpDir(WideString S);
	System::TDateTime __fastcall FileTimeToDateTime(const _FILETIME &FT);
	TAttributes __fastcall FlagsToFileAttributes(unsigned F);
	unsigned __fastcall FileAttributesToFlags(TAttributes A);
	bool __fastcall CompareAttributes(TAttributes A, unsigned F);
	AnsiString __fastcall AttributesToText(TAttributes A);
	void __fastcall FindDataToFileInfo(const _WIN32_FIND_DATAW &FindData, TFileInfo &FileInfo);
	
protected:
	virtual void __fastcall FolderSkip(WideString FilePath, const _WIN32_FIND_DATAW &FindData, bool &Skip);
	virtual void __fastcall Found(WideString FilePath, const _WIN32_FIND_DATAW &FindData, bool &Abort);
	virtual void __fastcall Started(void);
	virtual void __fastcall Finished(void);
	__property TAttributes FileAttributes = {read=FFileAttributes, write=FFileAttributes, default=0};
	__property TAttributes FolderAttributes = {read=FFolderAttributes, write=FFolderAttributes, default=0};
	__property WideString SearchPath = {read=FSearchPath, write=SetSearchPath};
	__property WideString FolderMask = {read=FFolderMask, write=SetFolderMask};
	__property WideString FileMask = {read=FFileMask, write=SetFileMask};
	__property TSearchOptions Options = {read=FOptions, write=FOptions, default=21};
	__property TFolderSkipEvent OnFolderSkip = {read=FOnFolderSkip, write=FOnFolderSkip};
	__property TFoundEvent OnFound = {read=FOnFound, write=FOnFound};
	__property Classes::TNotifyEvent OnStarted = {read=FOnStarted, write=FOnStarted};
	__property Classes::TNotifyEvent OnFinished = {read=FOnFinished, write=FOnFinished};
	
public:
	void __fastcall Search(void);
	void __fastcall Abort(void);
	__fastcall virtual TCustomFileSearch(Classes::TComponent* AOwner);
	__property bool Aborted = {read=FAborted, nodefault};
	__property int FolderCount = {read=FFolderCount, nodefault};
	__property int FileCount = {read=FFileCount, nodefault};
public:
	#pragma option push -w-inl
	/* TComponent.Destroy */ inline __fastcall virtual ~TCustomFileSearch(void) { }
	#pragma option pop
	
};


class DELPHICLASS TFileSearch;
class PASCALIMPLEMENTATION TFileSearch : public TCustomFileSearch 
{
	typedef TCustomFileSearch inherited;
	
__published:
	__property FileAttributes  = {default=0};
	__property FolderAttributes  = {default=0};
	__property SearchPath ;
	__property FileMask ;
	__property FolderMask ;
	__property Options  = {default=21};
	__property OnFolderSkip ;
	__property OnFound ;
	__property OnStarted ;
	__property OnFinished ;
public:
	#pragma option push -w-inl
	/* TCustomFileSearch.Create */ inline __fastcall virtual TFileSearch(Classes::TComponent* AOwner) : TCustomFileSearch(AOwner) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TComponent.Destroy */ inline __fastcall virtual ~TFileSearch(void) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------
extern PACKAGE void __fastcall Register(void);

}	/* namespace Fsearch */
using namespace Fsearch;
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// FSearch
