// Borland C++ Builder
// Copyright (c) 1995, 2002 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'HotKeys.pas' rev: 6.00

#ifndef HotKeysHPP
#define HotKeysHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <Menus.hpp>	// Pascal unit
#include <Dialogs.hpp>	// Pascal unit
#include <Forms.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Hotkeys
{
//-- type declarations -------------------------------------------------------
typedef void __fastcall (__closure *THotKeyEvent)(System::TObject* Sender, Word Key, Classes::TShiftState Shift);

class DELPHICLASS THotKeyHost;
class PASCALIMPLEMENTATION THotKeyHost : public Controls::TWinControl 
{
	typedef Controls::TWinControl inherited;
	
protected:
	MESSAGE void __fastcall WMHotKey(Messages::TMessage &Msg);
public:
	#pragma option push -w-inl
	/* TWinControl.Create */ inline __fastcall virtual THotKeyHost(Classes::TComponent* AOwner) : Controls::TWinControl(AOwner) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall THotKeyHost(HWND ParentWindow) : Controls::TWinControl(ParentWindow) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TWinControl.Destroy */ inline __fastcall virtual ~THotKeyHost(void) { }
	#pragma option pop
	
};


class DELPHICLASS TKeyData;
class PASCALIMPLEMENTATION TKeyData : public Classes::TCollectionItem 
{
	typedef Classes::TCollectionItem inherited;
	
private:
	int FID;
	Word FKey;
	Classes::TShiftState FShift;
	bool FActive;
	THotKeyEvent FOnHotKey;
	Classes::TShortCut __fastcall GetShortCut(void);
	void __fastcall SetShortCut(Classes::TShortCut AShortCut);
	AnsiString __fastcall GetText();
	void __fastcall SetActive(const bool Value);
	
public:
	__property int ID = {read=FID, nodefault};
	__property Word Key = {read=FKey, nodefault};
	__property Classes::TShiftState Shift = {read=FShift, nodefault};
	__property AnsiString Text = {read=GetText};
	
__published:
	__property Classes::TShortCut ShortCut = {read=GetShortCut, write=SetShortCut, nodefault};
	__property bool Active = {read=FActive, write=SetActive, nodefault};
	__property THotKeyEvent OnHotKey = {read=FOnHotKey, write=FOnHotKey};
public:
	#pragma option push -w-inl
	/* TCollectionItem.Create */ inline __fastcall virtual TKeyData(Classes::TCollection* Collection) : Classes::TCollectionItem(Collection) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TCollectionItem.Destroy */ inline __fastcall virtual ~TKeyData(void) { }
	#pragma option pop
	
};


class DELPHICLASS THotKeyCollection;
class DELPHICLASS TCustomHotKeys;
class PASCALIMPLEMENTATION TCustomHotKeys : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	THotKeyHost* FHost;
	HWND FHandle;
	int FIDCounter;
	bool FActive;
	THotKeyCollection* FKeys;
	THotKeyEvent FOnHotKey;
	Classes::TNotifyEvent FOnChange;
	int __fastcall AddKey(Word AKey, Classes::TShiftState AShift);
	int __fastcall KeyID(Word AKey, Classes::TShiftState AShift);
	int __fastcall KeyIndex(Word AKey, Classes::TShiftState AShift);
	void __fastcall DeleteKey(Word AKey, Classes::TShiftState AShift);
	unsigned __fastcall ShiftStateToModifier(Classes::TShiftState AShift);
	Classes::TShiftState __fastcall ModifierToShiftState(unsigned AModifier);
	void __fastcall SetActive(const bool Value);
	
protected:
	virtual void __fastcall Loaded(void);
	virtual void __fastcall HotKeyPressed(Word Key, Classes::TShiftState Shift);
	virtual void __fastcall Change(void);
	__property THotKeyEvent OnHotKey = {read=FOnHotKey, write=FOnHotKey};
	__property Classes::TNotifyEvent OnChange = {read=FOnChange, write=FOnChange};
	
public:
	__fastcall virtual TCustomHotKeys(Classes::TComponent* AOwner);
	__fastcall virtual ~TCustomHotKeys(void);
	bool __fastcall RegisterKey(Word Key, Classes::TShiftState Shift);
	bool __fastcall RegisterShortCut(Classes::TShortCut ShortCut);
	bool __fastcall UnregisterKey(Word Key, Classes::TShiftState Shift);
	bool __fastcall UnregisterShortCut(Classes::TShortCut ShortCut);
	bool __fastcall UnregisterIndexKey(int Index);
	void __fastcall UnregisterAllKeys(void);
	void __fastcall Pause(void);
	void __fastcall Resume(void);
	__property bool Active = {read=FActive, write=SetActive, default=0};
	__property THotKeyCollection* Keys = {read=FKeys, write=FKeys};
};


class PASCALIMPLEMENTATION THotKeyCollection : public Classes::TCollection 
{
	typedef Classes::TCollection inherited;
	
public:
	TKeyData* operator[](int Index) { return Items[Index]; }
	
private:
	TCustomHotKeys* FHotKeys;
	TKeyData* __fastcall GetKeyData(int Index);
	void __fastcall SetKeyData(int Index, TKeyData* Value);
	
protected:
	DYNAMIC Classes::TPersistent* __fastcall GetOwner(void);
	
public:
	__fastcall THotKeyCollection(TCustomHotKeys* AHotKeys);
	__property TKeyData* Items[int Index] = {read=GetKeyData, write=SetKeyData/*, default*/};
public:
	#pragma option push -w-inl
	/* TCollection.Destroy */ inline __fastcall virtual ~THotKeyCollection(void) { }
	#pragma option pop
	
};


class DELPHICLASS THotKeys;
class PASCALIMPLEMENTATION THotKeys : public TCustomHotKeys 
{
	typedef TCustomHotKeys inherited;
	
__published:
	__property Keys ;
	__property OnHotKey ;
	__property OnChange ;
public:
	#pragma option push -w-inl
	/* TCustomHotKeys.Create */ inline __fastcall virtual THotKeys(Classes::TComponent* AOwner) : TCustomHotKeys(AOwner) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TCustomHotKeys.Destroy */ inline __fastcall virtual ~THotKeys(void) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------
extern PACKAGE void __fastcall Register(void);

}	/* namespace Hotkeys */
using namespace Hotkeys;
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// HotKeys
