// Borland C++ Builder
// Copyright (c) 1995, 2002 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'SysMouse.pas' rev: 6.00

#ifndef SysMouseHPP
#define SysMouseHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <ComObj.hpp>	// Pascal unit
#include <ShlObj.hpp>	// Pascal unit
#include <ShellAPI.hpp>	// Pascal unit
#include <Forms.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Sysmouse
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum TSystemCursorIndex { scAppStarting, scNormal, scCross, scHand, scHelp, scIBeam, scNo, scSizeAll, scSizeNESW, scSizeNS, scSizeNWSE, scSizeWE, scWait };
#pragma option pop

#pragma option push -b-
enum TClipping { clipNone, clipByRect, clipByWindowBounds, clipByWindowClient, clipByFormBounds, clipByFormClient, clipByControlBounds, clipByControlClient };
#pragma option pop

#pragma option push -b-
enum TWindowPosition { wpCenter, wpLeftTop, wpRightTop, wpLeftBottom, wpRightBottom };
#pragma option pop

class DELPHICLASS TCustomSystemMouse;
class PASCALIMPLEMENTATION TCustomSystemMouse : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	TClipping FClipping;
	#pragma pack(push, 1)
	Types::TRect FClipRect;
	#pragma pack(pop)
	
	int FClipWindow;
	Controls::TControl* FClipControl;
	HICON DSystemCursors[13];
	HICON FSystemCursors[13];
	bool FRestoreDefaults;
	TWindowPosition FWindowPosition;
	void __fastcall ApplyClipping(void);
	Types::TPoint __fastcall WindowTarget(HWND W);
	Types::TPoint __fastcall ControlTarget(Controls::TControl* C);
	void __fastcall SetClipping(const TClipping Value);
	Types::TRect __fastcall GetSystemClipRect();
	void __fastcall SetClipRect(const Types::TRect &Value);
	void __fastcall SetClipWindow(const int Value);
	void __fastcall SetClipControl(const Controls::TControl* Value);
	bool __fastcall GetVisibleCursor(void);
	void __fastcall SetVisibleCursor(const bool Value);
	HICON __fastcall GetSystemCursor(TSystemCursorIndex Index);
	void __fastcall SetSystemCursor(TSystemCursorIndex Index, const HICON Value);
	HICON __fastcall GetDefaultCursor(TSystemCursorIndex Index);
	AnsiString __fastcall GetSystemCursorName(TSystemCursorIndex Index);
	Controls::TCursor __fastcall GetSystemVCLCursor(TSystemCursorIndex Index);
	void __fastcall SetSystemVCLCursor(TSystemCursorIndex Index, const Controls::TCursor Value);
	Types::TPoint __fastcall GetPosition();
	void __fastcall SetPosition(const Types::TPoint &Value);
	HWND __fastcall GetMouseWindow(void);
	void __fastcall SetMouseWindow(const HWND Value);
	Controls::TControl* __fastcall GetMouseControl(void);
	void __fastcall SetMouseControl(const Controls::TControl* Value);
	
public:
	__fastcall virtual TCustomSystemMouse(Classes::TComponent* AOwner);
	__fastcall virtual ~TCustomSystemMouse(void);
	void __fastcall RestoreSystemCursors(void);
	void __fastcall MoveTo(const Types::TPoint &P);
	void __fastcall MoveToWindow(HWND Handle);
	void __fastcall MoveToControl(Controls::TControl* Control);
	__property TClipping Clipping = {read=FClipping, write=SetClipping, nodefault};
	__property Types::TRect SystemClipRect = {read=GetSystemClipRect};
	__property Types::TRect ClipRect = {read=FClipRect, write=SetClipRect};
	__property int ClipWindow = {read=FClipWindow, write=SetClipWindow, nodefault};
	__property Controls::TControl* ClipControl = {read=FClipControl, write=SetClipControl};
	__property bool VisibleCursor = {read=GetVisibleCursor, write=SetVisibleCursor, nodefault};
	__property HICON SystemCursors[TSystemCursorIndex Index] = {read=GetSystemCursor, write=SetSystemCursor};
	__property HICON DefaultCursors[TSystemCursorIndex Index] = {read=GetDefaultCursor};
	__property AnsiString SystemCursorNames[TSystemCursorIndex Index] = {read=GetSystemCursorName};
	__property Controls::TCursor SystemVCLCursors[TSystemCursorIndex Index] = {read=GetSystemVCLCursor, write=SetSystemVCLCursor};
	__property bool RestoreDefaults = {read=FRestoreDefaults, write=FRestoreDefaults, default=1};
	__property Types::TPoint Position = {read=GetPosition, write=SetPosition};
	__property TWindowPosition WindowPosition = {read=FWindowPosition, write=FWindowPosition, nodefault};
	__property HWND MouseWindow = {read=GetMouseWindow, write=SetMouseWindow, nodefault};
	__property Controls::TControl* MouseControl = {read=GetMouseControl, write=SetMouseControl};
};


class DELPHICLASS TSystemMouse;
class PASCALIMPLEMENTATION TSystemMouse : public TCustomSystemMouse 
{
	typedef TCustomSystemMouse inherited;
	
__published:
	__property Clipping ;
	__property ClipWindow ;
	__property ClipControl ;
	__property WindowPosition ;
public:
	#pragma option push -w-inl
	/* TCustomSystemMouse.Create */ inline __fastcall virtual TSystemMouse(Classes::TComponent* AOwner) : TCustomSystemMouse(AOwner) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TCustomSystemMouse.Destroy */ inline __fastcall virtual ~TSystemMouse(void) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------
extern PACKAGE void __fastcall Register(void);

}	/* namespace Sysmouse */
using namespace Sysmouse;
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// SysMouse
