// Borland C++ Builder
// Copyright (c) 1995, 2002 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'WinEvent.pas' rev: 6.00

#ifndef WinEventHPP
#define WinEventHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <Dialogs.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Winevent
{
//-- type declarations -------------------------------------------------------
typedef void __fastcall (__closure *TWinEventHookEvent)(System::TObject* Sender, int Event, int Window, int ObjectID, int ChildID, unsigned ThreadID, unsigned EventTime, bool &Enable);

#pragma option push -b-
enum TSystemAlert { saUnknown, saInformation, saWarning, saError, saQuestion, saCritical, saSystem };
#pragma option pop

typedef void __fastcall (__closure *TSystemAlertEvent)(System::TObject* Sender, TSystemAlert Alert, int MBHandle, AnsiString BoxCaption, AnsiString MessageText, Dialogs::TMsgDlgButtons Buttons);

typedef void __fastcall (__closure *TWindowEvent)(System::TObject* Sender, int WindowHandle);

#pragma option push -b-
enum TMenuType { mtUnknown, mtSystem, mtWindow, mtContext };
#pragma option pop

typedef void __fastcall (__closure *TMenuEvent)(System::TObject* Sender, int WindowHandle, TMenuType MenuType);

typedef void __fastcall (__closure *TMenuPopupEvent)(System::TObject* Sender, int MenuHandle);

#pragma option push -b-
enum TScrollingType { stVertical, stHorizontal };
#pragma option pop

typedef void __fastcall (__closure *TScrollingEvent)(System::TObject* Sender, int WindowHandle, TScrollingType ScrollingType);

typedef void __fastcall (__closure *TObjectEvent)(System::TObject* Sender, int ObjectHandle, int ObjectID, int ChildID);

class DELPHICLASS TCustomWinEvent;
class PASCALIMPLEMENTATION TCustomWinEvent : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	unsigned FHID;
	bool FActive;
	unsigned FProcess;
	unsigned FThread;
	unsigned FEventMin;
	unsigned FEventMax;
	bool FSkipOwnProcess;
	bool FSkipOwnThread;
	TWinEventHookEvent FOnWinEvent;
	TSystemAlertEvent FOnSystemAlert;
	TWindowEvent FOnForegroundWindow;
	TMenuEvent FOnMenuStart;
	TMenuEvent FOnMenuEnd;
	TMenuPopupEvent FOnMenuPopupStart;
	TMenuPopupEvent FOnMenuPopupEnd;
	TWindowEvent FOnCaptureStart;
	TWindowEvent FOnCaptureEnd;
	TWindowEvent FOnMoveSizeStart;
	TWindowEvent FOnMoveSizeEnd;
	TWindowEvent FOnContextHelpStart;
	TWindowEvent FOnContextHelpEnd;
	TScrollingEvent FOnScrollingStart;
	TScrollingEvent FOnScrollingEnd;
	TWindowEvent FOnSwitchStart;
	TWindowEvent FOnSwitchEnd;
	TWindowEvent FOnMinimizeStart;
	TWindowEvent FOnMinimizeEnd;
	TObjectEvent FOnObjectCreate;
	TObjectEvent FOnObjectDestroy;
	TObjectEvent FOnObjectShow;
	TObjectEvent FOnObjectHide;
	TObjectEvent FOnObjectReorder;
	TObjectEvent FOnObjectFocus;
	TObjectEvent FOnObjectSelection;
	TObjectEvent FOnObjectSelectionAdd;
	TObjectEvent FOnObjectSelectionRemove;
	TObjectEvent FOnObjectSelectionWithin;
	TObjectEvent FOnObjectStateChange;
	TObjectEvent FOnObjectLocationChange;
	TObjectEvent FOnObjectNameChange;
	TObjectEvent FOnObjectValueChange;
	void __fastcall SetActive(const bool Value);
	void __fastcall SetProcess(const unsigned Value);
	void __fastcall SetThread(const unsigned Value);
	void __fastcall SetEventMin(const unsigned Value);
	void __fastcall SetEventMax(const unsigned Value);
	void __fastcall SetSkipOwnProcess(const bool Value);
	void __fastcall SetSkipOwnThread(const bool Value);
	
protected:
	virtual void __fastcall HookProc(unsigned Event, HWND Window, int ObjectID, int ChildID, unsigned ThreadID, unsigned EventTime);
	virtual void __fastcall SystemAlert(TSystemAlert Alert, HWND Window, unsigned EventTime);
	virtual void __fastcall ForegroundWindow(HWND Window, unsigned EventTime);
	virtual void __fastcall MenuStart(HWND Window, int MenuID, unsigned EventTime);
	virtual void __fastcall MenuEnd(HWND Window, int MenuID, unsigned EventTime);
	virtual void __fastcall MenuPopupStart(HMENU Menu, unsigned EventTime);
	virtual void __fastcall MenuPopupEnd(HMENU Menu, unsigned EventTime);
	virtual void __fastcall CaptureStart(HWND Window, unsigned EventTime);
	virtual void __fastcall CaptureEnd(HWND Window, unsigned EventTime);
	virtual void __fastcall MoveSizeStart(HWND Window, unsigned EventTime);
	virtual void __fastcall MoveSizeEnd(HWND Window, unsigned EventTime);
	virtual void __fastcall ContextHelpStart(HWND Window, unsigned EventTime);
	virtual void __fastcall ContextHelpEnd(HWND Window, unsigned EventTime);
	virtual void __fastcall ScrollingStart(HWND Window, int ScrollID, unsigned EventTime);
	virtual void __fastcall ScrollingEnd(HWND Window, int ScrollID, unsigned EventTime);
	virtual void __fastcall SwitchStart(HWND Window, unsigned EventTime);
	virtual void __fastcall SwitchEnd(HWND Window, unsigned EventTime);
	virtual void __fastcall MinimizeStart(HWND Window, unsigned EventTime);
	virtual void __fastcall MinimizeEnd(HWND Window, unsigned EventTime);
	virtual void __fastcall ObjectCreate(unsigned ObjectHandle, int ObjectID, int ChildID, unsigned EventTime);
	virtual void __fastcall ObjectDestroy(unsigned ObjectHandle, int ObjectID, int ChildID, unsigned EventTime);
	virtual void __fastcall ObjectShow(unsigned ObjectHandle, int ObjectID, int ChildID, unsigned EventTime);
	virtual void __fastcall ObjectHide(unsigned ObjectHandle, int ObjectID, int ChildID, unsigned EventTime);
	virtual void __fastcall ObjectReorder(unsigned ObjectHandle, int ObjectID, int ChildID, unsigned EventTime);
	virtual void __fastcall ObjectFocus(unsigned ObjectHandle, int ObjectID, int ChildID, unsigned EventTime);
	virtual void __fastcall ObjectSelection(unsigned ObjectHandle, int ObjectID, int ChildID, unsigned EventTime);
	virtual void __fastcall ObjectSelectionAdd(unsigned ObjectHandle, int ObjectID, int ChildID, unsigned EventTime);
	virtual void __fastcall ObjectSelectionRemove(unsigned ObjectHandle, int ObjectID, int ChildID, unsigned EventTime);
	virtual void __fastcall ObjectSelectionWithin(unsigned ObjectHandle, int ObjectID, int ChildID, unsigned EventTime);
	virtual void __fastcall ObjectStateChange(unsigned ObjectHandle, int ObjectID, int ChildID, unsigned EventTime);
	virtual void __fastcall ObjectLocationChange(unsigned ObjectHandle, int ObjectID, int ChildID, unsigned EventTime);
	virtual void __fastcall ObjectNameChange(unsigned ObjectHandle, int ObjectID, int ChildID, unsigned EventTime);
	virtual void __fastcall ObjectValueChange(unsigned ObjectHandle, int ObjectID, int ChildID, unsigned EventTime);
	__property bool Active = {read=FActive, write=SetActive, default=0};
	__property unsigned Process = {read=FProcess, write=SetProcess, nodefault};
	__property unsigned Thread = {read=FThread, write=SetThread, nodefault};
	__property unsigned EventMin = {read=FEventMin, write=SetEventMin, nodefault};
	__property unsigned EventMax = {read=FEventMax, write=SetEventMax, nodefault};
	__property bool SkipOwnProcess = {read=FSkipOwnProcess, write=SetSkipOwnProcess, nodefault};
	__property bool SkipOwnThread = {read=FSkipOwnThread, write=SetSkipOwnThread, nodefault};
	__property TWinEventHookEvent OnWinEvent = {read=FOnWinEvent, write=FOnWinEvent};
	__property TSystemAlertEvent OnSystemAlert = {read=FOnSystemAlert, write=FOnSystemAlert};
	__property TWindowEvent OnForegroundWindow = {read=FOnForegroundWindow, write=FOnForegroundWindow};
	__property TMenuEvent OnMenuStart = {read=FOnMenuStart, write=FOnMenuStart};
	__property TMenuEvent OnMenuEnd = {read=FOnMenuEnd, write=FOnMenuEnd};
	__property TMenuPopupEvent OnMenuPopupStart = {read=FOnMenuPopupStart, write=FOnMenuPopupStart};
	__property TMenuPopupEvent OnMenuPopupEnd = {read=FOnMenuPopupEnd, write=FOnMenuPopupEnd};
	__property TWindowEvent OnCaptureStart = {read=FOnCaptureStart, write=FOnCaptureStart};
	__property TWindowEvent OnCaptureEnd = {read=FOnCaptureEnd, write=FOnCaptureEnd};
	__property TWindowEvent OnMoveSizeStart = {read=FOnMoveSizeStart, write=FOnMoveSizeStart};
	__property TWindowEvent OnMoveSizeEnd = {read=FOnMoveSizeEnd, write=FOnMoveSizeEnd};
	__property TWindowEvent OnContextHelpStart = {read=FOnContextHelpStart, write=FOnContextHelpStart};
	__property TWindowEvent OnContextHelpEnd = {read=FOnContextHelpEnd, write=FOnContextHelpEnd};
	__property TScrollingEvent OnScrollingStart = {read=FOnScrollingStart, write=FOnScrollingStart};
	__property TScrollingEvent OnScrollingEnd = {read=FOnScrollingEnd, write=FOnScrollingEnd};
	__property TWindowEvent OnSwitchStart = {read=FOnSwitchStart, write=FOnSwitchStart};
	__property TWindowEvent OnSwitchEnd = {read=FOnSwitchEnd, write=FOnSwitchEnd};
	__property TWindowEvent OnMinimizeStart = {read=FOnMinimizeStart, write=FOnMinimizeStart};
	__property TWindowEvent OnMinimizeEnd = {read=FOnMinimizeEnd, write=FOnMinimizeEnd};
	__property TObjectEvent OnObjectCreate = {read=FOnObjectCreate, write=FOnObjectCreate};
	__property TObjectEvent OnObjectDestroy = {read=FOnObjectDestroy, write=FOnObjectDestroy};
	__property TObjectEvent OnObjectShow = {read=FOnObjectShow, write=FOnObjectShow};
	__property TObjectEvent OnObjectHide = {read=FOnObjectHide, write=FOnObjectHide};
	__property TObjectEvent OnObjectReorder = {read=FOnObjectReorder, write=FOnObjectReorder};
	__property TObjectEvent OnObjectFocus = {read=FOnObjectFocus, write=FOnObjectFocus};
	__property TObjectEvent OnObjectSelection = {read=FOnObjectSelection, write=FOnObjectSelection};
	__property TObjectEvent OnObjectSelectionAdd = {read=FOnObjectSelectionAdd, write=FOnObjectSelectionAdd};
	__property TObjectEvent OnObjectSelectionRemove = {read=FOnObjectSelectionRemove, write=FOnObjectSelectionRemove};
	__property TObjectEvent OnObjectSelectionWithin = {read=FOnObjectSelectionWithin, write=FOnObjectSelectionWithin};
	__property TObjectEvent OnObjectStateChange = {read=FOnObjectStateChange, write=FOnObjectStateChange};
	__property TObjectEvent OnObjectLocationChange = {read=FOnObjectLocationChange, write=FOnObjectLocationChange};
	__property TObjectEvent OnObjectNameChange = {read=FOnObjectNameChange, write=FOnObjectNameChange};
	__property TObjectEvent OnObjectValueChange = {read=FOnObjectValueChange, write=FOnObjectValueChange};
	
public:
	__fastcall virtual TCustomWinEvent(Classes::TComponent* AOwner);
	__fastcall virtual ~TCustomWinEvent(void);
};


class DELPHICLASS TWinEvent;
class PASCALIMPLEMENTATION TWinEvent : public TCustomWinEvent 
{
	typedef TCustomWinEvent inherited;
	
public:
	__property Process ;
	__property Thread ;
	__property EventMin ;
	__property EventMax ;
	
__published:
	__property Active  = {default=0};
	__property SkipOwnProcess ;
	__property SkipOwnThread ;
	__property OnWinEvent ;
	__property OnSystemAlert ;
	__property OnForegroundWindow ;
	__property OnMenuStart ;
	__property OnMenuEnd ;
	__property OnMenuPopupStart ;
	__property OnMenuPopupEnd ;
	__property OnCaptureStart ;
	__property OnCaptureEnd ;
	__property OnMoveSizeStart ;
	__property OnMoveSizeEnd ;
	__property OnContextHelpStart ;
	__property OnContextHelpEnd ;
	__property OnScrollingStart ;
	__property OnScrollingEnd ;
	__property OnSwitchStart ;
	__property OnSwitchEnd ;
	__property OnMinimizeStart ;
	__property OnMinimizeEnd ;
	__property OnObjectCreate ;
	__property OnObjectDestroy ;
	__property OnObjectShow ;
	__property OnObjectHide ;
	__property OnObjectReorder ;
	__property OnObjectFocus ;
	__property OnObjectSelection ;
	__property OnObjectSelectionAdd ;
	__property OnObjectSelectionRemove ;
	__property OnObjectSelectionWithin ;
	__property OnObjectStateChange ;
	__property OnObjectLocationChange ;
	__property OnObjectNameChange ;
	__property OnObjectValueChange ;
public:
	#pragma option push -w-inl
	/* TCustomWinEvent.Create */ inline __fastcall virtual TWinEvent(Classes::TComponent* AOwner) : TCustomWinEvent(AOwner) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TCustomWinEvent.Destroy */ inline __fastcall virtual ~TWinEvent(void) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------
extern PACKAGE void __fastcall Register(void);

}	/* namespace Winevent */
using namespace Winevent;
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// WinEvent
