using System;
using System.IO;
using Foxit.PDF.Rasterizer;

namespace IndexedImage_Example
{
    class Program
    {
        static void Main(string[] args)
        {
            string pdfPath = GetPDFPath();

            //Create a PdfRasterizer
            PdfRasterizer rasterizer = new PdfRasterizer(Path.Combine(pdfPath, "DocumentA.pdf"));

            // Create the GifImageFormat object.
            GifImageFormat gifImageFormat = new GifImageFormat();

            // Set the DitheringAlgorithm to FloydSteinberg.
            gifImageFormat.DitheringAlgorithm = DitheringAlgorithm.FloydSteinberg;

            // Set the DitheringPercent.
            gifImageFormat.DitheringPercent = 100;

            // Set the size.
            FixedImageSize fixedImageSize = new FixedImageSize(595, 841);

            // Save the image.
            rasterizer.Draw("IndexedImage.Gif", gifImageFormat, fixedImageSize);
        }
        static string GetPDFPath()
        {
            string pdfPath = AppDomain.CurrentDomain.BaseDirectory;
            if (pdfPath.EndsWith(new string(Path.DirectorySeparatorChar, 1)))
            {
                pdfPath = Path.GetDirectoryName(pdfPath);
            }
            while (Directory.Exists(pdfPath) && !Directory.Exists(Path.Combine(pdfPath, "PDFs")))
            {
                pdfPath = Path.GetDirectoryName(pdfPath);
            }
            if (pdfPath == null || !Directory.Exists(Path.Combine(pdfPath, "PDFs")))
            {
                throw new Exception("File path for pdf files could not be found.");
            }

            return pdfPath + "\\PDFs";
        }
    }
}
