using System;
using System.IO;
using Foxit.PDF.Rasterizer;

namespace MonochromeImage_Example
{
    class Program
    {
        static void Main(string[] args)
        {
            string pdfPath = GetPDFPath();

            // Create a PdfRasterizer object.
            PdfRasterizer rasterizer = new PdfRasterizer(Path.Combine(pdfPath, "DocumentA.pdf"));

            // Create a  BmpMonochromeColorFormat object.
            BmpMonochromeColorFormat bmpMonochromeColorFormat = new BmpMonochromeColorFormat(DitheringAlgorithm.FloydSteinberg, 100);

            // Create a  BmpImageFormat object with BmpMonochromeColorFormat.
            BmpImageFormat bmpImageFormat = new BmpImageFormat(bmpMonochromeColorFormat);

            // Set the size.
            FixedImageSize fixedImageSize = new FixedImageSize(595, 841);

            // Save the image.
            rasterizer.Draw("Monochrome.bmp", bmpImageFormat, fixedImageSize);
        }
        static string GetPDFPath()
        {
            string pdfPath = AppDomain.CurrentDomain.BaseDirectory;
            if (pdfPath.EndsWith(new string(Path.DirectorySeparatorChar, 1)))
            {
                pdfPath = Path.GetDirectoryName(pdfPath);
            }
            while (Directory.Exists(pdfPath) && !Directory.Exists(Path.Combine(pdfPath, "PDFs")))
            {
                pdfPath = Path.GetDirectoryName(pdfPath);
            }
            if (pdfPath == null || !Directory.Exists(Path.Combine(pdfPath, "PDFs")))
            {
                throw new Exception("File path for pdf files could not be found.");
            }

            return pdfPath + "\\PDFs";
        }
    }
}
