using System;
using System.IO;
using Foxit.PDF.Rasterizer;

namespace TiffImageFormat_Example
{
    class Program
    {
        static void Main(string[] args)
        {
            string pdfPath = GetPDFPath();

            //Create a PdfRasterizer
            PdfRasterizer rasterizer = new PdfRasterizer(Path.Combine(pdfPath, "DocumentA.pdf"));

            // Create a FixedImageSize object with required width and height.
            FixedImageSize fixedImageSize = new FixedImageSize(595, 841);

            //Create a TiffMonochromeColorFormat object with CcitGroup3 compression. 
            TiffMonochromeColorFormat oTiffColorFormat = new TiffMonochromeColorFormat(TiffMonochromeCompressionType.CcitGroup3);

            //Create a TiffImageFormat object with monocrome color.
            TiffImageFormat oTiffImageFormat = new TiffImageFormat(oTiffColorFormat);

            // Save the image.
            rasterizer.Draw("TiffImage.tif", oTiffImageFormat, fixedImageSize);
        }
        static string GetPDFPath()
        {
            string pdfPath = AppDomain.CurrentDomain.BaseDirectory;
            if (pdfPath.EndsWith(new string(Path.DirectorySeparatorChar, 1)))
            {
                pdfPath = Path.GetDirectoryName(pdfPath);
            }
            while (Directory.Exists(pdfPath) && !Directory.Exists(Path.Combine(pdfPath, "PDFs")))
            {
                pdfPath = Path.GetDirectoryName(pdfPath);
            }
            if (pdfPath == null || !Directory.Exists(Path.Combine(pdfPath, "PDFs")))
            {
                throw new Exception("File path for pdf files could not be found.");
            }

            return pdfPath + "\\PDFs";
        }
    }
}
